/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicLong;
import org.graphstream.graph.Graph;
import org.graphstream.stream.file.FileSink;

public abstract class FileSinkBase
implements FileSink {
    protected Writer output;

    @Override
    public void writeAll(Graph graph, String fileName) throws IOException {
        this.begin(fileName);
        this.exportGraph(graph);
        this.end();
    }

    @Override
    public void writeAll(Graph graph, OutputStream stream) throws IOException {
        this.begin(stream);
        this.exportGraph(graph);
        this.end();
    }

    @Override
    public void writeAll(Graph graph, Writer writer) throws IOException {
        this.begin(writer);
        this.exportGraph(graph);
        this.end();
    }

    protected void exportGraph(Graph graph) {
        String graphId = graph.getId();
        AtomicLong timeId = new AtomicLong(0L);
        graph.attributeKeys().forEach(key -> this.graphAttributeAdded(graphId, timeId.getAndIncrement(), (String)key, graph.getAttribute((String)key)));
        graph.nodes().forEach(node -> {
            String nodeId = node.getId();
            this.nodeAdded(graphId, timeId.getAndIncrement(), nodeId);
            node.attributeKeys().forEach(key -> this.nodeAttributeAdded(graphId, timeId.getAndIncrement(), nodeId, (String)key, node.getAttribute((String)key)));
        });
        graph.edges().forEach(edge -> {
            String edgeId = edge.getId();
            this.edgeAdded(graphId, timeId.getAndIncrement(), edgeId, edge.getNode0().getId(), edge.getNode1().getId(), edge.isDirected());
            edge.attributeKeys().forEach(key -> this.edgeAttributeAdded(graphId, timeId.getAndIncrement(), edgeId, (String)key, edge.getAttribute((String)key)));
        });
    }

    @Override
    public void begin(String fileName) throws IOException {
        if (this.output != null) {
            throw new IOException("cannot call begin() twice without calling end() before.");
        }
        this.output = this.createWriter(fileName);
        this.outputHeader();
    }

    @Override
    public void begin(OutputStream stream) throws IOException {
        if (this.output != null) {
            throw new IOException("cannot call begin() twice without calling end() before.");
        }
        this.output = this.createWriter(stream);
        this.outputHeader();
    }

    @Override
    public void begin(Writer writer) throws IOException {
        if (this.output != null) {
            throw new IOException("cannot call begin() twice without calling end() before.");
        }
        this.output = this.createWriter(writer);
        this.outputHeader();
    }

    @Override
    public void flush() throws IOException {
        if (this.output != null) {
            this.output.flush();
        }
    }

    @Override
    public void end() throws IOException {
        this.outputEndOfFile();
        this.output.flush();
        this.output.close();
        this.output = null;
    }

    protected abstract void outputHeader() throws IOException;

    protected abstract void outputEndOfFile() throws IOException;

    protected Writer createWriter(String fileName) throws IOException {
        return new PrintWriter(fileName);
    }

    protected Writer createWriter(OutputStream stream) throws IOException {
        return new PrintWriter(stream);
    }

    protected Writer createWriter(Writer writer) throws IOException {
        if (writer instanceof PrintWriter) {
            return writer;
        }
        return new PrintWriter(writer);
    }
}

