/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.swingViewer.util.GraphMetrics;
import org.graphstream.ui.util.swing.GradientFactory$;
import org.graphstream.ui.util.swing.ImageCache$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0001\u0003\u00015\u0011qc\u0012:ba\"\u0014\u0015mY6he>,h\u000e\u001a*f]\u0012,'/\u001a:\u000b\u0005\r!\u0011\u0001\u0003:f]\u0012,'/\u001a:\u000b\u0005\u00151\u0011!\u000363IZLWm^3s\u0015\t9\u0001\"\u0001\u0002vS*\u0011\u0011BC\u0001\fOJ\f\u0007\u000f[:ue\u0016\fWNC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011q#\b\b\u00031mi\u0011!\u0007\u0006\u00035\u0019\tAb\u001a:ba\"L7m\u0012:ba\"L!\u0001H\r\u0002\u001d\u001d\u0013\u0018\r\u001d5jG\u0016cW-\\3oi&\u0011ad\b\u0002\u0015'^LgnZ#mK6,g\u000e\u001e*f]\u0012,'/\u001a:\u000b\u0005qI\u0002\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0016\u0003\r\u0002\"\u0001\u0007\u0013\n\u0005\u0015J\"\u0001D$sCBD\u0017nY$sCBD\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\r\u001d\u0014\u0018\r\u001d5!\u0011!I\u0003A!b\u0001\n\u0003Q\u0013!B:us2,W#A\u0016\u0011\u0005aa\u0013BA\u0017\u001a\u0005)\u0019F/\u001f7f\u000fJ|W\u000f\u001d\u0005\t_\u0001\u0011\t\u0011)A\u0005W\u000511\u000f^=mK\u0002BQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtDcA\u001a6mA\u0011A\u0007A\u0007\u0002\u0005!)\u0011\u0005\ra\u0001G!)\u0011\u0006\ra\u0001W!)\u0001\b\u0001C\ts\u0005\u0011B-[:qY\u0006Lhj\u001c;iS:<Gk\u001c#p)\u0011Q\u0004IR&\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0003^\u0002\rAQ\u0001\u0004E\u000e\\\u0007CA\"E\u001b\u0005!\u0011BA#\u0005\u0005\u001d\u0011\u0015mY6f]\u0012DQaR\u001cA\u0002!\u000b\u0011a\u001e\t\u0003w%K!A\u0013\u001f\u0003\u0007%sG\u000fC\u0003Mo\u0001\u0007\u0001*A\u0001i\u0011\u0015q\u0005\u0001\"\u0001P\u0003\u0019\u0011XM\u001c3feR)!\bU)W/\")\u0011)\u0014a\u0001\u0005\")!+\u0014a\u0001'\u000611-Y7fe\u0006\u0004\"a\u0011+\n\u0005U#!AB\"b[\u0016\u0014\u0018\rC\u0003H\u001b\u0002\u0007\u0001\nC\u0003M\u001b\u0002\u0007\u0001\nC\u0003Z\u0001\u0011E!,A\u000bsK:$WM]$sCBD')Y2lOJ|WO\u001c3\u0015\u0007iZF\fC\u0003B1\u0002\u0007!\tC\u0003S1\u0002\u00071\u000bC\u0003_\u0001\u0011Eq,\u0001\bgS2d')Y2lOJ|WO\u001c3\u0015\u0007i\u0002\u0007\u000eC\u0003b;\u0002\u0007!-A\u0001h!\t\u0019g-D\u0001e\u0015\t)'#A\u0002boRL!a\u001a3\u0003\u0015\u001d\u0013\u0018\r\u001d5jGN\u0014D\tC\u0003S;\u0002\u00071\u000bC\u0003k\u0001\u0011E1.\u0001\u000bgS2d7)\u00198wCN\u0014\u0015mY6he>,h\u000e\u001a\u000b\u0004u1l\u0007\"B1j\u0001\u0004\u0011\u0007\"\u0002*j\u0001\u0004\u0019\u0006\"B8\u0001\t#\u0001\u0018A\u00044jY2LU.Y4f)&dW\r\u001a\u000b\u0004uE\u0014\b\"B1o\u0001\u0004\u0011\u0007\"\u0002*o\u0001\u0004\u0019\u0006\"\u0002;\u0001\t#)\u0018a\u00044jY2LU.Y4f'\u000e\fG.\u001a3\u0015\ti2x\u000f\u001f\u0005\u0006CN\u0004\rA\u0019\u0005\u0006%N\u0004\ra\u0015\u0005\u0006sN\u0004\r\u0001S\u0001\u0005[>$W\rC\u0003|\u0001\u0011EA0A\u0006tiJ|7.Z$sCBDGc\u0001\u001e~}\")\u0011I\u001fa\u0001\u0005\")!K\u001fa\u0001'\"9\u0011\u0011\u0001\u0001\u0005\u0012\u0005\r\u0011\u0001\u00044jY2<%/\u00193jK:$H#\u0002\u001e\u0002\u0006\u0005\u001d\u0001\"B1\u0000\u0001\u0004\u0011\u0007\"\u0002*\u0000\u0001\u0004\u0019\u0006")
public class GraphBackgroundRenderer
implements GraphicElement.SwingElementRenderer {
    private final GraphicGraph graph;
    private final StyleGroup style;

    public GraphicGraph graph() {
        return this.graph;
    }

    public StyleGroup style() {
        return this.style;
    }

    public void displayNothingToDo(Backend bck, int w, int h) {
        String msg1 = "Graph width/height/depth is zero !!";
        String msg2 = "Place components using the 'xyz' attribute.";
        Graphics2D g = bck.graphics2D();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.RED);
        g.drawLine(0, 0, w, h);
        g.drawLine(0, h, w, 0);
        int msg1length = g.getFontMetrics().stringWidth(msg1);
        int msg2length = g.getFontMetrics().stringWidth(msg2);
        int x = w / 2;
        int y = h / 2;
        g.setColor(Color.BLACK);
        g.drawString(msg1, x - msg1length / 2, y - 20);
        g.drawString(msg2, x - msg2length / 2, y + 20);
    }

    public void render(Backend bck, Camera camera, int w, int h) {
        if (camera.graphViewport() == null && camera.metrics().diagonal == 0.0 && this.graph().getNodeCount() == 0 && this.graph().getSpriteCount() == 0) {
            this.displayNothingToDo(bck, w, h);
        } else {
            this.renderGraphBackground(bck, camera);
            this.strokeGraph(bck, camera);
        }
    }

    public void renderGraphBackground(Backend bck, Camera camera) {
        Graphics2D g = bck.graphics2D();
        StyleConstants.FillMode fillMode = this.graph().getStyle().getFillMode();
        StyleConstants.FillMode fillMode2 = StyleConstants.FillMode.NONE;
        StyleConstants.FillMode fillMode3 = fillMode;
        if (!(fillMode2 != null ? !fillMode2.equals(fillMode3) : fillMode3 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            StyleConstants.FillMode fillMode4 = StyleConstants.FillMode.IMAGE_TILED;
            StyleConstants.FillMode fillMode5 = fillMode;
            if (!(fillMode4 != null ? !fillMode4.equals(fillMode5) : fillMode5 != null)) {
                this.fillImageTiled(g, camera);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                StyleConstants.FillMode fillMode6 = StyleConstants.FillMode.IMAGE_SCALED;
                StyleConstants.FillMode fillMode7 = fillMode;
                if (!(fillMode6 != null ? !fillMode6.equals(fillMode7) : fillMode7 != null)) {
                    this.fillImageScaled(g, camera, 0);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    StyleConstants.FillMode fillMode8 = StyleConstants.FillMode.IMAGE_SCALED_RATIO_MAX;
                    StyleConstants.FillMode fillMode9 = fillMode;
                    if (!(fillMode8 != null ? !fillMode8.equals(fillMode9) : fillMode9 != null)) {
                        this.fillImageScaled(g, camera, 1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        StyleConstants.FillMode fillMode10 = StyleConstants.FillMode.IMAGE_SCALED_RATIO_MIN;
                        StyleConstants.FillMode fillMode11 = fillMode;
                        if (!(fillMode10 != null ? !fillMode10.equals(fillMode11) : fillMode11 != null)) {
                            this.fillImageScaled(g, camera, 2);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            StyleConstants.FillMode fillMode12 = StyleConstants.FillMode.GRADIENT_DIAGONAL1;
                            StyleConstants.FillMode fillMode13 = fillMode;
                            if (!(fillMode12 != null ? !fillMode12.equals(fillMode13) : fillMode13 != null)) {
                                this.fillGradient(g, camera);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                StyleConstants.FillMode fillMode14 = StyleConstants.FillMode.GRADIENT_DIAGONAL2;
                                StyleConstants.FillMode fillMode15 = fillMode;
                                if (!(fillMode14 != null ? !fillMode14.equals(fillMode15) : fillMode15 != null)) {
                                    this.fillGradient(g, camera);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    StyleConstants.FillMode fillMode16 = StyleConstants.FillMode.GRADIENT_HORIZONTAL;
                                    StyleConstants.FillMode fillMode17 = fillMode;
                                    if (!(fillMode16 != null ? !fillMode16.equals(fillMode17) : fillMode17 != null)) {
                                        this.fillGradient(g, camera);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        StyleConstants.FillMode fillMode18 = StyleConstants.FillMode.GRADIENT_VERTICAL;
                                        StyleConstants.FillMode fillMode19 = fillMode;
                                        if (!(fillMode18 != null ? !fillMode18.equals(fillMode19) : fillMode19 != null)) {
                                            this.fillGradient(g, camera);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            StyleConstants.FillMode fillMode20 = StyleConstants.FillMode.GRADIENT_RADIAL;
                                            StyleConstants.FillMode fillMode21 = fillMode;
                                            if (!(fillMode20 != null ? !fillMode20.equals(fillMode21) : fillMode21 != null)) {
                                                this.fillGradient(g, camera);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                StyleConstants.FillMode fillMode22 = StyleConstants.FillMode.DYN_PLAIN;
                                                StyleConstants.FillMode fillMode23 = fillMode;
                                                if (!(fillMode22 != null ? !fillMode22.equals(fillMode23) : fillMode23 != null)) {
                                                    this.fillBackground(g, camera);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                } else {
                                                    this.fillBackground(g, camera);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void fillBackground(Graphics2D g, Camera camera) {
        GraphMetrics metrics = camera.metrics();
        g.setColor(this.style().getFillColor(0));
        g.fillRect(0, 0, (int)metrics.viewport[2], (int)metrics.viewport[3]);
    }

    public void fillCanvasBackground(Graphics2D g, Camera camera) {
        GraphMetrics metrics = camera.metrics();
        g.setColor(this.style().getCanvasColor(0));
        g.fillRect(0, 0, (int)metrics.viewport[2], (int)metrics.viewport[3]);
    }

    public void fillImageTiled(Graphics2D g, Camera camera) {
        GraphMetrics metrics = camera.metrics();
        double px2gu = metrics.ratioPx2Gu;
        BufferedImage img = null;
        Option<BufferedImage> option = ImageCache$.MODULE$.loadImage(this.style().getFillImage());
        if (option instanceof Some) {
            Some some = (Some)option;
            img = (BufferedImage)some.get();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            img = ImageCache$.MODULE$.dummyImage();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        double gw = metrics.graphWidthGU() * px2gu;
        double gh = metrics.graphHeightGU() * px2gu;
        double x = metrics.viewport[2] / (double)2 - gw / (double)2;
        double y = metrics.viewport[3] - metrics.viewport[3] / (double)2 - gh / (double)2;
        TexturePaint paint = new TexturePaint(img, new Rectangle2D.Double(x, y, img.getWidth(), img.getHeight()));
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, metrics.viewport[2], metrics.viewport[3]);
        g.setPaint(paint);
        g.fill(rect);
        g.setPaint(null);
    }

    public void fillImageScaled(Graphics2D g, Camera camera, int mode) {
        GraphMetrics metrics = camera.metrics();
        double px2gu = metrics.ratioPx2Gu;
        BufferedImage img = null;
        Option<BufferedImage> option = ImageCache$.MODULE$.loadImage(this.style().getFillImage());
        if (option instanceof Some) {
            Some some = (Some)option;
            img = (BufferedImage)some.get();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            img = ImageCache$.MODULE$.dummyImage();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.fillCanvasBackground(g, camera);
        double gw = metrics.graphWidthGU() * px2gu;
        double gh = metrics.graphHeightGU() * px2gu;
        double x = metrics.viewport[2] / (double)2 - gw / (double)2;
        double y = metrics.viewport[3] - metrics.viewport[3] / (double)2 - gh / (double)2;
        int n = mode;
        switch (n) {
            default: {
                throw new RuntimeException("WTF??");
            }
            case 2: {
                double ratioi = (double)img.getWidth() / (double)img.getHeight();
                double ratiog = gw / gh;
                if (ratiog > ratioi) {
                    double newgw = gh * ratioi;
                    double newx = x + (gw - newgw) / (double)2;
                    g.drawImage(img, (int)newx, (int)y, (int)(newx + newgw), (int)(y + gh), 0, 0, img.getWidth(), img.getHeight(), null);
                    break;
                }
                double newgh = gw / ratioi;
                double newy = y + (gh - newgh) / (double)2;
                g.drawImage(img, (int)x, (int)newy, (int)(x + gw), (int)(newy + newgh), 0, 0, img.getWidth(), img.getHeight(), null);
                break;
            }
            case 1: {
                double ratioi = (double)img.getWidth() / (double)img.getHeight();
                double ratiog = gw / gh;
                if (ratioi > ratiog) {
                    double newgw = gh * ratioi;
                    double newx = x - (newgw - gw) / (double)2;
                    g.drawImage(img, (int)newx, (int)y, (int)(newx + newgw), (int)(y + gh), 0, 0, img.getWidth(), img.getHeight(), null);
                    break;
                }
                double newgh = gw / ratioi;
                double newy = y - (newgh - gh) / (double)2;
                g.drawImage(img, (int)x, (int)newy, (int)(x + gw), (int)(newy + newgh), 0, 0, img.getWidth(), img.getHeight(), null);
                break;
            }
            case 0: {
                g.drawImage(img, (int)x, (int)y, (int)(x + gw), (int)(y + gh), 0, 0, img.getWidth(), img.getHeight(), null);
            }
        }
    }

    public void strokeGraph(Backend bck, Camera camera) {
        GraphMetrics metrics = camera.metrics();
        Graphics2D g = bck.graphics2D();
        StyleConstants.StrokeMode strokeMode = this.style().getStrokeMode();
        StyleConstants.StrokeMode strokeMode2 = StyleConstants.StrokeMode.NONE;
        if ((strokeMode == null ? strokeMode2 != null : !strokeMode.equals(strokeMode2)) && this.style().getStrokeWidth().value > 0.0) {
            g.setColor(this.style().getStrokeColor(0));
            g.setStroke(new BasicStroke((float)metrics.lengthToGu(this.style().getStrokeWidth())));
            int padx = (int)metrics.lengthToPx(this.style().getPadding(), 0);
            int pady = this.style().getPadding().size() > 1 ? (int)metrics.lengthToPx(this.style().getPadding(), 1) : padx;
            g.drawRect(padx, pady, (int)metrics.viewport[2] - padx * 2, (int)metrics.viewport[3] - pady * 2);
        }
    }

    public void fillGradient(Graphics2D g, Camera camera) {
        GraphMetrics metrics = camera.metrics();
        if (this.style().getFillColors().size() < 2) {
            this.fillBackground(g, camera);
        } else {
            int w = (int)metrics.viewport[2];
            int h = (int)metrics.viewport[3];
            g.setPaint(GradientFactory$.MODULE$.gradientInArea(0, 0, w, h, (Style)this.style()));
            g.fillRect(0, 0, w, h);
            g.setPaint(null);
        }
    }

    public GraphBackgroundRenderer(GraphicGraph graph, StyleGroup style) {
        this.graph = graph;
        this.style = style;
    }
}

