/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer.shape.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.AreaSkeleton;
import org.graphstream.ui.j2dviewer.renderer.ConnectorSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton;
import org.graphstream.ui.j2dviewer.renderer.shape.Area$class;
import org.graphstream.ui.j2dviewer.renderer.shape.AreaOnConnector$class;
import org.graphstream.ui.j2dviewer.renderer.shape.Connector;
import org.graphstream.ui.j2dviewer.renderer.shape.OnConnector$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaOnConnectorShape;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaOnConnectorShape$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Fillable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Shadowable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeDecor;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapePaint;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeStroke;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Strokable$class;
import org.graphstream.ui.util.CubicCurve$;
import org.graphstream.ui.util.ShapeUtil$;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001#\tY\u0011I\u001d:po>sW\tZ4f\u0015\t\u0019A!A\u0003to&twM\u0003\u0002\u0006\r\u0005)1\u000f[1qK*\u0011q\u0001C\u0001\te\u0016tG-\u001a:fe*\u0011\u0011BC\u0001\nUJ\"g/[3xKJT!a\u0003\u0007\u0002\u0005UL'BA\u0007\u000f\u0003-9'/\u00199igR\u0014X-Y7\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0011\u0011DG\u0007\u0002\u0005%\u00111D\u0001\u0002\u0015\u0003J,\u0017m\u00148D_:tWm\u0019;peNC\u0017\r]3\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002CA\r\u0001\u0011\u001d\t\u0003A1A\u0005\u0002\t\n\u0001\u0002\u001e5f'\"\f\u0007/Z\u000b\u0002GA\u0011AE\f\b\u0003K1j\u0011A\n\u0006\u0003O!\nAaZ3p[*\u0011\u0011FK\u0001\u0004C^$(\"A\u0016\u0002\t)\fg/Y\u0005\u0003[\u0019\na\u0001U1uQJ\"\u0015BA\u00181\u0005\u0019!u.\u001e2mK*\u0011QF\n\u0005\u0007e\u0001\u0001\u000b\u0011B\u0012\u0002\u0013QDWm\u00155ba\u0016\u0004\u0003\"\u0002\u001b\u0001\t#)\u0014\u0001B7bW\u0016$2AN\u001d@!\t\u0019r'\u0003\u00029)\t!QK\\5u\u0011\u0015Q4\u00071\u0001<\u0003\r\u00117m\u001b\t\u0003yuj\u0011\u0001C\u0005\u0003}!\u0011qAQ1dW\u0016tG\rC\u0003Ag\u0001\u0007\u0011)\u0001\u0004dC6,'/\u0019\t\u0003y\tK!a\u0011\u0005\u0003\r\r\u000bW.\u001a:b\u0011\u0015)\u0005\u0001\"\u0005G\u0003)i\u0017m[3TQ\u0006$wn\u001e\u000b\u0004m\u001dC\u0005\"\u0002\u001eE\u0001\u0004Y\u0004\"\u0002!E\u0001\u0004\t\u0005\"\u0002\u001b\u0001\t#QEc\u0001\u001cL!\")A*\u0013a\u0001\u001b\u0006Iam\u001c:TQ\u0006$wn\u001e\t\u0003'9K!a\u0014\u000b\u0003\u000f\t{w\u000e\\3b]\")\u0001)\u0013a\u0001\u0003\")!\u000b\u0001C\t'\u0006QQ.Y6f\u001f:d\u0015N\\3\u0015\u0007Y\"V\u000bC\u0003M#\u0002\u0007Q\nC\u0003A#\u0002\u0007\u0011\tC\u0003X\u0001\u0011E\u0001,A\u0006nC.,wJ\\\"veZ,Gc\u0001\u001cZ5\")AJ\u0016a\u0001\u001b\")\u0001I\u0016a\u0001\u0003\")A\f\u0001C\u0001;\u0006a!/\u001a8eKJ\u001c\u0006.\u00193poR)aGX0aQ\")!h\u0017a\u0001w!)\u0001i\u0017a\u0001\u0003\")\u0011m\u0017a\u0001E\u00069Q\r\\3nK:$\bCA2g\u001b\u0005!'BA3\u000b\u000319'/\u00199iS\u000e<%/\u00199i\u0013\t9GM\u0001\bHe\u0006\u0004\b.[2FY\u0016lWM\u001c;\t\u000b%\\\u0006\u0019\u00016\u0002\tM\\W\r\u001c\t\u0003W2l\u0011AB\u0005\u0003[\u001a\u0011\u0001bU6fY\u0016$xN\u001c\u0005\u0006_\u0002!\t\u0001]\u0001\u0007e\u0016tG-\u001a:\u0015\u000bY\n(o\u001d;\t\u000bir\u0007\u0019A\u001e\t\u000b\u0001s\u0007\u0019A!\t\u000b\u0005t\u0007\u0019\u00012\t\u000b%t\u0007\u0019\u00016")
public class ArrowOnEdge
implements AreaOnConnectorShape {
    private final Path2D.Double theShape;
    private ShapePaint shadowPaint;
    private final Point2 theShadowWidth;
    private final Point2 theShadowOff;
    private Color strokeColor;
    private ShapeStroke theStroke;
    private double theStrokeWidth;
    private ShapePaint fillPaint;
    private double theFillPercent;
    private Color theFillColor;
    private boolean plainFast;
    private GraphicEdge theEdge;
    private Connector theConnector;
    private final Point2 theCenter;
    private final Point2 theSize;
    private boolean fit;

    @Override
    public void configureForGroup(Backend bck, Style style, Camera camera) {
        AreaOnConnectorShape$class.configureForGroup(this, bck, style, camera);
    }

    @Override
    public void configureForElement(Backend bck, GraphicElement element, Skeleton skel, Camera camera) {
        AreaOnConnectorShape$class.configureForElement(this, bck, element, skel, camera);
    }

    @Override
    public ShapePaint shadowPaint() {
        return this.shadowPaint;
    }

    @Override
    public void shadowPaint_$eq(ShapePaint x$1) {
        this.shadowPaint = x$1;
    }

    @Override
    public Point2 theShadowWidth() {
        return this.theShadowWidth;
    }

    @Override
    public Point2 theShadowOff() {
        return this.theShadowOff;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowWidth_$eq(Point2 x$1) {
        this.theShadowWidth = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowOff_$eq(Point2 x$1) {
        this.theShadowOff = x$1;
    }

    @Override
    public void shadowWidth(double width, double height) {
        Shadowable$class.shadowWidth(this, width, height);
    }

    @Override
    public void shadowOffset(double xoff, double yoff) {
        Shadowable$class.shadowOffset(this, xoff, yoff);
    }

    @Override
    public void cast(Graphics2D g, Shape shape) {
        Shadowable$class.cast(this, g, shape);
    }

    @Override
    public void configureShadowableForGroup(Style style, Camera camera) {
        Shadowable$class.configureShadowableForGroup(this, style, camera);
    }

    @Override
    public Color strokeColor() {
        return this.strokeColor;
    }

    @Override
    public void strokeColor_$eq(Color x$1) {
        this.strokeColor = x$1;
    }

    @Override
    public ShapeStroke theStroke() {
        return this.theStroke;
    }

    @Override
    public void theStroke_$eq(ShapeStroke x$1) {
        this.theStroke = x$1;
    }

    @Override
    public double theStrokeWidth() {
        return this.theStrokeWidth;
    }

    @Override
    public void theStrokeWidth_$eq(double x$1) {
        this.theStrokeWidth = x$1;
    }

    @Override
    public void stroke(Graphics2D g, Shape shape) {
        Strokable$class.stroke(this, g, shape);
    }

    @Override
    public void configureStrokableForGroup(Style style, Camera camera) {
        Strokable$class.configureStrokableForGroup(this, style, camera);
    }

    @Override
    public ShapePaint fillPaint() {
        return this.fillPaint;
    }

    @Override
    public void fillPaint_$eq(ShapePaint x$1) {
        this.fillPaint = x$1;
    }

    @Override
    public double theFillPercent() {
        return this.theFillPercent;
    }

    @Override
    public void theFillPercent_$eq(double x$1) {
        this.theFillPercent = x$1;
    }

    @Override
    public Color theFillColor() {
        return this.theFillColor;
    }

    @Override
    public void theFillColor_$eq(Color x$1) {
        this.theFillColor = x$1;
    }

    @Override
    public boolean plainFast() {
        return this.plainFast;
    }

    @Override
    public void plainFast_$eq(boolean x$1) {
        this.plainFast = x$1;
    }

    @Override
    public void fill(Graphics2D g, double dynColor, Color optColor, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, dynColor, optColor, shape, camera);
    }

    @Override
    public void fill(Graphics2D g, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, shape, camera);
    }

    @Override
    public void configureFillableForGroup(Backend bck, Style style, Camera camera) {
        Fillable$class.configureFillableForGroup(this, bck, style, camera);
    }

    @Override
    public void configureFillableForElement(Style style, Camera camera, GraphicElement element) {
        Fillable$class.configureFillableForElement(this, style, camera, element);
    }

    @Override
    public GraphicEdge theEdge() {
        return this.theEdge;
    }

    @Override
    @TraitSetter
    public void theEdge_$eq(GraphicEdge x$1) {
        this.theEdge = x$1;
    }

    @Override
    public void configureAreaOnConnectorForGroup(Style style, Camera camera) {
        AreaOnConnector$class.configureAreaOnConnectorForGroup(this, style, camera);
    }

    @Override
    public void configureAreaOnConnectorForElement(GraphicEdge edge, Style style, Camera camera) {
        AreaOnConnector$class.configureAreaOnConnectorForElement(this, edge, style, camera);
    }

    @Override
    public Connector theConnector() {
        return this.theConnector;
    }

    @Override
    @TraitSetter
    public void theConnector_$eq(Connector x$1) {
        this.theConnector = x$1;
    }

    @Override
    public void theConnectorYoureAttachedTo(Connector connector) {
        OnConnector$class.theConnectorYoureAttachedTo(this, connector);
    }

    @Override
    public Point2 theCenter() {
        return this.theCenter;
    }

    @Override
    public Point2 theSize() {
        return this.theSize;
    }

    @Override
    public boolean fit() {
        return this.fit;
    }

    @Override
    @TraitSetter
    public void fit_$eq(boolean x$1) {
        this.fit = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$Area$_setter_$theCenter_$eq(Point2 x$1) {
        this.theCenter = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$Area$_setter_$theSize_$eq(Point2 x$1) {
        this.theSize = x$1;
    }

    @Override
    public void configureAreaForGroup(Style style, Camera camera) {
        Area$class.configureAreaForGroup(this, style, camera);
    }

    @Override
    public void configureAreaForElement(Backend backend, Camera camera, AreaSkeleton skel, GraphicElement element, ShapeDecor decor) {
        Area$class.configureAreaForElement(this, backend, camera, skel, element, decor);
    }

    public Path2D.Double theShape() {
        return this.theShape;
    }

    @Override
    public void make(Backend bck, Camera camera) {
        this.make(false, camera);
    }

    @Override
    public void makeShadow(Backend bck, Camera camera) {
        this.make(true, camera);
    }

    public void make(boolean forShadow, Camera camera) {
        if (this.theConnector().skel().isCurve()) {
            this.makeOnCurve(forShadow, camera);
        } else {
            this.makeOnLine(forShadow, camera);
        }
    }

    public void makeOnLine(boolean forShadow, Camera camera) {
        Vector2 vector2;
        ConnectorSkeleton skel = this.theConnector().skel();
        double off = 0.0;
        if (skel.isPoly()) {
            off = ShapeUtil$.MODULE$.evalTargetRadius2D(skel.apply(skel.size() - 2), skel.to(), this.theEdge().to, camera);
            vector2 = new Vector2(skel.to().x - skel.apply((int)(skel.size() - 2)).x, skel.to().y - skel.apply((int)(skel.size() - 2)).y);
        } else {
            off = ShapeUtil$.MODULE$.evalTargetRadius2D(skel.from(), skel.to(), this.theEdge().to, camera);
            vector2 = new Vector2(skel.to().x - skel.from().x, skel.to().y - skel.from().y);
        }
        Vector2 theDirection = vector2;
        theDirection.normalize();
        double x = this.theCenter().x - theDirection.x() * off;
        double y = this.theCenter().y - theDirection.y() * off;
        Vector2 perp = new Vector2(theDirection.y(), -theDirection.x());
        perp.normalize();
        theDirection.scalarMult(this.theSize().x);
        perp.scalarMult(this.theSize().y);
        if (forShadow) {
            x += this.theShadowOff().x;
            y += this.theShadowOff().y;
        }
        this.theShape().reset();
        this.theShape().moveTo(x, y);
        this.theShape().lineTo(x - theDirection.x() + perp.x(), y - theDirection.y() + perp.y());
        this.theShape().lineTo(x - theDirection.x() - perp.x(), y - theDirection.y() - perp.y());
        this.theShape().closePath();
    }

    public void makeOnCurve(boolean forShadow, Camera camera) {
        Tuple2<Point2, Object> tuple2 = CubicCurve$.MODULE$.approxIntersectionPointOnCurve(this.theEdge(), this.theConnector(), camera);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Point2 p1 = (Point2)tuple2._1();
            double t = tuple2._2$mcD$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)p1, (Object)BoxesRunTime.boxToDouble((double)t));
            Point2 p12 = (Point2)tuple23._1();
            double t2 = tuple23._2$mcD$sp();
            StyleGroup style = this.theEdge().getStyle();
            Point3 p2 = CubicCurve$.MODULE$.eval(this.theConnector().fromPos(), this.theConnector().byPos1(), this.theConnector().byPos2(), this.theConnector().toPos(), t2 - (double)0.05f);
            Vector2 dir = new Vector2(p12.x - p2.x, p12.y - p2.y);
            dir.normalize();
            dir.scalarMult(this.theSize().x);
            Vector2 per = new Vector2(dir.y(), -dir.x());
            per.normalize();
            per.scalarMult(this.theSize().y);
            this.theShape().reset();
            this.theShape().moveTo(p12.x, p12.y);
            this.theShape().lineTo(p12.x - dir.x() + per.x(), p12.y - dir.y() + per.y());
            this.theShape().lineTo(p12.x - dir.x() - per.x(), p12.y - dir.y() - per.y());
            this.theShape().closePath();
            return;
        }
        throw new MatchError(tuple2);
    }

    @Override
    public void renderShadow(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        this.make(true, camera);
        this.cast(bck.graphics2D(), this.theShape());
    }

    @Override
    public void render(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        Graphics2D g = bck.graphics2D();
        this.make(false, camera);
        this.stroke(g, this.theShape());
        this.fill(g, this.theShape(), camera);
    }

    public ArrowOnEdge() {
        Area$class.$init$(this);
        OnConnector$class.$init$(this);
        AreaOnConnector$class.$init$(this);
        Fillable$class.$init$(this);
        Strokable$class.$init$(this);
        Shadowable$class.$init$(this);
        AreaOnConnectorShape$class.$init$(this);
        this.theShape = new Path2D.Double();
    }
}

