/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer.shape.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.AreaSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton;
import org.graphstream.ui.j2dviewer.renderer.shape.Area$class;
import org.graphstream.ui.j2dviewer.renderer.shape.AreaOnConnector$class;
import org.graphstream.ui.j2dviewer.renderer.shape.Connector;
import org.graphstream.ui.j2dviewer.renderer.shape.OnConnector$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaOnConnectorShape;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaOnConnectorShape$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Fillable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Shadowable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeDecor;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapePaint;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeStroke;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Strokable$class;
import org.graphstream.ui.util.CubicCurve$;
import org.graphstream.ui.util.ShapeUtil$;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001#\tiA)[1n_:$wJ\\#eO\u0016T!a\u0001\u0003\u0002\u000bM<\u0018N\\4\u000b\u0005\u00151\u0011!B:iCB,'BA\u0004\t\u0003!\u0011XM\u001c3fe\u0016\u0014(BA\u0005\u000b\u0003%Q'\u0007\u001a<jK^,'O\u0003\u0002\f\u0019\u0005\u0011Q/\u001b\u0006\u0003\u001b9\t1b\u001a:ba\"\u001cHO]3b[*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u0005Q\t%/Z1P]\u000e{gN\\3di>\u00148\u000b[1qK\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u00033\u0001Aq!\t\u0001C\u0002\u0013\u0005!%\u0001\u0005uQ\u0016\u001c\u0006.\u00199f+\u0005\u0019\u0003C\u0001\u0013/\u001d\t)C&D\u0001'\u0015\t9\u0003&\u0001\u0003hK>l'BA\u0015+\u0003\r\tw\u000f\u001e\u0006\u0002W\u0005!!.\u0019<b\u0013\tic%\u0001\u0004QCRD'\u0007R\u0005\u0003_A\u0012a\u0001R8vE2,'BA\u0017'\u0011\u0019\u0011\u0004\u0001)A\u0005G\u0005IA\u000f[3TQ\u0006\u0004X\r\t\u0005\u0006i\u0001!\t\"N\u0001\u0005[\u0006\\W\rF\u00027s}\u0002\"aE\u001c\n\u0005a\"\"\u0001B+oSRDQAO\u001aA\u0002m\n1AY2l!\taT(D\u0001\t\u0013\tq\u0004BA\u0004CC\u000e\\WM\u001c3\t\u000b\u0001\u001b\u0004\u0019A!\u0002\r\r\fW.\u001a:b!\ta$)\u0003\u0002D\u0011\t11)Y7fe\u0006DQ!\u0012\u0001\u0005\u0012\u0019\u000b!\"\\1lKNC\u0017\rZ8x)\r1t\t\u0013\u0005\u0006u\u0011\u0003\ra\u000f\u0005\u0006\u0001\u0012\u0003\r!\u0011\u0005\u0006i\u0001!\tB\u0013\u000b\u0004m-\u0003\u0006\"\u0002'J\u0001\u0004i\u0015!\u00034peNC\u0017\rZ8x!\t\u0019b*\u0003\u0002P)\t9!i\\8mK\u0006t\u0007\"\u0002!J\u0001\u0004\t\u0005\"\u0002*\u0001\t#\u0019\u0016AC7bW\u0016|e\u000eT5oKR\u0019a\u0007V+\t\u000b1\u000b\u0006\u0019A'\t\u000b\u0001\u000b\u0006\u0019A!\t\u000b]\u0003A\u0011\u0003-\u0002\u00175\f7.Z(o\u0007V\u0014h/\u001a\u000b\u0004meS\u0006\"\u0002'W\u0001\u0004i\u0005\"\u0002!W\u0001\u0004\t\u0005\"\u0002/\u0001\t\u0003i\u0016\u0001\u0004:f]\u0012,'o\u00155bI><H#\u0002\u001c_?\u0002D\u0007\"\u0002\u001e\\\u0001\u0004Y\u0004\"\u0002!\\\u0001\u0004\t\u0005\"B1\\\u0001\u0004\u0011\u0017aB3mK6,g\u000e\u001e\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K*\tAb\u001a:ba\"L7m\u0012:ba\"L!a\u001a3\u0003\u001d\u001d\u0013\u0018\r\u001d5jG\u0016cW-\\3oi\")\u0011n\u0017a\u0001U\u0006!1o[3m!\tYG.D\u0001\u0007\u0013\tigA\u0001\u0005TW\u0016dW\r^8o\u0011\u0015y\u0007\u0001\"\u0001q\u0003\u0019\u0011XM\u001c3feR)a'\u001d:ti\")!H\u001ca\u0001w!)\u0001I\u001ca\u0001\u0003\")\u0011M\u001ca\u0001E\")\u0011N\u001ca\u0001U\u0002")
public class DiamondOnEdge
implements AreaOnConnectorShape {
    private final Path2D.Double theShape;
    private ShapePaint shadowPaint;
    private final Point2 theShadowWidth;
    private final Point2 theShadowOff;
    private Color strokeColor;
    private ShapeStroke theStroke;
    private double theStrokeWidth;
    private ShapePaint fillPaint;
    private double theFillPercent;
    private Color theFillColor;
    private boolean plainFast;
    private GraphicEdge theEdge;
    private Connector theConnector;
    private final Point2 theCenter;
    private final Point2 theSize;
    private boolean fit;

    @Override
    public void configureForGroup(Backend bck, Style style, Camera camera) {
        AreaOnConnectorShape$class.configureForGroup(this, bck, style, camera);
    }

    @Override
    public void configureForElement(Backend bck, GraphicElement element, Skeleton skel, Camera camera) {
        AreaOnConnectorShape$class.configureForElement(this, bck, element, skel, camera);
    }

    @Override
    public ShapePaint shadowPaint() {
        return this.shadowPaint;
    }

    @Override
    public void shadowPaint_$eq(ShapePaint x$1) {
        this.shadowPaint = x$1;
    }

    @Override
    public Point2 theShadowWidth() {
        return this.theShadowWidth;
    }

    @Override
    public Point2 theShadowOff() {
        return this.theShadowOff;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowWidth_$eq(Point2 x$1) {
        this.theShadowWidth = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowOff_$eq(Point2 x$1) {
        this.theShadowOff = x$1;
    }

    @Override
    public void shadowWidth(double width, double height) {
        Shadowable$class.shadowWidth(this, width, height);
    }

    @Override
    public void shadowOffset(double xoff, double yoff) {
        Shadowable$class.shadowOffset(this, xoff, yoff);
    }

    @Override
    public void cast(Graphics2D g, Shape shape) {
        Shadowable$class.cast(this, g, shape);
    }

    @Override
    public void configureShadowableForGroup(Style style, Camera camera) {
        Shadowable$class.configureShadowableForGroup(this, style, camera);
    }

    @Override
    public Color strokeColor() {
        return this.strokeColor;
    }

    @Override
    public void strokeColor_$eq(Color x$1) {
        this.strokeColor = x$1;
    }

    @Override
    public ShapeStroke theStroke() {
        return this.theStroke;
    }

    @Override
    public void theStroke_$eq(ShapeStroke x$1) {
        this.theStroke = x$1;
    }

    @Override
    public double theStrokeWidth() {
        return this.theStrokeWidth;
    }

    @Override
    public void theStrokeWidth_$eq(double x$1) {
        this.theStrokeWidth = x$1;
    }

    @Override
    public void stroke(Graphics2D g, Shape shape) {
        Strokable$class.stroke(this, g, shape);
    }

    @Override
    public void configureStrokableForGroup(Style style, Camera camera) {
        Strokable$class.configureStrokableForGroup(this, style, camera);
    }

    @Override
    public ShapePaint fillPaint() {
        return this.fillPaint;
    }

    @Override
    public void fillPaint_$eq(ShapePaint x$1) {
        this.fillPaint = x$1;
    }

    @Override
    public double theFillPercent() {
        return this.theFillPercent;
    }

    @Override
    public void theFillPercent_$eq(double x$1) {
        this.theFillPercent = x$1;
    }

    @Override
    public Color theFillColor() {
        return this.theFillColor;
    }

    @Override
    public void theFillColor_$eq(Color x$1) {
        this.theFillColor = x$1;
    }

    @Override
    public boolean plainFast() {
        return this.plainFast;
    }

    @Override
    public void plainFast_$eq(boolean x$1) {
        this.plainFast = x$1;
    }

    @Override
    public void fill(Graphics2D g, double dynColor, Color optColor, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, dynColor, optColor, shape, camera);
    }

    @Override
    public void fill(Graphics2D g, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, shape, camera);
    }

    @Override
    public void configureFillableForGroup(Backend bck, Style style, Camera camera) {
        Fillable$class.configureFillableForGroup(this, bck, style, camera);
    }

    @Override
    public void configureFillableForElement(Style style, Camera camera, GraphicElement element) {
        Fillable$class.configureFillableForElement(this, style, camera, element);
    }

    @Override
    public GraphicEdge theEdge() {
        return this.theEdge;
    }

    @Override
    @TraitSetter
    public void theEdge_$eq(GraphicEdge x$1) {
        this.theEdge = x$1;
    }

    @Override
    public void configureAreaOnConnectorForGroup(Style style, Camera camera) {
        AreaOnConnector$class.configureAreaOnConnectorForGroup(this, style, camera);
    }

    @Override
    public void configureAreaOnConnectorForElement(GraphicEdge edge, Style style, Camera camera) {
        AreaOnConnector$class.configureAreaOnConnectorForElement(this, edge, style, camera);
    }

    @Override
    public Connector theConnector() {
        return this.theConnector;
    }

    @Override
    @TraitSetter
    public void theConnector_$eq(Connector x$1) {
        this.theConnector = x$1;
    }

    @Override
    public void theConnectorYoureAttachedTo(Connector connector) {
        OnConnector$class.theConnectorYoureAttachedTo(this, connector);
    }

    @Override
    public Point2 theCenter() {
        return this.theCenter;
    }

    @Override
    public Point2 theSize() {
        return this.theSize;
    }

    @Override
    public boolean fit() {
        return this.fit;
    }

    @Override
    @TraitSetter
    public void fit_$eq(boolean x$1) {
        this.fit = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$Area$_setter_$theCenter_$eq(Point2 x$1) {
        this.theCenter = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$Area$_setter_$theSize_$eq(Point2 x$1) {
        this.theSize = x$1;
    }

    @Override
    public void configureAreaForGroup(Style style, Camera camera) {
        Area$class.configureAreaForGroup(this, style, camera);
    }

    @Override
    public void configureAreaForElement(Backend backend, Camera camera, AreaSkeleton skel, GraphicElement element, ShapeDecor decor) {
        Area$class.configureAreaForElement(this, backend, camera, skel, element, decor);
    }

    public Path2D.Double theShape() {
        return this.theShape;
    }

    @Override
    public void make(Backend bck, Camera camera) {
        this.make(false, camera);
    }

    @Override
    public void makeShadow(Backend bck, Camera camera) {
        this.make(true, camera);
    }

    public void make(boolean forShadow, Camera camera) {
        if (this.theConnector().skel().isCurve()) {
            this.makeOnCurve(forShadow, camera);
        } else {
            this.makeOnLine(forShadow, camera);
        }
    }

    public void makeOnLine(boolean forShadow, Camera camera) {
        double off = ShapeUtil$.MODULE$.evalTargetRadius2D(this.theEdge(), camera);
        Vector2 theDirection = new Vector2(this.theConnector().toPos().x - this.theConnector().fromPos().x, this.theConnector().toPos().y - this.theConnector().fromPos().y);
        theDirection.normalize();
        double x = this.theCenter().x - theDirection.x() * off;
        double y = this.theCenter().y - theDirection.y() * off;
        Vector2 perp = new Vector2(theDirection.y(), -theDirection.x());
        perp.normalize();
        theDirection.scalarMult(this.theSize().x / (double)2);
        perp.scalarMult(this.theSize().y);
        if (forShadow) {
            x += this.theShadowOff().x;
            y += this.theShadowOff().y;
        }
        this.theShape().reset();
        this.theShape().moveTo(x, y);
        this.theShape().lineTo(x - theDirection.x() + perp.x(), y - theDirection.y() + perp.y());
        this.theShape().lineTo(x - theDirection.x() * (double)2, y - theDirection.y() * (double)2);
        this.theShape().lineTo(x - theDirection.x() - perp.x(), y - theDirection.y() - perp.y());
        this.theShape().closePath();
    }

    public void makeOnCurve(boolean forShadow, Camera camera) {
        Tuple2<Point2, Object> tuple2 = CubicCurve$.MODULE$.approxIntersectionPointOnCurve(this.theEdge(), this.theConnector(), camera);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Point2 p1 = (Point2)tuple2._1();
            double t = tuple2._2$mcD$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)p1, (Object)BoxesRunTime.boxToDouble((double)t));
            Point2 p12 = (Point2)tuple23._1();
            double t2 = tuple23._2$mcD$sp();
            StyleGroup style = this.theEdge().getStyle();
            Point3 p2 = CubicCurve$.MODULE$.eval(this.theConnector().fromPos(), this.theConnector().byPos1(), this.theConnector().byPos2(), this.theConnector().toPos(), t2 - (double)0.1f);
            Vector2 dir = new Vector2(p12.x - p2.x, p12.y - p2.y);
            dir.normalize();
            dir.scalarMult(this.theSize().x);
            Vector2 per = new Vector2(dir.y(), -dir.x());
            per.normalize();
            per.scalarMult(this.theSize().y);
            this.theShape().reset();
            this.theShape().moveTo(p12.x, p12.y);
            this.theShape().lineTo(p12.x - dir.x() / (double)2 + per.x(), p12.y - dir.y() / (double)2 + per.y());
            this.theShape().lineTo(p12.x - dir.x(), p12.y - dir.y());
            this.theShape().lineTo(p12.x - dir.x() / (double)2 - per.x(), p12.y - dir.y() / (double)2 - per.y());
            this.theShape().closePath();
            return;
        }
        throw new MatchError(tuple2);
    }

    @Override
    public void renderShadow(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        this.make(true, camera);
        this.cast(bck.graphics2D(), this.theShape());
    }

    @Override
    public void render(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        Graphics2D g = bck.graphics2D();
        this.make(false, camera);
        this.stroke(g, this.theShape());
        this.fill(g, this.theShape(), camera);
    }

    public DiamondOnEdge() {
        Area$class.$init$(this);
        OnConnector$class.$init$(this);
        AreaOnConnector$class.$init$(this);
        Fillable$class.$init$(this);
        Strokable$class.$init$(this);
        Shadowable$class.$init$(this);
        AreaOnConnectorShape$class.$init$(this);
        this.theShape = new Path2D.Double();
    }
}

