/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.util.swing;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.util.List;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class GradientFactory$ {
    public static final GradientFactory$ MODULE$;
    private final float[][] predefFractions;
    private final float[] predefFractions2;
    private final float[] predefFractions3;
    private final float[] predefFractions4;
    private final float[] predefFractions5;
    private final float[] predefFractions6;
    private final float[] predefFractions7;
    private final float[] predefFractions8;
    private final float[] predefFractions9;
    private final float[] predefFractions10;
    private final String version;
    private boolean version16;

    static {
        new GradientFactory$();
    }

    public Paint gradientInArea(int x0, int y0, int width, int height, Style style) {
        Paint paint;
        StyleConstants.FillMode fillMode = style.getFillMode();
        StyleConstants.FillMode fillMode2 = StyleConstants.FillMode.GRADIENT_VERTICAL;
        StyleConstants.FillMode fillMode3 = fillMode;
        if (!(fillMode2 != null ? !fillMode2.equals(fillMode3) : fillMode3 != null)) {
            paint = this.linearGradientFromStyle(x0, y0 + height, x0, y0, style);
        } else {
            StyleConstants.FillMode fillMode4 = StyleConstants.FillMode.GRADIENT_HORIZONTAL;
            StyleConstants.FillMode fillMode5 = fillMode;
            if (!(fillMode4 != null ? !fillMode4.equals(fillMode5) : fillMode5 != null)) {
                paint = this.linearGradientFromStyle(x0, y0, x0 + width, y0, style);
            } else {
                StyleConstants.FillMode fillMode6 = StyleConstants.FillMode.GRADIENT_DIAGONAL1;
                StyleConstants.FillMode fillMode7 = fillMode;
                if (!(fillMode6 != null ? !fillMode6.equals(fillMode7) : fillMode7 != null)) {
                    paint = this.linearGradientFromStyle(x0, y0 + height, x0 + width, y0, style);
                } else {
                    StyleConstants.FillMode fillMode8 = StyleConstants.FillMode.GRADIENT_DIAGONAL2;
                    StyleConstants.FillMode fillMode9 = fillMode;
                    if (!(fillMode8 != null ? !fillMode8.equals(fillMode9) : fillMode9 != null)) {
                        paint = this.linearGradientFromStyle(x0, y0, x0 + width, y0 + height, style);
                    } else {
                        StyleConstants.FillMode fillMode10 = StyleConstants.FillMode.GRADIENT_RADIAL;
                        StyleConstants.FillMode fillMode11 = fillMode;
                        paint = !(fillMode10 != null ? !fillMode10.equals(fillMode11) : fillMode11 != null) ? this.radialGradientFromStyle(x0 + width / 2, y0 + height / 2, width > height ? (double)(width / 2) : (double)(height / 2), style) : null;
                    }
                }
            }
        }
        return paint;
    }

    public Paint linearGradientFromStyle(double x0, double y0, double x1, double y1, Style style) {
        Paint paint = null;
        Serializable gradientPaint = new Serializable(x0, y0, x1, y1, style){
            public static final long serialVersionUID = 0L;
            private final double x0$1;
            private final double y0$1;
            private final double x1$1;
            private final double y1$1;
            private final Style style$1;

            public final Paint apply() {
                return GradientFactory$.MODULE$.version16() ? new LinearGradientPaint((float)this.x0$1, (float)this.y0$1, (float)this.x1$1, (float)this.y1$1, GradientFactory$.MODULE$.createFractions(this.style$1), GradientFactory$.MODULE$.createColors(this.style$1)) : new GradientPaint((float)this.x0$1, (float)this.y0$1, this.style$1.getFillColor(0), (float)this.x1$1, (float)this.y1$1, this.style$1.getFillColor(1));
            }
            {
                this.x0$1 = x0$1;
                this.y0$1 = y0$1;
                this.x1$1 = x1$1;
                this.y1$1 = y1$1;
                this.style$1 = style$1;
            }
        };
        if (style.getFillColorCount() > 1) {
            StyleConstants.FillMode fillMode = style.getFillMode();
            StyleConstants.FillMode fillMode2 = StyleConstants.FillMode.GRADIENT_DIAGONAL1;
            StyleConstants.FillMode fillMode3 = fillMode;
            if (!(fillMode2 != null ? !fillMode2.equals(fillMode3) : fillMode3 != null)) {
                paint = (Paint)gradientPaint.apply();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                StyleConstants.FillMode fillMode4 = StyleConstants.FillMode.GRADIENT_DIAGONAL2;
                StyleConstants.FillMode fillMode5 = fillMode;
                if (!(fillMode4 != null ? !fillMode4.equals(fillMode5) : fillMode5 != null)) {
                    paint = (Paint)gradientPaint.apply();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    StyleConstants.FillMode fillMode6 = StyleConstants.FillMode.GRADIENT_HORIZONTAL;
                    StyleConstants.FillMode fillMode7 = fillMode;
                    if (!(fillMode6 != null ? !fillMode6.equals(fillMode7) : fillMode7 != null)) {
                        paint = (Paint)gradientPaint.apply();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        StyleConstants.FillMode fillMode8 = StyleConstants.FillMode.GRADIENT_VERTICAL;
                        StyleConstants.FillMode fillMode9 = fillMode;
                        if (!(fillMode8 != null ? !fillMode8.equals(fillMode9) : fillMode9 != null)) {
                            paint = (Paint)gradientPaint.apply();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                }
            }
        }
        return paint;
    }

    public Paint radialGradientFromStyle(double cx, double cy, double radius, Style style) {
        return this.radialGradientFromStyle(cx, cy, radius, cx, cy, style);
    }

    public Paint radialGradientFromStyle(double cx, double cy, double radius, double fx, double fy, Style style) {
        RadialGradientPaint paint = null;
        if (this.version16() && style.getFillColorCount() > 1) {
            StyleConstants.FillMode fillMode = style.getFillMode();
            StyleConstants.FillMode fillMode2 = StyleConstants.FillMode.GRADIENT_RADIAL;
            if (!(fillMode != null ? !fillMode.equals(fillMode2) : fillMode2 != null)) {
                float[] fractions = this.createFractions(style);
                Color[] colors = this.createColors(style);
                paint = new RadialGradientPaint((float)cx, (float)cy, (float)radius, (float)fx, (float)fy, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
            }
        }
        return paint;
    }

    /*
     * WARNING - void declaration
     */
    public float[] createFractions(Style style) {
        float[] fArray;
        int n = style.getFillColorCount();
        if (n < this.predefFractions.length) {
            fArray = this.predefFractions[n];
        } else {
            void var3_3;
            float[] fractions = new float[n];
            float div = 1.0f / (float)(n - 1);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)new Serializable(fractions, div){
                public static final long serialVersionUID = 0L;
                private final float[] fractions$1;
                private final float div$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.fractions$1[i] = this.div$1 * (float)i;
                }
                {
                    this.fractions$1 = fractions$1;
                    this.div$1 = div$1;
                }
            });
            fractions[0] = 0.0f;
            fractions[n - 1] = 1.0f;
            fArray = var3_3;
        }
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public Color[] createColors(Style style) {
        void var2_2;
        Color[] colors = new Color[style.getFillColorCount()];
        IntRef i = new IntRef(0);
        JavaConversions$.MODULE$.asScalaBuffer((List)style.getFillColors()).foreach((Function1)new Serializable(colors, i){
            public static final long serialVersionUID = 0L;
            private final Color[] colors$1;
            private final IntRef i$1;

            public final void apply(Color color) {
                this.colors$1[this.i$1.elem] = color;
                ++this.i$1.elem;
            }
            {
                this.colors$1 = colors$1;
                this.i$1 = i$1;
            }
        });
        return var2_2;
    }

    public String version() {
        return this.version;
    }

    public boolean version16() {
        return this.version16;
    }

    public void version16_$eq(boolean x$1) {
        this.version16 = x$1;
    }

    private GradientFactory$() {
        String v;
        int n;
        MODULE$ = this;
        this.predefFractions = new float[11][];
        this.predefFractions2 = new float[]{0.0f, 1.0f};
        this.predefFractions3 = new float[]{0.0f, 0.5f, 1.0f};
        this.predefFractions4 = new float[]{0.0f, 0.33f, 0.66f, 1.0f};
        this.predefFractions5 = new float[]{0.0f, 0.25f, 0.5f, 0.75f, 1.0f};
        this.predefFractions6 = new float[]{0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f};
        this.predefFractions7 = new float[]{0.0f, 0.1666f, 0.3333f, 0.4999f, 0.6666f, 0.8333f, 1.0f};
        this.predefFractions8 = new float[]{0.0f, 0.1428f, 0.2856f, 0.4284f, 0.5712f, 0.714f, 0.8568f, 1.0f};
        this.predefFractions9 = new float[]{0.0f, 0.125f, 0.25f, 0.375f, 0.5f, 0.625f, 0.75f, 0.875f, 1.0f};
        this.predefFractions10 = new float[]{0.0f, 0.1111f, 0.2222f, 0.3333f, 0.4444f, 0.5555f, 0.6666f, 0.7777f, 0.8888f, 1.0f};
        this.version = System.getProperty("java.version");
        this.version16 = false;
        if (this.version().startsWith("1.") && this.version().length() >= 3 && (n = Integer.parseInt(v = this.version().substring(2, 3))) >= 6) {
            this.version16_$eq(true);
        }
        this.predefFractions[0] = null;
        this.predefFractions[1] = null;
        this.predefFractions[2] = this.predefFractions2;
        this.predefFractions[3] = this.predefFractions3;
        this.predefFractions[4] = this.predefFractions4;
        this.predefFractions[5] = this.predefFractions5;
        this.predefFractions[6] = this.predefFractions6;
        this.predefFractions[7] = this.predefFractions7;
        this.predefFractions[8] = this.predefFractions8;
        this.predefFractions[9] = this.predefFractions9;
        this.predefFractions[10] = this.predefFractions10;
    }
}

