/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.definitions.response;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public interface Delay {
    public long inMilliseconds();

    public static Delay fixedDelay(long milliseconds) {
        return () -> milliseconds;
    }

    public static Delay randomDelay(long minMilliseconds, long maxMilliseconds) {
        return () -> ThreadLocalRandom.current().nextLong(minMilliseconds, maxMilliseconds);
    }

    default public void delayAction() {
        try {
            TimeUnit.MILLISECONDS.sleep(this.inMilliseconds());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

