/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.definitions.response;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.grpcmock.definitions.response.Delay;
import org.grpcmock.definitions.response.ResponseAction;
import org.grpcmock.definitions.response.steps.ObjectResponseActionBuilder;

public class ObjectResponseActionBuilderImpl<RespT>
implements ObjectResponseActionBuilder<RespT> {
    private final RespT responseObject;
    private Delay delay;

    public ObjectResponseActionBuilderImpl(@Nonnull RespT responseObject) {
        Objects.requireNonNull(responseObject);
        this.responseObject = responseObject;
    }

    @Override
    public ObjectResponseActionBuilderImpl<RespT> withDelay(@Nonnull Delay delay) {
        this.delay = delay;
        return this;
    }

    @Override
    public ResponseAction<RespT> build() {
        return responseObserver -> {
            Optional.ofNullable(this.delay).ifPresent(Delay::delayAction);
            responseObserver.onNext(this.responseObject);
        };
    }
}

