/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock;

import io.grpc.HandlerRegistry;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.Status;
import io.grpc.protobuf.services.BinaryLogProvider;
import io.grpc.stub.ServerCalls;
import io.grpc.util.MutableHandlerRegistry;
import javax.annotation.Nullable;
import org.grpcmock.util.FunctionalResponseObserver;

public final class DelegateHandlerRegistry
extends HandlerRegistry {
    private final MutableHandlerRegistry delegate = new MutableHandlerRegistry();

    public MutableHandlerRegistry getDelegate() {
        return this.delegate;
    }

    public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
        ServerMethodDefinition<byte[], byte[]> delegateDefinition = this.delegate.lookupMethod(methodName, authority);
        return delegateDefinition != null ? delegateDefinition : DelegateHandlerRegistry.notFoundServerMethod(methodName);
    }

    private static ServerMethodDefinition<byte[], byte[]> notFoundServerMethod(String fullMethodName) {
        return ServerMethodDefinition.create(DelegateHandlerRegistry.noopMethod(fullMethodName), DelegateHandlerRegistry.notFoundUnaryCall(fullMethodName));
    }

    private static ServerCallHandler<byte[], byte[]> notFoundUnaryCall(String fullMethodName) {
        return ServerCalls.asyncClientStreamingCall(responseObserver -> FunctionalResponseObserver.builder().onNext(ignore -> responseObserver.onError((Throwable)Status.UNIMPLEMENTED.withDescription(String.format("Method not found: %s", fullMethodName)).asRuntimeException())).build());
    }

    private static MethodDescriptor<byte[], byte[]> noopMethod(String fullMethodName) {
        return MethodDescriptor.newBuilder((MethodDescriptor.Marshaller)BinaryLogProvider.BYTEARRAY_MARSHALLER, (MethodDescriptor.Marshaller)BinaryLogProvider.BYTEARRAY_MARSHALLER).setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(fullMethodName).build();
    }
}

