/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.definitions.matcher.steps;

import io.grpc.Status;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.grpcmock.definitions.BuilderStep;

public interface StatusMatcherBuilderStep<BUILDER extends StatusMatcherBuilderStep<BUILDER>>
extends BuilderStep {
    public BUILDER withStatus(@Nonnull Predicate<Status> var1);

    default public BUILDER withStatusCode(@Nonnull Status.Code code) {
        return this.withStatus(status -> Objects.nonNull(status) && status.getCode() == code);
    }

    default public BUILDER withStatusOk() {
        return this.withStatusCode(Status.Code.OK);
    }

    default public BUILDER withStatusMessage(@Nullable String message) {
        return this.withStatus(status -> Objects.nonNull(status) && Objects.equals(message, status.getDescription()));
    }
}

