/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.definitions.stub;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.grpcmock.definitions.response.Response;
import org.grpcmock.definitions.response.ResponseImpl;
import org.grpcmock.definitions.response.ResponseProxyImpl;
import org.grpcmock.definitions.response.steps.ExceptionResponseActionBuilder;
import org.grpcmock.definitions.response.steps.ObjectResponseActionBuilder;
import org.grpcmock.definitions.response.steps.StreamResponseBuilder;
import org.grpcmock.definitions.stub.MethodStub;
import org.grpcmock.definitions.stub.StubScenario;
import org.grpcmock.definitions.stub.steps.NextServerStreamingMethodResponseBuilderStep;
import org.grpcmock.definitions.stub.steps.ServerStreamingMethodStubBuilderStep;
import org.grpcmock.definitions.verification.RequestPatternBuilderImpl;
import org.grpcmock.exception.GrpcMockException;

public final class ServerStreamingMethodStubBuilderImpl<ReqT, RespT>
implements ServerStreamingMethodStubBuilderStep<ReqT, RespT>,
NextServerStreamingMethodResponseBuilderStep<ReqT, RespT> {
    private final MethodDescriptor<ReqT, RespT> method;
    private final List<Response<ReqT, RespT>> responses;
    private final RequestPatternBuilderImpl<ReqT> requestPatternBuilder;

    public ServerStreamingMethodStubBuilderImpl(@Nonnull MethodDescriptor<ReqT, RespT> method) {
        Objects.requireNonNull(method);
        if (method.getType() != MethodDescriptor.MethodType.SERVER_STREAMING) {
            throw new GrpcMockException("This builder accepts only server streaming methods");
        }
        this.method = method;
        this.responses = new ArrayList<Response<ReqT, RespT>>();
        this.requestPatternBuilder = new RequestPatternBuilderImpl<ReqT>(method);
    }

    @Override
    public <T> ServerStreamingMethodStubBuilderStep<ReqT, RespT> withHeader(@Nonnull Metadata.Key<T> headerKey, @Nonnull Predicate<T> predicate) {
        this.requestPatternBuilder.withHeader((Metadata.Key)headerKey, (Predicate)predicate);
        return this;
    }

    @Override
    public ServerStreamingMethodStubBuilderStep<ReqT, RespT> withRequest(@Nonnull Predicate<ReqT> requestPredicate) {
        this.requestPatternBuilder.withRequest((Predicate)requestPredicate);
        return this;
    }

    @Override
    public NextServerStreamingMethodResponseBuilderStep<ReqT, RespT> willReturn(@Nonnull ObjectResponseActionBuilder<RespT> response) {
        Objects.requireNonNull(response);
        this.responses.add(new ResponseImpl(response.build()));
        return this;
    }

    @Override
    public NextServerStreamingMethodResponseBuilderStep<ReqT, RespT> willReturn(@Nonnull ExceptionResponseActionBuilder response) {
        Objects.requireNonNull(response);
        this.responses.add(new ResponseImpl(response.build()));
        return this;
    }

    @Override
    public NextServerStreamingMethodResponseBuilderStep<ReqT, RespT> willReturn(@Nonnull StreamResponseBuilder<RespT> response) {
        Objects.requireNonNull(response);
        this.responses.add(response.build());
        return this;
    }

    @Override
    public NextServerStreamingMethodResponseBuilderStep<ReqT, RespT> nextWillReturn(@Nonnull StreamResponseBuilder<RespT> response) {
        return this.willReturn((StreamResponseBuilder)response);
    }

    @Override
    public NextServerStreamingMethodResponseBuilderStep<ReqT, RespT> nextWillReturn(@Nonnull ObjectResponseActionBuilder<RespT> response) {
        return this.willReturn((ObjectResponseActionBuilder)response);
    }

    @Override
    public NextServerStreamingMethodResponseBuilderStep<ReqT, RespT> nextWillReturn(@Nonnull ExceptionResponseActionBuilder response) {
        return this.willReturn(response);
    }

    @Override
    public NextServerStreamingMethodResponseBuilderStep<ReqT, RespT> willProxyTo(@Nonnull BiConsumer<ReqT, StreamObserver<RespT>> responseProxy) {
        Objects.requireNonNull(responseProxy);
        this.responses.add(new ResponseProxyImpl<ReqT, RespT>(responseProxy));
        return this;
    }

    @Override
    public NextServerStreamingMethodResponseBuilderStep<ReqT, RespT> nextWillProxyTo(@Nonnull BiConsumer<ReqT, StreamObserver<RespT>> responseProxy) {
        return this.willProxyTo((BiConsumer)responseProxy);
    }

    @Override
    public MethodStub<ReqT, RespT> build() {
        return new MethodStub<ReqT, RespT>(this.method, Collections.singletonList(new StubScenario<ReqT, RespT>(this.requestPatternBuilder.build(), this.responses)));
    }
}

