/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.Metadata;
import org.hibernate.metamodel.relational.AuxiliaryDatabaseObject;
import org.hibernate.metamodel.relational.Exportable;
import org.hibernate.metamodel.relational.ForeignKey;
import org.hibernate.metamodel.relational.Identifier;
import org.hibernate.metamodel.relational.Index;
import org.hibernate.metamodel.relational.Schema;
import org.hibernate.metamodel.relational.Table;
import org.hibernate.metamodel.relational.UniqueKey;

public class Database {
    private final Schema.Name implicitSchemaName;
    private final Map<Schema.Name, Schema> schemaMap = new HashMap<Schema.Name, Schema>();
    private final List<AuxiliaryDatabaseObject> auxiliaryDatabaseObjects = new ArrayList<AuxiliaryDatabaseObject>();

    public Database(Metadata.Options options) {
        String schemaName = options.getDefaultSchemaName();
        String catalogName = options.getDefaultCatalogName();
        if (options.isGloballyQuotedIdentifiers()) {
            schemaName = StringHelper.quote(schemaName);
            catalogName = StringHelper.quote(catalogName);
        }
        this.implicitSchemaName = new Schema.Name(schemaName, catalogName);
        this.makeSchema(this.implicitSchemaName);
    }

    public Schema getDefaultSchema() {
        return this.schemaMap.get(this.implicitSchemaName);
    }

    public Schema locateSchema(Schema.Name name) {
        if (name.getSchema() == null && name.getCatalog() == null) {
            return this.getDefaultSchema();
        }
        Schema schema = this.schemaMap.get(name);
        if (schema == null) {
            schema = this.makeSchema(name);
        }
        return schema;
    }

    private Schema makeSchema(Schema.Name name) {
        Schema schema = new Schema(name);
        this.schemaMap.put(name, schema);
        return schema;
    }

    public Schema getSchema(Identifier schema, Identifier catalog) {
        return this.locateSchema(new Schema.Name(schema, catalog));
    }

    public Schema getSchema(String schema, String catalog) {
        return this.locateSchema(new Schema.Name(Identifier.toIdentifier(schema), Identifier.toIdentifier(catalog)));
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        if (auxiliaryDatabaseObject == null) {
            throw new IllegalArgumentException("Auxiliary database object is null.");
        }
        this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
    }

    public Iterable<AuxiliaryDatabaseObject> getAuxiliaryDatabaseObjects() {
        return this.auxiliaryDatabaseObjects;
    }

    public String[] generateSchemaCreationScript(Dialect dialect) {
        HashSet<String> exportIdentifiers = new HashSet<String>(50);
        ArrayList<String> script = new ArrayList<String>(50);
        for (Schema schema : this.schemaMap.values()) {
            for (Table table : schema.getTables()) {
                Database.addSqlCreateStrings(dialect, exportIdentifiers, script, table);
            }
        }
        for (Schema schema : this.schemaMap.values()) {
            for (Table table : schema.getTables()) {
                if (!dialect.supportsUniqueConstraintInCreateAlterTable()) {
                    for (UniqueKey uniqueKey : table.getUniqueKeys()) {
                        Database.addSqlCreateStrings(dialect, exportIdentifiers, script, uniqueKey);
                    }
                }
                for (Index index : table.getIndexes()) {
                    Database.addSqlCreateStrings(dialect, exportIdentifiers, script, index);
                }
                if (!dialect.hasAlterTable()) continue;
                for (ForeignKey foreignKey : table.getForeignKeys()) {
                    if (!Table.class.isInstance(foreignKey.getTargetTable())) continue;
                    Database.addSqlCreateStrings(dialect, exportIdentifiers, script, foreignKey);
                }
            }
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : this.auxiliaryDatabaseObjects) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            Database.addSqlCreateStrings(dialect, exportIdentifiers, script, auxiliaryDatabaseObject);
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateDropSchemaScript(Dialect dialect) {
        HashSet<String> exportIdentifiers = new HashSet<String>(50);
        ArrayList<String> script = new ArrayList<String>(50);
        for (int i = this.auxiliaryDatabaseObjects.size() - 1; i >= 0; --i) {
            AuxiliaryDatabaseObject object = this.auxiliaryDatabaseObjects.get(i);
            if (!object.appliesToDialect(dialect)) continue;
            Database.addSqlDropStrings(dialect, exportIdentifiers, script, object);
        }
        if (dialect.dropConstraints()) {
            for (Schema schema : this.schemaMap.values()) {
                for (Table table : schema.getTables()) {
                    for (ForeignKey foreignKey : table.getForeignKeys()) {
                        if (!(foreignKey.getTargetTable() instanceof Table)) continue;
                        Database.addSqlDropStrings(dialect, exportIdentifiers, script, foreignKey);
                    }
                }
            }
        }
        for (Schema schema : this.schemaMap.values()) {
            for (Table table : schema.getTables()) {
                Database.addSqlDropStrings(dialect, exportIdentifiers, script, table);
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    private static void addSqlDropStrings(Dialect dialect, Set<String> exportIdentifiers, List<String> script, Exportable exportable) {
        Database.addSqlStrings(exportIdentifiers, script, exportable.getExportIdentifier(), exportable.sqlDropStrings(dialect));
    }

    private static void addSqlCreateStrings(Dialect dialect, Set<String> exportIdentifiers, List<String> script, Exportable exportable) {
        Database.addSqlStrings(exportIdentifiers, script, exportable.getExportIdentifier(), exportable.sqlCreateStrings(dialect));
    }

    private static void addSqlStrings(Set<String> exportIdentifiers, List<String> script, String exportIdentifier, String[] sqlStrings) {
        if (sqlStrings == null) {
            return;
        }
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new MappingException("SQL strings added more than once for: " + exportIdentifier);
        }
        exportIdentifiers.add(exportIdentifier);
        script.addAll(Arrays.asList(sqlStrings));
    }
}

