/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.impl;

import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.spi.EncodingBridge;
import org.hibernate.search.bridge.spi.IgnoreAnalyzerBridge;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.bridge.util.impl.ToStringNullMarker;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchBooleanBridge
implements EncodingBridge,
TwoWayStringBridge,
IgnoreAnalyzerBridge {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    public static final ElasticsearchBooleanBridge INSTANCE = new ElasticsearchBooleanBridge();

    private ElasticsearchBooleanBridge() {
    }

    public Boolean stringToObject(String stringValue) {
        if (StringHelper.isEmpty((String)stringValue)) {
            return null;
        }
        return Boolean.valueOf(stringValue);
    }

    public String objectToString(Object object) {
        return object == null ? null : object.toString();
    }

    public NumericFieldSettingsDescriptor.NumericEncodingType getEncodingType() {
        return NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN;
    }

    protected Boolean parseIndexNullAs(String indexNullAs) throws IllegalArgumentException {
        if (Boolean.TRUE.toString().equals(indexNullAs)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equals(indexNullAs)) {
            return Boolean.FALSE;
        }
        throw LOG.invalidNullMarkerForBoolean();
    }

    public NullMarker createNullMarker(String indexNullAs) throws IllegalArgumentException {
        Boolean booleanValue = this.parseIndexNullAs(indexNullAs);
        return new ToStringNullMarker((Object)booleanValue);
    }
}

