/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class NumericDocumentIdIndexedEmbeddedTest
extends SearchInitializationTestBase {
    @TestForIssue(jiraKey="HSEARCH-2545")
    @Test
    public void testIndexAndSearchNumericField() {
        this.init(A.class, B.class, C.class);
        try (Session session = this.getTestResourceManager().openSession();){
            FullTextSession fts = Search.getFullTextSession((Session)session);
            Transaction tx = fts.beginTransaction();
            A a = new A();
            B b = new B();
            b.a = a;
            C c = new C();
            c.b = b;
            fts.persist((Object)a);
            fts.persist((Object)b);
            fts.persist((Object)c);
            tx.commit();
            fts.clear();
            tx = fts.beginTransaction();
            Assert.assertEquals((String)"Query id ", (long)1L, (long)this.numericQueryFor(fts, C.class, "b.a.id", a.id, a.id).size());
            tx.commit();
            fts.clear();
        }
    }

    private List<?> numericQueryFor(FullTextSession fullTextSession, Class<?> entityClass, String fieldName, Object from, Object to) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)from, (Object)to, (boolean)true, (boolean)true);
        return fullTextSession.createFullTextQuery(query, new Class[]{entityClass}).list();
    }

    @Entity
    @Indexed
    private static class C {
        @Id
        @GeneratedValue
        private Long id;
        @OneToOne
        @IndexedEmbedded(includePaths={"a.id"})
        private B b;

        private C() {
        }
    }

    @Entity
    private static class B {
        @Id
        @GeneratedValue
        private Long id;
        @OneToOne
        @IndexedEmbedded(includePaths={"id"})
        private A a;

        private B() {
        }
    }

    @Entity
    @Indexed
    private static class A {
        @Id
        @GeneratedValue
        @NumericField
        @SortableField
        private Long id;

        private A() {
        }
    }
}

