/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.seam;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.tool.hbm2x.POJOExporter;
import org.hibernate.tool.hbm2x.pojo.POJOClass;

public class SeamExporter
extends AbstractExporter {
    public SeamExporter() {
    }

    public SeamExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
        this.init();
    }

    private void init() {
    }

    protected void setupContext() {
        if (!this.getProperties().contains("seam_appname")) {
            this.getProperties().put("seam_appname", "SeamApplication");
        }
        if (!this.getProperties().contains("seam_shortname")) {
            this.getProperties().put("seam_shortname", "seamapp");
        }
        super.setupContext();
    }

    protected void exportComponent(Map additionalContext, POJOClass element) {
    }

    public String getName() {
        return "hbm2seam";
    }

    public void doStart() {
        this.configureExporter("seam/build.xml.ftl", "build.xml").start();
        this.configureExporter("seam/build.properties.ftl", "build.properties").start();
        this.configureExporter("seam/components.xml.ftl", "resources/WEB-INF/components.xml").start();
        this.configureExporter("seam/readme.txt.ftl", "readme.txt").start();
        new File(this.getOutputDirectory(), "lib").mkdir();
        this.configureExporter("seam/seam.properties.ftl", "resources/seam.properties").start();
        this.configureExporter("seam/messages.properties.ftl", "resources/WEB-INF/classes/messages.properties").start();
        this.configureExporter("seam/web.xml.ftl", "resources/WEB-INF/web.xml").start();
        this.configureExporter("seam/faces-config.xml.ftl", "resources/WEB-INF/faces-config.xml").start();
        new File(this.getOutputDirectory(), "resources/WEB-INF/lib").mkdir();
        this.configureExporter("seam/persistence.xml.ftl", "resources/META-INF/persistence.xml").start();
        this.configureExporter("seam/application.xml.ftl", "resources/META-INF/application.xml").start();
        this.configureExporter("seam/jboss-app.xml.ftl", "resources/META-INF/jboss-app.xml").start();
        this.configureExporter("seam/edit.jsp.ftl", "resources/jsp/edit{class-name}.jsp").start();
        this.configureExporter("seam/find.jsp.ftl", "resources/jsp/find{class-name}.jsp").start();
        this.configureExporter("seam/index.html.ftl", "resources/jsp/index.html").start();
        this.configureExporter("seam/screen.css.ftl", "resources/jsp/style/default/screen.css").start();
        POJOExporter exporter = new POJOExporter(this.getConfiguration(), this.getOutputDirectory());
        exporter.setProperties((Properties)this.getProperties().clone());
        exporter.setTemplatePath(this.getTemplatePaths());
        exporter.setArtifactCollector(this.getArtifactCollector());
        exporter.getProperties().setProperty("ejb3", "true");
        exporter.getProperties().setProperty("jdk5", "true");
        exporter.setFilePattern("src/{package-name}/{class-name}.java");
        exporter.start();
        this.configureExporter("seam/finder.java.ftl", "src/{package-name}/{class-name}Finder.java").start();
        this.configureExporter("seam/finderbean.java.ftl", "src/{package-name}/{class-name}FinderBean.java").start();
        this.configureExporter("seam/selector.java.ftl", "src/{package-name}/{class-name}Selector.java").start();
        this.configureExporter("seam/editor.java.ftl", "src/{package-name}/{class-name}Editor.java").start();
        this.configureExporter("seam/editorbean.java.ftl", "src/{package-name}/{class-name}EditorBean.java").start();
    }

    private GenericExporter configureExporter(String template, String pattern) {
        GenericExporter exporter = new GenericExporter(this.getConfiguration(), this.getOutputDirectory());
        exporter.setProperties((Properties)this.getProperties().clone());
        exporter.setTemplatePath(this.getTemplatePaths());
        exporter.setTemplateName(template);
        exporter.setFilePattern(pattern);
        exporter.setArtifactCollector(this.getArtifactCollector());
        return exporter;
    }
}

