/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonArrayJdbcType;

public class GaussDBCastingJsonArrayJdbcType
extends JsonArrayJdbcType {
    private final boolean jsonb;

    public GaussDBCastingJsonArrayJdbcType(JdbcType elementJdbcType, boolean jsonb) {
        super(elementJdbcType);
        this.jsonb = jsonb;
    }

    public void appendWriteExpression(String writeExpression, @Nullable Size size, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)"cast(");
        appender.append((CharSequence)writeExpression);
        appender.append((CharSequence)" as ");
        if (this.jsonb) {
            appender.append((CharSequence)"jsonb)");
        } else {
            appender.append((CharSequence)"json)");
        }
    }

    public boolean isWriteExpressionTyped(Dialect dialect) {
        return true;
    }
}

