/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.exception;

import java.time.LocalDateTime;
import java.util.Date;
import org.hibernate.envers.exception.AuditException;

public class RevisionDoesNotExistException
extends AuditException {
    private static final long serialVersionUID = -6417768274074962282L;
    private final Number revision;
    private final Date date;
    private final LocalDateTime localDateTime;

    public RevisionDoesNotExistException(Number revision) {
        super("Revision " + String.valueOf(revision) + " does not exist.");
        this.revision = revision;
        this.date = null;
        this.localDateTime = null;
    }

    public RevisionDoesNotExistException(Date date) {
        super("There is no revision before or at " + String.valueOf(date) + ".");
        this.date = date;
        this.revision = null;
        this.localDateTime = null;
    }

    public RevisionDoesNotExistException(LocalDateTime localDateTime) {
        super("There is no revision before or at " + String.valueOf(localDateTime) + ".");
        this.localDateTime = localDateTime;
        this.revision = null;
        this.date = null;
    }

    public Number getRevision() {
        return this.revision;
    }

    public Date getDate() {
        return this.date;
    }

    public LocalDateTime getLocalDateTime() {
        return this.localDateTime;
    }
}

