/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.io.Serializable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.util.Constants;
import org.hibernate.jpamodelgen.util.TypeUtils;

class BasicAttributeVisitor
extends SimpleTypeVisitor8<Boolean, Element> {
    private final @UnknownKeyFor @NonNull @Initialized Context context;

    public BasicAttributeVisitor(@UnknownKeyFor @NonNull @Initialized Context context) {
        super(false);
        this.context = context;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean visitPrimitive(@UnknownKeyFor @NonNull @Initialized PrimitiveType primitiveType, @UnknownKeyFor @NonNull @Initialized Element element) {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean visitArray(@UnknownKeyFor @NonNull @Initialized ArrayType arrayType, @UnknownKeyFor @NonNull @Initialized Element element) {
        TypeElement componentElement = (TypeElement)this.context.getTypeUtils().asElement(arrayType.getComponentType());
        return Constants.BASIC_ARRAY_TYPES.contains(componentElement.getQualifiedName().toString());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Boolean visitDeclared(@UnknownKeyFor @NonNull @Initialized DeclaredType declaredType, @UnknownKeyFor @NonNull @Initialized Element element) {
        if (ElementKind.ENUM.equals((Object)element.getKind())) {
            return true;
        }
        if (TypeUtils.isClassOrRecordType(element) || element.getKind() == ElementKind.INTERFACE) {
            TypeElement typeElement = (TypeElement)element;
            String typeName = typeElement.getQualifiedName().toString();
            if (Constants.BASIC_TYPES.contains(typeName)) {
                return true;
            }
            if (TypeUtils.containsAnnotation(element, "jakarta.persistence.Embeddable")) {
                return true;
            }
            TypeMirror serializableType = this.context.getElementUtils().getTypeElement(Serializable.class.getName()).asType();
            if (this.context.getTypeUtils().isSubtype(typeElement.asType(), serializableType)) {
                return true;
            }
        }
        return false;
    }
}

