/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class FileTimeStampChecker
implements Serializable {
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> lastModifiedCache = new HashMap<String, Long>();

    public void add(@UnknownKeyFor @NonNull @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized Long lastModified) {
        this.lastModifiedCache.put(fileName, lastModified);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTimeStampChecker that = (FileTimeStampChecker)o;
        return this.lastModifiedCache.equals(that.lastModifiedCache);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.lastModifiedCache.hashCode();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileTimeStampChecker");
        sb.append("{lastModifiedCache=").append(this.lastModifiedCache);
        sb.append('}');
        return sb.toString();
    }
}

