/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.MappingException;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.boot.internal.DefaultCustomEntityDirtinessStrategy;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.internal.StandardEntityNotFoundDelegate;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategyStandardImpl;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MappingDefaults;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.DisabledCaching;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.query.internal.NativeQueryInterpreterStandardImpl;
import org.hibernate.engine.query.spi.NativeQueryInterpreter;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.internal.StandardIdentifierGeneratorFactory;
import org.hibernate.internal.FastSessionServices;
import org.hibernate.jpa.internal.MutableJpaComplianceImpl;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.jpa.spi.MutableJpaCompliance;
import org.hibernate.loader.BatchFetchStyle;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.internal.JpaMetaModelPopulationSetting;
import org.hibernate.metamodel.internal.JpaStaticMetaModelPopulationSetting;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.internal.RuntimeMetamodelsImpl;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AbstractAttribute;
import org.hibernate.metamodel.model.domain.internal.AbstractPluralAttribute;
import org.hibernate.metamodel.model.domain.internal.BagAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.BasicTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EmbeddableTypeImpl;
import org.hibernate.metamodel.model.domain.internal.EntityTypeImpl;
import org.hibernate.metamodel.model.domain.internal.JpaMetamodelImpl;
import org.hibernate.metamodel.model.domain.internal.ListAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.MapAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.MappedSuperclassTypeImpl;
import org.hibernate.metamodel.model.domain.internal.MappingMetamodelImpl;
import org.hibernate.metamodel.model.domain.internal.PluralAttributeBuilder;
import org.hibernate.metamodel.model.domain.internal.SetAttributeImpl;
import org.hibernate.metamodel.model.domain.internal.SingularAttributeImpl;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeMetamodelsImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.processor.validation.MockCollectionPersister;
import org.hibernate.processor.validation.MockEntityPersister;
import org.hibernate.processor.validation.MockJdbcServicesInitiator;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.criteria.ValueHandlingMode;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.hql.internal.StandardHqlTranslator;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.internal.NamedObjectRepositoryImpl;
import org.hibernate.query.internal.QueryInterpretationCacheDisabledImpl;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.internal.StatisticsImpl;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.BagType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.ListType;
import org.hibernate.type.MapType;
import org.hibernate.type.SetType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class MockSessionFactory
implements SessionFactoryImplementor,
QueryEngine,
RuntimeModelCreationContext,
MetadataBuildingOptions,
BootstrapContext,
MetadataBuildingContext,
FunctionContributions,
SessionFactoryOptions,
JdbcTypeIndicators {
    private static final @UnknownKeyFor @NonNull @Initialized BasicTypeImpl<@UnknownKeyFor @NonNull @Initialized Object> OBJECT_BASIC_TYPE = new BasicTypeImpl((JavaType)new UnknownBasicJavaType(Object.class), (JdbcType)ObjectJdbcType.INSTANCE);
    static @UnknownKeyFor @NonNull @Initialized TypeConfiguration typeConfiguration;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MockEntityPersister> entityPersistersByName = new HashMap<String, MockEntityPersister>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MockCollectionPersister> collectionPersistersByName = new HashMap<String, MockCollectionPersister>();
    private final @UnknownKeyFor @NonNull @Initialized StandardServiceRegistryImpl serviceRegistry = StandardServiceRegistryImpl.create((BootstrapServiceRegistry)new BootstrapServiceRegistryBuilder().applyClassLoaderService((ClassLoaderService)new ClassLoaderServiceImpl(){

        public Class<?> classForName(String className) {
            try {
                return super.classForName(className);
            }
            catch (ClassLoadingException e) {
                if (MockSessionFactory.this.isClassDefined(className)) {
                    return Object[].class;
                }
                throw e;
            }
        }
    }).build(), Collections.singletonList(MockJdbcServicesInitiator.INSTANCE), Collections.emptyList(), Collections.emptyMap());
    private final @UnknownKeyFor @NonNull @Initialized SqmFunctionRegistry functionRegistry = new SqmFunctionRegistry();
    private final @UnknownKeyFor @NonNull @Initialized MappingMetamodelImpl metamodel = new MockMappingMetamodelImpl();
    private final @UnknownKeyFor @NonNull @Initialized MetadataImplementor bootModel = new MetadataImpl(UUID.randomUUID(), (MetadataBuildingOptions)this, Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), new Database((MetadataBuildingOptions)this, MockJdbcServicesInitiator.jdbcServices.getJdbcEnvironment()), (BootstrapContext)this);
    private final @UnknownKeyFor @NonNull @Initialized MetadataContext metadataContext = new MetadataContext(this.metamodel.getJpaMetamodel(), (MappingMetamodel)this.metamodel, this.bootModel, JpaStaticMetaModelPopulationSetting.DISABLED, JpaMetaModelPopulationSetting.DISABLED, (RuntimeModelCreationContext)this);
    private static final @UnknownKeyFor @NonNull @Initialized SessionFactoryObserver @UnknownKeyFor @NonNull @Initialized [] NO_OBSERVERS;
    private static final @UnknownKeyFor @NonNull @Initialized EntityNameResolver @UnknownKeyFor @NonNull @Initialized [] NO_RESOLVERS;
    static @UnknownKeyFor @NonNull @Initialized MutableJpaCompliance jpaCompliance;

    public MockSessionFactory() {
        typeConfiguration = new TypeConfiguration();
        typeConfiguration.scope((MetadataBuildingContext)this);
        MockJdbcServicesInitiator.genericDialect.initializeFunctionRegistry((FunctionContributions)this);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory((FunctionContributions)this);
        functionFactory.listagg(null);
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates();
        functionFactory.windowFunctions();
        typeConfiguration.scope((SessionFactoryImplementor)this);
    }

    public @UnknownKeyFor @NonNull @Initialized TypeConfiguration getTypeConfiguration() {
        return typeConfiguration;
    }

    public void addObserver(@UnknownKeyFor @NonNull @Initialized SessionFactoryObserver observer) {
    }

    public @UnknownKeyFor @NonNull @Initialized MetadataBuildingOptions getBuildingOptions() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized PhysicalNamingStrategy getPhysicalNamingStrategy() {
        return new PhysicalNamingStrategyStandardImpl();
    }

    public @UnknownKeyFor @NonNull @Initialized ImplicitNamingStrategy getImplicitNamingStrategy() {
        return new ImplicitNamingStrategyJpaCompliantImpl();
    }

    static @UnknownKeyFor @NonNull @Initialized CollectionType createCollectionType(@UnknownKeyFor @NonNull @Initialized String role, @UnknownKeyFor @NonNull @Initialized String name) {
        switch (name) {
            case "Set": 
            case "SortedSet": {
                return new SetType(role, null);
            }
            case "List": 
            case "SortedList": {
                return new ListType(role, null);
            }
            case "Map": 
            case "SortedMap": {
                return new MapType(role, null);
            }
        }
        return new BagType(role, null);
    }

    abstract @UnknownKeyFor @NonNull @Initialized MockEntityPersister createMockEntityPersister(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized MockCollectionPersister createMockCollectionPersister(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isEntityDefined(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized String findEntityName(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized String qualifyName(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isAttributeDefined(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isClassDefined(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isEnum(@UnknownKeyFor @NonNull @Initialized String var1);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isEnumConstant(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2);

    abstract /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> javaConstantType(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isFieldDefined(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2);

    abstract @UnknownKeyFor @NonNull @Initialized boolean isConstructorDefined(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Type> var2);

    abstract @UnknownKeyFor @NonNull @Initialized Type propertyType(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2);

    protected abstract @UnknownKeyFor @NonNull @Initialized boolean isSubtype(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2);

    protected abstract @UnknownKeyFor @NonNull @Initialized String getSupertype(@UnknownKeyFor @NonNull @Initialized String var1);

    private @UnknownKeyFor @NonNull @Initialized EntityPersister createEntityPersister(@UnknownKeyFor @NonNull @Initialized String entityName) {
        MockEntityPersister result = this.entityPersistersByName.get(entityName);
        if (result != null) {
            return result;
        }
        result = this.createMockEntityPersister(entityName);
        this.entityPersistersByName.put(entityName, result);
        return result;
    }

    private @UnknownKeyFor @NonNull @Initialized CollectionPersister createCollectionPersister(@UnknownKeyFor @NonNull @Initialized String entityName) {
        MockCollectionPersister result = this.collectionPersistersByName.get(entityName);
        if (result != null) {
            return result;
        }
        result = this.createMockCollectionPersister(entityName);
        this.collectionPersistersByName.put(entityName, result);
        return result;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MockEntityPersister> getMockEntityPersisters() {
        return this.entityPersistersByName.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public @UnknownKeyFor @NonNull @Initialized Type getIdentifierType(@UnknownKeyFor @NonNull @Initialized String className) throws @UnknownKeyFor @NonNull @Initialized MappingException {
        return this.createEntityPersister(className).getIdentifierType();
    }

    public @UnknownKeyFor @NonNull @Initialized String getIdentifierPropertyName(@UnknownKeyFor @NonNull @Initialized String className) throws @UnknownKeyFor @NonNull @Initialized MappingException {
        return this.createEntityPersister(className).getIdentifierPropertyName();
    }

    public @UnknownKeyFor @NonNull @Initialized Type getReferencedPropertyType(@UnknownKeyFor @NonNull @Initialized String className, @UnknownKeyFor @NonNull @Initialized String propertyName) throws @UnknownKeyFor @NonNull @Initialized MappingException {
        return this.createEntityPersister(className).getPropertyType(propertyName);
    }

    public @UnknownKeyFor @NonNull @Initialized MetamodelImplementor getMetamodel() {
        return this.metamodel;
    }

    public @UnknownKeyFor @NonNull @Initialized StandardServiceRegistryImpl getServiceRegistry() {
        return this.serviceRegistry;
    }

    public @UnknownKeyFor @NonNull @Initialized JdbcServices getJdbcServices() {
        return MockJdbcServicesInitiator.jdbcServices;
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return "mock";
    }

    public @UnknownKeyFor @NonNull @Initialized SessionFactoryOptions getSessionFactoryOptions() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getDefinedFilterNames() {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized CacheImplementor getCache() {
        return new DisabledCaching((SessionFactoryImplementor)this);
    }

    public @UnknownKeyFor @NonNull @Initialized EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return new StandardEntityNotFoundDelegate();
    }

    public @UnknownKeyFor @NonNull @Initialized CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return new DefaultCustomEntityDirtinessStrategy();
    }

    public @UnknownKeyFor @NonNull @Initialized CurrentTenantIdentifierResolver<@UnknownKeyFor @NonNull @Initialized Object> getCurrentTenantIdentifierResolver() {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized JavaType<@UnknownKeyFor @NonNull @Initialized Object> getTenantIdentifierJavaType() {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isPreferJavaTimeJdbcTypesEnabled() {
        return super.isPreferJavaTimeJdbcTypesEnabled();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isPreferNativeEnumTypesEnabled() {
        return super.isPreferNativeEnumTypesEnabled();
    }

    public @UnknownKeyFor @NonNull @Initialized FastSessionServices getFastSessionServices() {
        throw new UnsupportedOperationException("operation not supported");
    }

    public void close() {
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized RootGraphImplementor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findEntityGraphByName(@UnknownKeyFor @NonNull @Initialized String s) {
        throw new UnsupportedOperationException("operation not supported");
    }

    static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> toPrimitiveClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type) {
        switch (type.getName()) {
            case "java.lang.Boolean": {
                return Boolean.TYPE;
            }
            case "java.lang.Character": {
                return Character.TYPE;
            }
            case "java.lang.Integer": {
                return Integer.TYPE;
            }
            case "java.lang.Short": {
                return Short.TYPE;
            }
            case "java.lang.Byte": {
                return Byte.TYPE;
            }
            case "java.lang.Long": {
                return Long.TYPE;
            }
            case "java.lang.Float": {
                return Float.TYPE;
            }
            case "java.lang.Double": {
                return Double.TYPE;
            }
        }
        return Object.class;
    }

    public @UnknownKeyFor @NonNull @Initialized NativeQueryInterpreter getNativeQueryInterpreter() {
        return new NativeQueryInterpreterStandardImpl(this.getNativeJdbcParametersIgnored());
    }

    public @UnknownKeyFor @NonNull @Initialized QueryInterpretationCache getInterpretationCache() {
        return new QueryInterpretationCacheDisabledImpl(this::getStatistics);
    }

    public @UnknownKeyFor @NonNull @Initialized StatisticsImplementor getStatistics() {
        return new StatisticsImpl((SessionFactoryImplementor)this);
    }

    public @UnknownKeyFor @NonNull @Initialized SqmFunctionRegistry getSqmFunctionRegistry() {
        return this.functionRegistry;
    }

    public @UnknownKeyFor @NonNull @Initialized NodeBuilder getCriteriaBuilder() {
        return new SqmCriteriaNodeBuilder("", "", (QueryEngine)this, false, ValueHandlingMode.INLINE, () -> this);
    }

    public void validateNamedQueries() {
    }

    public @UnknownKeyFor @NonNull @Initialized NamedObjectRepository getNamedObjectRepository() {
        return new NamedObjectRepositoryImpl(new HashMap(), new HashMap(), new HashMap(), new HashMap());
    }

    public @UnknownKeyFor @NonNull @Initialized HqlTranslator getHqlTranslator() {
        return new StandardHqlTranslator((SqmCreationContext)this, new SqmCreationOptions(){});
    }

    public @UnknownKeyFor @NonNull @Initialized SqmTranslatorFactory getSqmTranslatorFactory() {
        return new StandardSqmTranslatorFactory();
    }

    public @UnknownKeyFor @NonNull @Initialized QueryEngine getQueryEngine() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized JpaMetamodelImplementor getJpaMetamodel() {
        return this.metamodel.getJpaMetamodel();
    }

    public @UnknownKeyFor @NonNull @Initialized MappingMetamodelImplementor getMappingMetamodel() {
        return this.metamodel;
    }

    public @UnknownKeyFor @NonNull @Initialized RuntimeMetamodelsImplementor getRuntimeMetamodels() {
        RuntimeMetamodelsImpl runtimeMetamodels = new RuntimeMetamodelsImpl();
        runtimeMetamodels.setJpaMetamodel(this.metamodel.getJpaMetamodel());
        runtimeMetamodels.setMappingMetamodel((MappingMetamodelImplementor)this.metamodel);
        return runtimeMetamodels;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isClosed() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized MutableJpaCompliance getJpaCompliance() {
        return jpaCompliance;
    }

    public @UnknownKeyFor @NonNull @Initialized String getSessionFactoryName() {
        return "mock";
    }

    public @UnknownKeyFor @NonNull @Initialized String getUuid() {
        return "mock";
    }

    public @UnknownKeyFor @NonNull @Initialized SessionFactoryObserver @UnknownKeyFor @NonNull @Initialized [] getSessionFactoryObservers() {
        return NO_OBSERVERS;
    }

    public @UnknownKeyFor @NonNull @Initialized EntityNameResolver @UnknownKeyFor @NonNull @Initialized [] getEntityNameResolvers() {
        return NO_RESOLVERS;
    }

    public @UnknownKeyFor @NonNull @Initialized BatchFetchStyle getBatchFetchStyle() {
        return BatchFetchStyle.LEGACY;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDelayBatchFetchLoaderCreationsEnabled() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized Integer getMaximumFetchDepth() {
        return null;
    }

    public void setCheckNullability(@UnknownKeyFor @NonNull @Initialized boolean enabled) {
    }

    public @UnknownKeyFor @NonNull @Initialized Dialect getDialect() {
        return MockJdbcServicesInitiator.genericDialect;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPreferredSqlTypeCodeForBoolean() {
        return 16;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPreferredSqlTypeCodeForDuration() {
        return 2;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPreferredSqlTypeCodeForUuid() {
        return 3000;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPreferredSqlTypeCodeForInstant() {
        return 2014;
    }

    public @UnknownKeyFor @NonNull @Initialized int getPreferredSqlTypeCodeForArray() {
        return 2003;
    }

    public @UnknownKeyFor @NonNull @Initialized SessionFactoryImplementor getSessionFactory() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized BootstrapContext getBootstrapContext() {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized MetadataImplementor getBootModel() {
        return this.bootModel;
    }

    public @UnknownKeyFor @NonNull @Initialized MappingMetamodelImplementor getDomainModel() {
        return this.metamodel;
    }

    public @UnknownKeyFor @NonNull @Initialized SqmFunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getSettings() {
        return Collections.emptyMap();
    }

    public @UnknownKeyFor @NonNull @Initialized SqlStringGenerationContext getSqlStringGenerationContext() {
        throw new UnsupportedOperationException("operation not supported");
    }

    public @UnknownKeyFor @NonNull @Initialized IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return new StandardIdentifierGeneratorFactory((ServiceRegistry)this.serviceRegistry, true);
    }

    public @UnknownKeyFor @NonNull @Initialized MappingDefaults getMappingDefaults() {
        return new MockMappingDefaults();
    }

    public @UnknownKeyFor @NonNull @Initialized TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
        return TimeZoneStorageStrategy.NATIVE;
    }

    @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getEnumTypesForValue(@UnknownKeyFor @NonNull @Initialized String value) {
        return Collections.emptySet();
    }

    private @UnknownKeyFor @NonNull @Initialized AbstractAttribute createAttribute(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized Type type, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ManagedDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> owner) {
        if (type == null) {
            throw new UnsupportedOperationException(entityName + "." + name);
        }
        if (type.isCollectionType()) {
            CollectionType collectionType = (CollectionType)type;
            return this.createPluralAttribute(collectionType, entityName, name, owner);
        }
        if (type.isEntityType()) {
            return new SingularAttributeImpl(owner, name, AttributeClassification.MANY_TO_ONE, new MockEntityDomainType(type.getName()), null, null, false, false, true, false, this.metadataContext);
        }
        if (type.isComponentType()) {
            CompositeType compositeType = (CompositeType)type;
            return new SingularAttributeImpl(owner, name, AttributeClassification.EMBEDDED, this.createEmbeddableDomainType(entityName, compositeType, owner), null, null, false, false, true, false, this.metadataContext);
        }
        return new SingularAttributeImpl(owner, name, AttributeClassification.BASIC, (DomainType)type, type instanceof JdbcMapping ? ((JdbcMapping)type).getJavaTypeDescriptor() : null, null, false, false, true, false, this.metadataContext);
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getElementDomainType(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized CollectionType collectionType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ManagedDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> owner) {
        Type elementType = collectionType.getElementType((SessionFactoryImplementor)this);
        return this.getDomainType(entityName, collectionType, owner, elementType);
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getMapKeyDomainType(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized CollectionType collectionType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ManagedDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> owner) {
        Type keyType = this.getMappingMetamodel().getCollectionDescriptor(collectionType.getRole()).getIndexType();
        return this.getDomainType(entityName, collectionType, owner, keyType);
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getDomainType(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized CollectionType collectionType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ManagedDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> owner, @UnknownKeyFor @NonNull @Initialized Type elementType) {
        if (elementType.isEntityType()) {
            String associatedEntityName = collectionType.getAssociatedEntityName((SessionFactoryImplementor)this);
            return new MockEntityDomainType(associatedEntityName);
        }
        if (elementType.isComponentType()) {
            CompositeType compositeType = (CompositeType)elementType;
            return this.createEmbeddableDomainType(entityName, compositeType, owner);
        }
        if (elementType instanceof DomainType) {
            return (DomainType)elementType;
        }
        return OBJECT_BASIC_TYPE;
    }

    private @UnknownKeyFor @NonNull @Initialized AbstractPluralAttribute createPluralAttribute(@UnknownKeyFor @NonNull @Initialized CollectionType collectionType, @UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String name, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ManagedDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> owner) {
        Property property = new Property();
        property.setName(name);
        JavaType collectionJavaType = typeConfiguration.getJavaTypeRegistry().getDescriptor((java.lang.reflect.Type)collectionType.getReturnedClass());
        DomainType<?> elementDomainType = this.getElementDomainType(entityName, collectionType, owner);
        CollectionClassification classification = collectionType.getCollectionClassification();
        switch (classification) {
            case LIST: {
                return new ListAttributeImpl(new PluralAttributeBuilder(collectionJavaType, true, AttributeClassification.MANY_TO_MANY, classification, elementDomainType, (DomainType)typeConfiguration.getBasicTypeRegistry().getRegisteredType(Integer.class), owner, property, null), this.metadataContext);
            }
            case BAG: 
            case ID_BAG: {
                return new BagAttributeImpl(new PluralAttributeBuilder(collectionJavaType, true, AttributeClassification.MANY_TO_MANY, classification, elementDomainType, null, owner, property, null), this.metadataContext);
            }
            case SET: 
            case SORTED_SET: 
            case ORDERED_SET: {
                return new SetAttributeImpl(new PluralAttributeBuilder(collectionJavaType, true, AttributeClassification.MANY_TO_MANY, classification, elementDomainType, null, owner, property, null), this.metadataContext);
            }
            case MAP: 
            case SORTED_MAP: 
            case ORDERED_MAP: {
                DomainType<?> keyDomainType = this.getMapKeyDomainType(entityName, collectionType, owner);
                return new MapAttributeImpl(new PluralAttributeBuilder(collectionJavaType, true, AttributeClassification.MANY_TO_MANY, classification, elementDomainType, keyDomainType, owner, property, null), this.metadataContext);
            }
        }
        return null;
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized EmbeddableTypeImpl<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> createEmbeddableDomainType(final @UnknownKeyFor @NonNull @Initialized String entityName, final @UnknownKeyFor @NonNull @Initialized CompositeType compositeType, final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ManagedDomainType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> owner) {
        UnknownBasicJavaType javaType = new UnknownBasicJavaType(Object.class, compositeType.getReturnedClassName());
        return new EmbeddableTypeImpl<Object>((JavaType)javaType, null, null, true, this.metamodel.getJpaMetamodel()){

            public PersistentAttribute<Object, Object> findAttribute(String name) {
                return MockSessionFactory.this.createAttribute(name, entityName, compositeType.getSubtypes()[compositeType.getPropertyIndex(name)], owner);
            }
        };
    }

    static {
        NO_OBSERVERS = new SessionFactoryObserver[0];
        NO_RESOLVERS = new EntityNameResolver[0];
        jpaCompliance = new MutableJpaComplianceImpl(Collections.emptyMap());
    }

    class MockEntityDomainType<@UnknownKeyFor X>
    extends EntityTypeImpl<X> {
        public MockEntityDomainType(String entityName) {
            super(entityName, entityName, false, true, false, null, null, MockSessionFactory.this.metamodel.getJpaMetamodel());
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SqmPathSource<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findSubPathSource(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized JpaMetamodelImplementor metamodel) {
            SqmPathSource source = super.findSubPathSource(name, metamodel);
            if (source != null) {
                return source;
            }
            String supertype = MockSessionFactory.this.getSupertype(this.getHibernateEntityName());
            PersistentAttribute superattribute = new MockMappedDomainType(supertype).findAttribute(name);
            if (superattribute != null) {
                return (SqmPathSource)superattribute;
            }
            for (Map.Entry<String, MockEntityPersister> entry : MockSessionFactory.this.entityPersistersByName.entrySet()) {
                PersistentAttribute<X, ?> subattribute;
                if (entry.getValue().getEntityName().equals(this.getHibernateEntityName()) || !MockSessionFactory.this.isSubtype(entry.getValue().getEntityName(), this.getHibernateEntityName()) || (subattribute = new MockEntityDomainType<X>(entry.getValue().getEntityName()).findAttribute(name)) == null) continue;
                return (SqmPathSource)subattribute;
            }
            return null;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PersistentAttribute<@UnknownKeyFor @Nullable @Initialized ? super X, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findAttribute(@UnknownKeyFor @NonNull @Initialized String name) {
            PersistentAttribute attribute = super.findAttribute(name);
            if (attribute != null) {
                return attribute;
            }
            String supertype = MockSessionFactory.this.getSupertype(this.getHibernateEntityName());
            PersistentAttribute superattribute = new MockMappedDomainType(supertype).findAttribute(name);
            if (superattribute != null) {
                return superattribute;
            }
            return null;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PersistentAttribute<X, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findDeclaredAttribute(@UnknownKeyFor @NonNull @Initialized String name) {
            String entityName = this.getHibernateEntityName();
            return MockSessionFactory.this.isAttributeDefined(entityName, name) ? MockSessionFactory.this.createAttribute(name, entityName, MockSessionFactory.this.getReferencedPropertyType(entityName, name), (ManagedDomainType<?>)this) : null;
        }
    }

    class MockMappedDomainType<@UnknownKeyFor X>
    extends MappedSuperclassTypeImpl<X> {
        public MockMappedDomainType(String typeName) {
            super(typeName, false, true, false, null, null, MockSessionFactory.this.metamodel.getJpaMetamodel());
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PersistentAttribute<X, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> findDeclaredAttribute(@UnknownKeyFor @NonNull @Initialized String name) {
            String typeName = this.getTypeName();
            return MockSessionFactory.this.isFieldDefined(typeName, name) ? MockSessionFactory.this.createAttribute(name, typeName, MockSessionFactory.this.propertyType(typeName, name), (ManagedDomainType<?>)this) : null;
        }
    }

    private class MockJpaMetamodelImpl
    extends JpaMetamodelImpl {
        public MockJpaMetamodelImpl() {
            super(typeConfiguration, (MappingMetamodel)MockSessionFactory.this.metamodel, (ServiceRegistry)MockSessionFactory.this.serviceRegistry);
        }

        public <X> @UnknownKeyFor @NonNull @Initialized EntityDomainType<X> entity(@UnknownKeyFor @NonNull @Initialized String entityName) {
            if (MockSessionFactory.this.isEntityDefined(entityName)) {
                return new MockEntityDomainType(entityName);
            }
            return null;
        }

        public <X> @UnknownKeyFor @NonNull @Initialized ManagedDomainType<X> managedType(@UnknownKeyFor @NonNull @Initialized String typeName) {
            String entityName = MockSessionFactory.this.findEntityName(typeName);
            return entityName == null ? null : this.entity(entityName);
        }

        public @UnknownKeyFor @NonNull @Initialized String qualifyImportableName(@UnknownKeyFor @NonNull @Initialized String queryName) {
            if (MockSessionFactory.this.isClassDefined(queryName)) {
                return queryName;
            }
            if (MockSessionFactory.this.isEntityDefined(queryName)) {
                return MockSessionFactory.this.qualifyName(queryName);
            }
            return null;
        }

        public <X> @UnknownKeyFor @NonNull @Initialized ManagedDomainType<X> findManagedType(@UnknownKeyFor @NonNull @Initialized Class<X> cls) {
            throw new UnsupportedOperationException("operation not supported");
        }

        public <X> @UnknownKeyFor @NonNull @Initialized EntityDomainType<X> findEntityType(@UnknownKeyFor @NonNull @Initialized Class<X> cls) {
            if (MockSessionFactory.this.isEntityDefined(cls.getName())) {
                return new MockEntityDomainType(cls.getName());
            }
            return null;
        }

        public <X> @UnknownKeyFor @NonNull @Initialized ManagedDomainType<X> managedType(@UnknownKeyFor @NonNull @Initialized Class<X> cls) {
            throw new UnsupportedOperationException("operation not supported");
        }

        public <X> @UnknownKeyFor @NonNull @Initialized EntityDomainType<X> entity(@UnknownKeyFor @NonNull @Initialized Class<X> cls) {
            throw new UnsupportedOperationException("operation not supported");
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized EnumJavaType<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getEnumType(final @UnknownKeyFor @NonNull @Initialized String className) {
            if (MockSessionFactory.this.isEnum(className)) {
                return new EnumJavaType(Enum.class){

                    public String getTypeName() {
                        return className;
                    }
                };
            }
            return null;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized JavaType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getJavaConstantType(@UnknownKeyFor @NonNull @Initialized String className, @UnknownKeyFor @NonNull @Initialized String fieldName) {
            Class<?> fieldType = MockSessionFactory.this.javaConstantType(className, fieldName);
            return MockSessionFactory.this.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(fieldType);
        }

        public <T> T getJavaConstant(@UnknownKeyFor @NonNull @Initialized String className, @UnknownKeyFor @NonNull @Initialized String fieldName) {
            return null;
        }

        public <E extends Enum<E>> E enumValue(@UnknownKeyFor @NonNull @Initialized EnumJavaType<E> enumType, @UnknownKeyFor @NonNull @Initialized String enumValueName) {
            if (!MockSessionFactory.this.isEnumConstant(enumType.getTypeName(), enumValueName)) {
                throw new IllegalArgumentException("No enum constant " + enumType.getTypeName() + "." + enumValueName);
            }
            return null;
        }

        public @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getEnumTypesForValue(@UnknownKeyFor @NonNull @Initialized String enumValue) {
            return MockSessionFactory.this.getEnumTypesForValue(enumValue);
        }

        public @UnknownKeyFor @NonNull @Initialized JpaCompliance getJpaCompliance() {
            return jpaCompliance;
        }
    }

    private class MockMappingMetamodelImpl
    extends MappingMetamodelImpl {
        public MockMappingMetamodelImpl() {
            super(typeConfiguration, (ServiceRegistry)MockSessionFactory.this.serviceRegistry);
        }

        public @UnknownKeyFor @NonNull @Initialized EntityPersister getEntityDescriptor(@UnknownKeyFor @NonNull @Initialized String entityName) {
            return MockSessionFactory.this.createEntityPersister(entityName);
        }

        public @UnknownKeyFor @NonNull @Initialized EntityPersister entityPersister(@UnknownKeyFor @NonNull @Initialized String entityName) throws @UnknownKeyFor @NonNull @Initialized MappingException {
            return MockSessionFactory.this.createEntityPersister(entityName);
        }

        public @UnknownKeyFor @NonNull @Initialized EntityPersister locateEntityPersister(@UnknownKeyFor @NonNull @Initialized String entityName) throws @UnknownKeyFor @NonNull @Initialized MappingException {
            return MockSessionFactory.this.createEntityPersister(entityName);
        }

        public @UnknownKeyFor @NonNull @Initialized CollectionPersister getCollectionDescriptor(@UnknownKeyFor @NonNull @Initialized String role) {
            return MockSessionFactory.this.createCollectionPersister(role);
        }

        public @UnknownKeyFor @NonNull @Initialized CollectionPersister findCollectionDescriptor(@UnknownKeyFor @NonNull @Initialized String role) {
            return MockSessionFactory.this.createCollectionPersister(role);
        }

        public @UnknownKeyFor @NonNull @Initialized CollectionPersister collectionPersister(@UnknownKeyFor @NonNull @Initialized String role) {
            return MockSessionFactory.this.createCollectionPersister(role);
        }

        public @UnknownKeyFor @NonNull @Initialized JpaMetamodelImplementor getJpaMetamodel() {
            return new MockJpaMetamodelImpl();
        }

        public @UnknownKeyFor @NonNull @Initialized EntityPersister findEntityDescriptor(@UnknownKeyFor @NonNull @Initialized String entityName) {
            return MockSessionFactory.this.createEntityPersister(entityName);
        }

        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getEnumTypesForValue(@UnknownKeyFor @NonNull @Initialized String enumValue) {
            return MockSessionFactory.this.getEnumTypesForValue(enumValue);
        }
    }

    private static class MockMappingDefaults
    implements MappingDefaults {
        private MockMappingDefaults() {
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitSchemaName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitCatalogName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean shouldImplicitlyQuoteIdentifiers() {
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitIdColumnName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitTenantIdColumnName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitDiscriminatorColumnName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitPackageName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isAutoImportEnabled() {
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitCascadeStyleName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized String getImplicitPropertyAccessorName() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean areEntitiesImplicitlyLazy() {
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean areCollectionsImplicitlyLazy() {
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized AccessType getImplicitCacheAccessType() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized CollectionClassification getImplicitListClassification() {
            return null;
        }
    }
}

