/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.TypeUtils;

public abstract class AbstractAnnotatedMethod
implements MetaAttribute {
    final @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity;
    private final @UnknownKeyFor @NonNull @Initialized ExecutableElement method;
    final @UnknownKeyFor @NonNull @Initialized String sessionType;
    final @UnknownKeyFor @NonNull @Initialized String sessionName;

    public AbstractAnnotatedMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized String sessionType) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.method = method;
        this.sessionName = sessionName;
        this.sessionType = sessionType;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }

    @UnknownKeyFor @NonNull @Initialized boolean isUsingEntityManager() {
        return "jakarta.persistence.EntityManager".equals(this.sessionType);
    }

    @UnknownKeyFor @NonNull @Initialized boolean isUsingStatelessSession() {
        return AnnotationMetaEntity.usingStatelessSession(this.sessionType);
    }

    @UnknownKeyFor @NonNull @Initialized boolean isReactive() {
        return AnnotationMetaEntity.usingReactiveSession(this.sessionType);
    }

    @UnknownKeyFor @NonNull @Initialized boolean isReactiveSessionAccess() {
        return AnnotationMetaEntity.usingReactiveSessionAccess(this.sessionType);
    }

    @UnknownKeyFor @NonNull @Initialized String localSessionName() {
        return this.isReactiveSessionAccess() ? "_session" : this.sessionName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized AnnotationMirror> inheritedAnnotations() {
        if (this.annotationMetaEntity.isJakartaDataRepository()) {
            return this.method.getAnnotationMirrors().stream().filter(annotationMirror -> TypeUtils.hasAnnotation(annotationMirror.getAnnotationType().asElement(), "jakarta.interceptor.InterceptorBinding")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

