/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.util.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JpaNamespaceTransformingEventReader
extends EventReaderDelegate {
    private static final @UnknownKeyFor @NonNull @Initialized String VERSION_ATTRIBUTE_NAME = "version";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_PERSISTENCE_VERSION = "3.0";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_ORM_VERSION = "3.1";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_PERSISTENCE_NAMESPACE = "https://jakarta.ee/xml/ns/persistence";
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_ORM_NAMESPACE = "https://jakarta.ee/xml/ns/persistence/orm";
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> NAMESPACE_MAPPING = new HashMap<String, String>(8);
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> START_ELEMENT_TO_NAMESPACE_URI;
    private static final @UnknownKeyFor @NonNull @Initialized String EMPTY_PREFIX = "";
    private final @UnknownKeyFor @NonNull @Initialized XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
    private @UnknownKeyFor @NonNull @Initialized String currentDocumentNamespaceUri;

    public JpaNamespaceTransformingEventReader(@UnknownKeyFor @NonNull @Initialized XMLEventReader reader) {
        super(reader);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized XMLEvent peek() throws @UnknownKeyFor @NonNull @Initialized XMLStreamException {
        return this.wrap(super.peek());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized XMLEvent nextEvent() throws @UnknownKeyFor @NonNull @Initialized XMLStreamException {
        return this.wrap(super.nextEvent());
    }

    private @UnknownKeyFor @NonNull @Initialized XMLEvent wrap(@UnknownKeyFor @NonNull @Initialized XMLEvent event) {
        if (event != null && event.isStartElement()) {
            return this.transform(event.asStartElement());
        }
        return event;
    }

    private @UnknownKeyFor @NonNull @Initialized StartElement transform(@UnknownKeyFor @NonNull @Initialized StartElement startElement) {
        String elementName = startElement.getName().getLocalPart();
        if (START_ELEMENT_TO_NAMESPACE_URI.containsKey(elementName)) {
            this.currentDocumentNamespaceUri = START_ELEMENT_TO_NAMESPACE_URI.get(elementName);
        }
        List<Attribute> newElementAttributeList = this.updateElementAttributes(startElement);
        List<Namespace> newNamespaceList = this.updateElementNamespaces(startElement);
        return this.xmlEventFactory.createStartElement(new QName(this.currentDocumentNamespaceUri, startElement.getName().getLocalPart()), newElementAttributeList.iterator(), newNamespaceList.iterator());
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Namespace> updateElementNamespaces(@UnknownKeyFor @NonNull @Initialized StartElement startElement) {
        ArrayList<Namespace> newNamespaceList = new ArrayList<Namespace>();
        Iterator<Namespace> existingNamespaceIterator = startElement.getNamespaces();
        while (existingNamespaceIterator.hasNext()) {
            Namespace namespace = existingNamespaceIterator.next();
            if (NAMESPACE_MAPPING.containsKey(namespace.getNamespaceURI())) {
                newNamespaceList.add(this.xmlEventFactory.createNamespace(EMPTY_PREFIX, this.currentDocumentNamespaceUri));
                continue;
            }
            newNamespaceList.add(namespace);
        }
        if (newNamespaceList.isEmpty()) {
            newNamespaceList.add(this.xmlEventFactory.createNamespace(EMPTY_PREFIX, this.currentDocumentNamespaceUri));
        }
        return newNamespaceList;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Attribute> updateElementAttributes(@UnknownKeyFor @NonNull @Initialized StartElement startElement) {
        ArrayList<Attribute> newElementAttributeList = new ArrayList<Attribute>();
        Iterator<Attribute> existingAttributesIterator = startElement.getAttributes();
        while (existingAttributesIterator.hasNext()) {
            Attribute attribute = existingAttributesIterator.next();
            if (VERSION_ATTRIBUTE_NAME.equals(attribute.getName().getLocalPart())) {
                if (this.currentDocumentNamespaceUri.equals(DEFAULT_PERSISTENCE_NAMESPACE)) {
                    if (DEFAULT_PERSISTENCE_VERSION.equals(attribute.getName().getPrefix())) continue;
                    newElementAttributeList.add(this.xmlEventFactory.createAttribute(attribute.getName(), DEFAULT_PERSISTENCE_VERSION));
                    continue;
                }
                if (DEFAULT_ORM_VERSION.equals(attribute.getName().getPrefix())) continue;
                newElementAttributeList.add(this.xmlEventFactory.createAttribute(attribute.getName(), DEFAULT_ORM_VERSION));
                continue;
            }
            newElementAttributeList.add(attribute);
        }
        return newElementAttributeList;
    }

    static {
        NAMESPACE_MAPPING.put("http://java.sun.com/xml/ns/persistence", DEFAULT_PERSISTENCE_NAMESPACE);
        NAMESPACE_MAPPING.put("http://java.sun.com/xml/ns/persistence/orm", DEFAULT_ORM_NAMESPACE);
        NAMESPACE_MAPPING.put("http://xmlns.jcp.org/xml/ns/persistence", DEFAULT_PERSISTENCE_NAMESPACE);
        NAMESPACE_MAPPING.put("http://xmlns.jcp.org/xml/ns/persistence/orm", DEFAULT_ORM_NAMESPACE);
        NAMESPACE_MAPPING.put("https://java.sun.com/xml/ns/persistence", DEFAULT_PERSISTENCE_NAMESPACE);
        NAMESPACE_MAPPING.put("https://java.sun.com/xml/ns/persistence/orm", DEFAULT_ORM_NAMESPACE);
        NAMESPACE_MAPPING.put("https://xmlns.jcp.org/xml/ns/persistence", DEFAULT_PERSISTENCE_NAMESPACE);
        NAMESPACE_MAPPING.put("https://xmlns.jcp.org/xml/ns/persistence/orm", DEFAULT_ORM_NAMESPACE);
        START_ELEMENT_TO_NAMESPACE_URI = new HashMap<String, String>(2);
        START_ELEMENT_TO_NAMESPACE_URI.put("persistence", DEFAULT_PERSISTENCE_NAMESPACE);
        START_ELEMENT_TO_NAMESPACE_URI.put("entity-mappings", DEFAULT_ORM_NAMESPACE);
    }
}

