/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.adaptor.impl;

import io.vertx.sqlclient.data.NullValue;

public class JdbcNull {
    private final int jdbcTypeCode;

    JdbcNull(int jdbcTypeCode) {
        this.jdbcTypeCode = jdbcTypeCode;
    }

    public NullValue toNullValue() {
        switch (this.jdbcTypeCode) {
            case -7: 
            case 16: {
                return NullValue.Boolean;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return NullValue.String;
            }
            case 6: 
            case 7: 
            case 8: {
                return NullValue.Double;
            }
            case -5: {
                return NullValue.Long;
            }
            case 4: {
                return NullValue.Integer;
            }
            case -6: 
            case 5: {
                return NullValue.Short;
            }
            case 3: {
                return NullValue.BigDecimal;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return NullValue.Buffer;
            }
            case 93: {
                return NullValue.LocalDateTime;
            }
            case 91: {
                return NullValue.LocalDate;
            }
            case 92: {
                return NullValue.LocalTime;
            }
            case 2014: {
                return NullValue.OffsetDateTime;
            }
            case 2013: {
                return NullValue.OffsetTime;
            }
        }
        return null;
    }

    public int getJdbcTypeCode() {
        return this.jdbcTypeCode;
    }
}

