/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.adaptor.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.jdbc.Expectation;
import org.hibernate.sql.model.TableMapping;

public class PrepareStatementDetailsAdaptor
implements PreparedStatementDetails {
    private final PreparedStatementDetails delegate;
    private final PreparedStatement statement;
    private final JdbcServices jdbcServices;

    public PrepareStatementDetailsAdaptor(PreparedStatementDetails delegate, PreparedStatement statement, JdbcServices jdbcServices) {
        this.delegate = delegate;
        this.statement = statement;
        this.jdbcServices = jdbcServices;
    }

    public TableMapping getMutatingTableDetails() {
        return this.delegate.getMutatingTableDetails();
    }

    public String getSqlString() {
        return this.delegate.getSqlString();
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public PreparedStatement resolveStatement() {
        try {
            this.delegate.getExpectation().prepare(this.statement);
            return this.statement;
        }
        catch (SQLException e) {
            throw this.jdbcServices.getSqlExceptionHelper().convert(e, "Unable to prepare for expectation", this.getSqlString());
        }
    }

    public Expectation getExpectation() {
        return this.delegate.getExpectation();
    }

    public boolean isCallable() {
        return this.delegate.isCallable();
    }

    public void releaseStatement(SharedSessionContractImplementor session) {
        this.delegate.releaseStatement(session);
    }
}

