/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.adaptor.impl;

import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.function.Function;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.reactive.adaptor.impl.JdbcNull;

public class PreparedStatementAdaptor
implements PreparedStatement {
    static final Object[] NO_PARAMS = new Object[0];
    Object[] params = NO_PARAMS;
    int size = 0;

    public static Object[] bind(Binder binder) {
        try {
            PreparedStatementAdaptor statement = new PreparedStatementAdaptor();
            binder.bind(statement);
            return statement.getParametersAsArray();
        }
        catch (SQLException e) {
            throw new AssertionFailure("SQLException should never occur", (Throwable)e);
        }
    }

    void put(int parameterIndex, Object parameter) {
        if (this.params.length <= parameterIndex) {
            this.params = Arrays.copyOf(this.params, 4 + parameterIndex * 2);
        }
        this.params[parameterIndex - 1] = parameter;
        if (this.size < parameterIndex) {
            this.size = parameterIndex;
        }
    }

    void clear() {
        this.params = NO_PARAMS;
    }

    public Object[] getParametersAsArray() {
        return Arrays.copyOf(this.params, this.size);
    }

    @Override
    public ResultSet executeQuery() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) {
        this.put(parameterIndex, new JdbcNull(sqlType));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) {
        this.put(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) {
        this.put(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) {
        this.put(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) {
        this.put(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) {
        this.put(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) {
        this.put(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) {
        this.put(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) {
        this.put(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) {
        this.put(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) {
        this.put(parameterIndex, Buffer.buffer((byte[])x));
    }

    @Override
    public void setDate(int parameterIndex, Date x) {
        this.put(parameterIndex, x.toLocalDate());
    }

    @Override
    public void setTime(int parameterIndex, Time x) {
        this.put(parameterIndex, x.toLocalTime());
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) {
        this.put(parameterIndex, x.toLocalTime());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) {
        this.put(parameterIndex, x.toLocalDateTime());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) {
        this.setTimestamp(parameterIndex, x, cal, ZonedDateTime::toOffsetDateTime);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal, Function<ZonedDateTime, Temporal> converter) {
        this.put(parameterIndex, converter.apply(x.toInstant().atZone(cal.getTimeZone().toZoneId())));
    }

    public void setTimestamp(String name, Timestamp x, Calendar cal, Function<ZonedDateTime, Temporal> converter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearParameters() {
        this.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) {
        this.put(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) {
        this.put(parameterIndex, x);
    }

    @Override
    public boolean execute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBatch() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) {
        this.put(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) {
        this.put(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) {
        this.put(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) {
        try {
            this.put(parameterIndex, x.getArray());
        }
        catch (SQLException e) {
            throw new AssertionFailure("This shouldn't have happened");
        }
    }

    @Override
    public ResultSetMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) {
        this.put(parameterIndex, x.toLocalDate());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) {
        this.put(parameterIndex, new JdbcNull(sqlType));
    }

    @Override
    public void setURL(int parameterIndex, URL x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) {
        this.put(parameterIndex, Buffer.buffer((byte[])x.getBytes()));
    }

    @Override
    public void setNString(int parameterIndex, String value) {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) {
        this.put(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream is, long length) {
        try {
            this.put(parameterIndex, PreparedStatementAdaptor.convertToBuffer(is));
        }
        catch (IOException e) {
            throw new HibernateException((Throwable)e);
        }
    }

    private static Buffer convertToBuffer(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            bytesStream.write(data, 0, nRead);
        }
        bytesStream.flush();
        return Buffer.buffer((byte[])bytesStream.toByteArray());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) {
        try {
            int n;
            int charsLength = (int)length;
            char[] chars = new char[charsLength];
            int charsRead = 0;
            while ((n = reader.read(chars, charsRead, charsLength - charsRead)) != -1 && (long)(charsRead += n) != length) {
            }
            this.setString(parameterIndex, new String(chars, 0, charsRead));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet executeQuery(String sql) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxRows() {
        return 0;
    }

    @Override
    public void setMaxRows(int max) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getQueryTimeout() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setQueryTimeout(int seconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void setCursorName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getUpdateCount() {
        return -1;
    }

    @Override
    public boolean getMoreResults() {
        return false;
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchSize() {
        return 1;
    }

    @Override
    public void setFetchSize(int rows) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetConcurrency() {
        return 1007;
    }

    @Override
    public int getResultSetType() {
        return 1003;
    }

    @Override
    public void addBatch(String sql) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearBatch() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] executeBatch() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getMoreResults(int current) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getGeneratedKeys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean isPoolable() {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        throw new UnsupportedOperationException();
    }

    @FunctionalInterface
    public static interface Binder {
        public void bind(PreparedStatement var1) throws SQLException;
    }
}

