/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.context.impl;

import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import java.lang.invoke.MethodHandles;
import org.hibernate.reactive.context.Context;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.vertx.VertxInstance;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class VertxContext
implements Context,
ServiceRegistryAwareService {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private static final boolean trace = LOG.isTraceEnabled();
    private VertxInstance vertxInstance;

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.vertxInstance = (VertxInstance)serviceRegistry.getService(VertxInstance.class);
    }

    @Override
    public <T> void put(Context.Key<T> key, T instance) {
        io.vertx.core.Context context = Vertx.currentContext();
        if (context != null) {
            if (trace) {
                LOG.tracef("Putting key,value in context: [%1$s, %2$s]", key, instance);
            }
        } else {
            if (trace) {
                LOG.tracef("Context is null for key,value: [%1$s, %2$s]", key, instance);
            }
            throw LOG.notVertxContextActive();
        }
        context.putLocal(key, instance);
    }

    @Override
    public <T> T get(Context.Key<T> key) {
        io.vertx.core.Context context = Vertx.currentContext();
        if (context != null) {
            Object local = context.getLocal(key);
            if (trace) {
                LOG.tracef("Getting value %2$s from context for key %1$s", key, local);
            }
            return (T)local;
        }
        if (trace) {
            LOG.tracef("Context is null. Returning null for key %s", key);
        }
        return null;
    }

    @Override
    public void remove(Context.Key<?> key) {
        io.vertx.core.Context context = Vertx.currentContext();
        if (context != null) {
            boolean removed = context.removeLocal(key);
            if (trace) {
                LOG.tracef("Key %s removed from context: %s", key, removed);
            }
        } else if (trace) {
            LOG.tracef("Context is null, nothing to remove for key %s", key);
        }
    }

    @Override
    public void execute(Runnable runnable) {
        io.vertx.core.Context currentContext = Vertx.currentContext();
        if (currentContext == null) {
            if (trace) {
                LOG.tracef("Not in a Vert.x context, checking the VertxInstance service", new Object[0]);
            }
            io.vertx.core.Context newContext = this.vertxInstance.getVertx().getOrCreateContext();
            ContextInternal newContextInternal = (ContextInternal)newContext;
            ContextInternal duplicate = newContextInternal.duplicate();
            if (trace) {
                LOG.tracef("Using duplicated context from VertxInstance: %s", duplicate);
            }
            duplicate.runOnContext(x -> runnable.run());
        } else {
            if (trace) {
                LOG.tracef("Running in the current Vert.x context %s", currentContext);
            }
            runnable.run();
        }
    }
}

