/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.PropertyValueException;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.action.internal.EntityDeleteAction;
import org.hibernate.action.internal.UnresolvedEntityInsertActions;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.spi.ComparableExecutable;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExecutableList;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.engine.ReactiveAfterTransactionCompletionProcess;
import org.hibernate.reactive.engine.ReactiveBeforeTransactionCompletionProcess;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.engine.impl.QueuedOperationCollectionAction;
import org.hibernate.reactive.engine.impl.ReactiveCollectionRecreateAction;
import org.hibernate.reactive.engine.impl.ReactiveCollectionRemoveAction;
import org.hibernate.reactive.engine.impl.ReactiveCollectionUpdateAction;
import org.hibernate.reactive.engine.impl.ReactiveEntityActionVetoException;
import org.hibernate.reactive.engine.impl.ReactiveEntityDeleteAction;
import org.hibernate.reactive.engine.impl.ReactiveEntityInsertAction;
import org.hibernate.reactive.engine.impl.ReactiveEntityInsertActionHolder;
import org.hibernate.reactive.engine.impl.ReactiveEntityRegularInsertAction;
import org.hibernate.reactive.engine.impl.ReactiveEntityUpdateAction;
import org.hibernate.reactive.engine.impl.ReactiveOrphanRemovalAction;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;

public class ReactiveActionQueue {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ReactiveSession session;
    private UnresolvedEntityInsertActions unresolvedInsertions;
    private ExecutableList<ReactiveEntityInsertActionHolder> insertions;
    private ExecutableList<ReactiveEntityDeleteAction> deletions;
    private ExecutableList<ReactiveEntityUpdateAction> updates;
    private ExecutableList<ReactiveCollectionRecreateAction> collectionCreations;
    private ExecutableList<ReactiveCollectionUpdateAction> collectionUpdates;
    private ExecutableList<QueuedOperationCollectionAction> collectionQueuedOps;
    private ExecutableList<ReactiveCollectionRemoveAction> collectionRemovals;
    private ExecutableList<ReactiveOrphanRemovalAction> orphanRemovals;
    private transient boolean isTransactionCoordinatorShared;
    private AfterTransactionCompletionProcessQueue afterTransactionProcesses;
    private BeforeTransactionCompletionProcessQueue beforeTransactionProcesses;
    private static final OrderedActions[] ORDERED_OPERATIONS = OrderedActions.values();

    public ReactiveActionQueue(ReactiveSession session) {
        this.session = session;
        this.isTransactionCoordinatorShared = false;
    }

    public void clear() {
        for (OrderedActions value : ORDERED_OPERATIONS) {
            ExecutableList list = value.getActions(this);
            if (list == null) continue;
            list.clear();
        }
        if (this.unresolvedInsertions != null) {
            this.unresolvedInsertions.clear();
        }
    }

    public CompletionStage<Void> addAction(ReactiveEntityInsertAction action) {
        LOG.tracev("Adding a ReactiveEntityRegularInsertAction for [{0}] object", action.getEntityName());
        return this.addInsertAction(action);
    }

    private CompletionStage<Void> addInsertAction(ReactiveEntityInsertAction insert) {
        return this.executeEarlyInsertsIfRequired(insert).thenCompose(v -> insert.reactiveFindNonNullableTransientEntities()).thenCompose(nonNullables -> {
            if (nonNullables == null) {
                LOG.tracev("Adding insert with no non-nullable, transient entities: [{0}]", insert);
                return this.addResolvedEntityInsertAction(insert);
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Adding insert with non-nullable, transient entities; insert=[{0}], dependencies=[{1}]", insert, nonNullables.toLoggableString(insert.getSession()));
            }
            if (this.unresolvedInsertions == null) {
                this.unresolvedInsertions = new UnresolvedEntityInsertActions();
            }
            this.unresolvedInsertions.addUnresolvedEntityInsertAction(insert.asAbstractEntityInsertAction(), nonNullables);
            return CompletionStages.voidFuture();
        });
    }

    private CompletionStage<Void> executeEarlyInsertsIfRequired(ReactiveEntityInsertAction insert) {
        if (insert.isEarlyInsert()) {
            LOG.tracev("Executing inserts before finding non-nullable transient entities for early insert: [{0}]", insert);
            return this.executeInserts();
        }
        return CompletionStages.voidFuture();
    }

    private CompletionStage<Void> addResolvedEntityInsertAction(ReactiveEntityInsertAction insert) {
        if (insert.isEarlyInsert()) {
            LOG.tracev("Executing inserts before finding non-nullable transient entities for early insert: [{0}]", insert);
            return this.executeInserts().thenCompose(v -> {
                LOG.debug("Executing identity-insert immediately");
                return this.execute(insert);
            }).thenCompose(v -> this.postResolvedEntityInsertAction(insert));
        }
        LOG.trace("Adding resolved non-early insert action.");
        OrderedActions.EntityInsertAction.ensureInitialized(this);
        this.insertions.add((ComparableExecutable)new ReactiveEntityInsertActionHolder(insert));
        return this.postResolvedEntityInsertAction(insert);
    }

    private CompletionStage<Void> postResolvedEntityInsertAction(ReactiveEntityInsertAction insert) {
        if (!insert.isVeto()) {
            return insert.reactiveMakeEntityManaged().thenCompose(v -> {
                if (this.unresolvedInsertions != null) {
                    return CompletionStages.loop(this.unresolvedInsertions.resolveDependentActions(insert.getInstance(), this.session.getSharedContract()), resolvedAction -> this.addResolvedEntityInsertAction((ReactiveEntityRegularInsertAction)resolvedAction));
                }
                return CompletionStages.voidFuture();
            });
        }
        throw new ReactiveEntityActionVetoException("The ReactiveEntityInsertAction was vetoed.", insert);
    }

    private static String[] convertTimestampSpaces(Serializable[] spaces) {
        return (String[])spaces;
    }

    private static boolean areTablesToBeUpdated(ExecutableList<?> actions, Set tableSpaces) {
        if (actions == null || actions.isEmpty()) {
            return false;
        }
        for (Serializable actionSpace : actions.getQuerySpaces()) {
            if (!tableSpaces.contains(actionSpace)) continue;
            LOG.debugf("Changes must be flushed to space: %s", actionSpace);
            return true;
        }
        return false;
    }

    private static boolean areTablesToBeUpdated(UnresolvedEntityInsertActions actions, Set tableSpaces) {
        for (Executable action : actions.getDependentEntityInsertActions()) {
            for (String space : action.getPropertySpaces()) {
                if (!tableSpaces.contains(space)) continue;
                LOG.debugf("Changes must be flushed to space: %s", space);
                return true;
            }
        }
        return false;
    }

    private static String[] convertTimestampSpaces(Set<Serializable> spaces) {
        return spaces.toArray(new String[0]);
    }

    private static String toString(ExecutableList<?> q) {
        return q == null ? "ExecutableList{size=0}" : q.toString();
    }

    public void addAction(ReactiveEntityDeleteAction action) {
        OrderedActions.EntityDeleteAction.ensureInitialized(this);
        this.deletions.add((ComparableExecutable)action);
    }

    public void addAction(ReactiveOrphanRemovalAction action) {
        OrderedActions.OrphanRemovalAction.ensureInitialized(this);
        this.orphanRemovals.add((ComparableExecutable)action);
    }

    public void addAction(ReactiveEntityUpdateAction action) {
        OrderedActions.EntityUpdateAction.ensureInitialized(this);
        this.updates.add((ComparableExecutable)action);
    }

    public void addAction(ReactiveCollectionRecreateAction action) {
        OrderedActions.CollectionRecreateAction.ensureInitialized(this);
        this.collectionCreations.add((ComparableExecutable)action);
    }

    public void addAction(ReactiveCollectionRemoveAction action) {
        OrderedActions.CollectionRemoveAction.ensureInitialized(this);
        this.collectionRemovals.add((ComparableExecutable)action);
    }

    public void addAction(ReactiveCollectionUpdateAction action) {
        OrderedActions.CollectionUpdateAction.ensureInitialized(this);
        this.collectionUpdates.add((ComparableExecutable)action);
    }

    public void addAction(QueuedOperationCollectionAction action) {
        OrderedActions.QueuedOperationCollectionAction.ensureInitialized(this);
        this.collectionQueuedOps.add((ComparableExecutable)action);
    }

    public void addAction(BulkOperationCleanupAction action) {
        this.registerCleanupActions((Executable)action);
    }

    private void registerCleanupActions(Executable executable) {
        if (executable.getBeforeTransactionCompletionProcess() != null) {
            this.beforeTransactionProcesses();
            this.beforeTransactionProcesses.register(executable.getBeforeTransactionCompletionProcess());
        }
        if (this.session.getFactory().getSessionFactoryOptions().isQueryCacheEnabled()) {
            this.invalidateSpaces(ReactiveActionQueue.convertTimestampSpaces((Serializable[])executable.getPropertySpaces()));
        }
        if (executable.getAfterTransactionCompletionProcess() != null) {
            this.afterTransactionProcesses();
            this.afterTransactionProcesses.register(executable.getAfterTransactionCompletionProcess());
        }
    }

    public boolean hasUnresolvedEntityInsertActions() {
        return this.unresolvedInsertions != null && !this.unresolvedInsertions.isEmpty();
    }

    public void checkNoUnresolvedActionsAfterOperation() throws PropertyValueException {
        if (this.unresolvedInsertions != null) {
            this.unresolvedInsertions.checkNoUnresolvedActionsAfterOperation();
        }
    }

    public void registerProcess(AfterTransactionCompletionProcess process) {
        this.afterTransactionProcesses().register(process);
    }

    public void registerProcess(BeforeTransactionCompletionProcess process) {
        this.beforeTransactionProcesses().register(process);
    }

    public void registerProcess(ReactiveAfterTransactionCompletionProcess process) {
        this.afterTransactionProcesses().registerReactive(process);
    }

    public void registerProcess(ReactiveBeforeTransactionCompletionProcess process) {
        this.beforeTransactionProcesses().registerReactive(process);
    }

    private BeforeTransactionCompletionProcessQueue beforeTransactionProcesses() {
        if (this.beforeTransactionProcesses == null) {
            this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
        }
        return this.beforeTransactionProcesses;
    }

    private AfterTransactionCompletionProcessQueue afterTransactionProcesses() {
        if (this.afterTransactionProcesses == null) {
            this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
        }
        return this.afterTransactionProcesses;
    }

    public CompletionStage<Void> executeInserts() {
        if (this.insertions != null && !this.insertions.isEmpty()) {
            return this.executeActions(this.insertions);
        }
        return CompletionStages.voidFuture();
    }

    public CompletionStage<Void> executeActions() {
        if (this.hasUnresolvedEntityInsertActions()) {
            return CompletionStages.failedFuture(new IllegalStateException("About to execute actions, but there are unresolved entity insert actions."));
        }
        CompletionStage<Void> ret = CompletionStages.voidFuture();
        for (OrderedActions action : ORDERED_OPERATIONS) {
            ret = ret.thenCompose(v -> this.executeActions(action.getActions(this)));
        }
        return ret;
    }

    public void prepareActions() throws HibernateException {
        this.prepareActions(this.collectionRemovals);
        this.prepareActions(this.collectionUpdates);
        this.prepareActions(this.collectionCreations);
        this.prepareActions(this.collectionQueuedOps);
    }

    private void prepareActions(ExecutableList<?> queue) throws HibernateException {
        if (queue == null) {
            return;
        }
        for (Executable executable : queue) {
            executable.beforeExecutions();
        }
    }

    public CompletionStage<Void> afterTransactionCompletion(boolean success) {
        if (!this.isTransactionCoordinatorShared && this.afterTransactionProcesses != null) {
            return this.afterTransactionProcesses.afterTransactionCompletion(success);
        }
        return CompletionStages.voidFuture();
    }

    public CompletionStage<Void> beforeTransactionCompletion() {
        if (!this.isTransactionCoordinatorShared && this.beforeTransactionProcesses != null) {
            return this.beforeTransactionProcesses.beforeTransactionCompletion();
        }
        return CompletionStages.voidFuture();
    }

    public boolean areInsertionsOrDeletionsQueued() {
        return this.insertions != null && !this.insertions.isEmpty() || this.hasUnresolvedEntityInsertActions() || this.deletions != null && !this.deletions.isEmpty() || this.orphanRemovals != null && !this.orphanRemovals.isEmpty();
    }

    public boolean areTablesToBeUpdated(Set tables) {
        if (tables.isEmpty()) {
            return false;
        }
        for (OrderedActions action : ORDERED_OPERATIONS) {
            ExecutableList list = action.getActions(this);
            if (!ReactiveActionQueue.areTablesToBeUpdated(list, tables)) continue;
            return true;
        }
        if (this.unresolvedInsertions == null) {
            return false;
        }
        return ReactiveActionQueue.areTablesToBeUpdated(this.unresolvedInsertions, tables);
    }

    private CompletionStage<Void> executeActions(ExecutableList<? extends ReactiveExecutable> list) throws HibernateException {
        if (list == null || list.isEmpty()) {
            return CompletionStages.voidFuture();
        }
        return CompletionStages.loop(0, list.size(), index -> {
            ReactiveExecutable e = (ReactiveExecutable)list.get(index);
            return e.reactiveExecute().whenComplete((v2, x1) -> {
                if (e.getBeforeTransactionCompletionProcess() != null) {
                    this.beforeTransactionProcesses().register(e.getBeforeTransactionCompletionProcess());
                }
                if (e.getAfterTransactionCompletionProcess() != null) {
                    this.afterTransactionProcesses().register(e.getAfterTransactionCompletionProcess());
                }
            });
        }).whenComplete((v, x) -> {
            if (this.session.getFactory().getSessionFactoryOptions().isQueryCacheEnabled()) {
                this.invalidateSpaces(ReactiveActionQueue.convertTimestampSpaces(list.getQuerySpaces()));
            }
        }).thenRun(() -> list.clear()).thenCompose(v -> this.session.getReactiveConnection().executeBatch());
    }

    public <E extends ReactiveExecutable> CompletionStage<Void> execute(E executable) {
        return executable.reactiveExecute().whenComplete((v, x) -> this.registerCleanupActions(executable));
    }

    private void invalidateSpaces(String[] spaces) {
        if (spaces != null && spaces.length > 0) {
            for (String s : spaces) {
                this.afterTransactionProcesses().addSpaceToInvalidate(s);
            }
            this.session.getFactory().getCache().getTimestampsCache().preInvalidate(spaces, (SharedSessionContractImplementor)this.session.getSharedContract());
        }
    }

    public String toString() {
        return "ReactiveActionQueue[insertions=" + ReactiveActionQueue.toString(this.insertions) + " updates=" + ReactiveActionQueue.toString(this.updates) + " deletions=" + ReactiveActionQueue.toString(this.deletions) + " orphanRemovals=" + ReactiveActionQueue.toString(this.orphanRemovals) + " collectionCreations=" + ReactiveActionQueue.toString(this.collectionCreations) + " collectionRemovals=" + ReactiveActionQueue.toString(this.collectionRemovals) + " collectionUpdates=" + ReactiveActionQueue.toString(this.collectionUpdates) + " collectionQueuedOps=" + ReactiveActionQueue.toString(this.collectionQueuedOps) + " unresolvedInsertDependencies=" + this.unresolvedInsertions + "]";
    }

    public int numberOfCollectionRemovals() {
        if (this.collectionRemovals == null) {
            return 0;
        }
        return this.collectionRemovals.size();
    }

    public int numberOfCollectionUpdates() {
        if (this.collectionUpdates == null) {
            return 0;
        }
        return this.collectionUpdates.size();
    }

    public int numberOfCollectionCreations() {
        if (this.collectionCreations == null) {
            return 0;
        }
        return this.collectionCreations.size();
    }

    public int numberOfDeletions() {
        int del = this.deletions == null ? 0 : this.deletions.size();
        int orph = this.orphanRemovals == null ? 0 : this.orphanRemovals.size();
        return del + orph;
    }

    public int numberOfUpdates() {
        if (this.updates == null) {
            return 0;
        }
        return this.updates.size();
    }

    public int numberOfInsertions() {
        if (this.insertions == null) {
            return 0;
        }
        return this.insertions.size();
    }

    public void sortCollectionActions() {
        if (this.isOrderUpdatesEnabled()) {
            if (this.collectionCreations != null) {
                this.collectionCreations.sort();
            }
            if (this.collectionUpdates != null) {
                this.collectionUpdates.sort();
            }
            if (this.collectionQueuedOps != null) {
                this.collectionQueuedOps.sort();
            }
            if (this.collectionRemovals != null) {
                this.collectionRemovals.sort();
            }
        }
    }

    public void sortActions() {
        if (this.isOrderUpdatesEnabled() && this.updates != null) {
            this.updates.sort();
        }
        if (this.isOrderInsertsEnabled() && this.insertions != null) {
            this.insertions.sort();
        }
    }

    private boolean isOrderUpdatesEnabled() {
        return this.session.getFactory().getSessionFactoryOptions().isOrderUpdatesEnabled();
    }

    private boolean isOrderInsertsEnabled() {
        return this.session.getFactory().getSessionFactoryOptions().isOrderInsertsEnabled();
    }

    public void clearFromFlushNeededCheck(int previousCollectionRemovalSize) {
        if (this.collectionCreations != null) {
            this.collectionCreations.clear();
        }
        if (this.collectionUpdates != null) {
            this.collectionUpdates.clear();
        }
        if (this.collectionQueuedOps != null) {
            this.collectionQueuedOps.clear();
        }
        if (this.updates != null) {
            this.updates.clear();
        }
        if (this.collectionRemovals != null && this.collectionRemovals.size() > previousCollectionRemovalSize) {
            this.collectionRemovals.removeLastN(this.collectionRemovals.size() - previousCollectionRemovalSize);
        }
    }

    public boolean hasAfterTransactionActions() {
        return this.isTransactionCoordinatorShared ? false : this.afterTransactionProcesses != null && this.afterTransactionProcesses.hasActions();
    }

    public boolean hasBeforeTransactionActions() {
        return this.isTransactionCoordinatorShared ? false : this.beforeTransactionProcesses != null && this.beforeTransactionProcesses.hasActions();
    }

    public boolean hasAnyQueuedActions() {
        return this.updates != null && !this.updates.isEmpty() || this.insertions != null && !this.insertions.isEmpty() || this.hasUnresolvedEntityInsertActions() || this.deletions != null && !this.deletions.isEmpty() || this.collectionUpdates != null && !this.collectionUpdates.isEmpty() || this.collectionQueuedOps != null && !this.collectionQueuedOps.isEmpty() || this.collectionRemovals != null && !this.collectionRemovals.isEmpty() || this.collectionCreations != null && !this.collectionCreations.isEmpty();
    }

    public void unScheduleDeletion(EntityEntry entry, Object rescuedEntity) {
        EntityDeleteAction action;
        LazyInitializer initializer;
        if (rescuedEntity instanceof HibernateProxy && !(initializer = ((HibernateProxy)rescuedEntity).getHibernateLazyInitializer()).isUninitialized()) {
            rescuedEntity = initializer.getImplementation((SharedSessionContractImplementor)this.session.getSharedContract());
        }
        if (this.deletions != null) {
            for (int i = 0; i < this.deletions.size(); ++i) {
                action = (EntityDeleteAction)this.deletions.get(i);
                if (action.getInstance() != rescuedEntity) continue;
                this.deletions.remove(i);
                return;
            }
        }
        if (this.orphanRemovals != null) {
            for (int i = 0; i < this.orphanRemovals.size(); ++i) {
                action = (EntityDeleteAction)this.orphanRemovals.get(i);
                if (action.getInstance() != rescuedEntity) continue;
                this.orphanRemovals.remove(i);
                return;
            }
        }
        throw new AssertionFailure("Unable to perform un-delete for instance " + entry.getEntityName());
    }

    private static class InsertActionSorter
    implements ExecutableList.Sorter<ReactiveEntityInsertActionHolder> {
        public static final InsertActionSorter INSTANCE = new InsertActionSorter();
        private Map<BatchIdentifier, List<ReactiveEntityInsertActionHolder>> actionBatches;

        public void sort(List<ReactiveEntityInsertActionHolder> insertions) {
            this.actionBatches = new HashMap<BatchIdentifier, List<ReactiveEntityInsertActionHolder>>();
            ArrayList<BatchIdentifier> latestBatches = new ArrayList<BatchIdentifier>();
            for (ReactiveEntityInsertActionHolder action : insertions) {
                ReactiveEntityInsertAction actionDelegate = action.getDelegate();
                BatchIdentifier batchIdentifier = new BatchIdentifier(actionDelegate.getEntityName(), actionDelegate.getSession().getFactory().getMappingMetamodel().getEntityDescriptor(actionDelegate.getEntityName()).getRootEntityName());
                int index = latestBatches.indexOf(batchIdentifier);
                if (index != -1) {
                    batchIdentifier = (BatchIdentifier)latestBatches.get(index);
                } else {
                    latestBatches.add(batchIdentifier);
                }
                this.addParentChildEntityNames(actionDelegate, batchIdentifier);
                this.addToBatch(batchIdentifier, actionDelegate);
            }
            insertions.clear();
            for (int i = 0; i < latestBatches.size(); ++i) {
                int j;
                BatchIdentifier batchIdentifier = (BatchIdentifier)latestBatches.get(i);
                for (j = i - 1; j >= 0; --j) {
                    BatchIdentifier prevBatchIdentifier = (BatchIdentifier)latestBatches.get(j);
                    if (prevBatchIdentifier.hasAnyParentEntityNames(batchIdentifier)) {
                        prevBatchIdentifier.parent = batchIdentifier;
                    }
                    if (!batchIdentifier.hasAnyChildEntityNames(prevBatchIdentifier)) continue;
                    prevBatchIdentifier.parent = batchIdentifier;
                }
                for (j = i + 1; j < latestBatches.size(); ++j) {
                    BatchIdentifier nextBatchIdentifier = (BatchIdentifier)latestBatches.get(j);
                    if (nextBatchIdentifier.hasAnyParentEntityNames(batchIdentifier)) {
                        nextBatchIdentifier.parent = batchIdentifier;
                        nextBatchIdentifier.getParentEntityNames().add(batchIdentifier.getEntityName());
                    }
                    if (!batchIdentifier.hasAnyChildEntityNames(nextBatchIdentifier)) continue;
                    nextBatchIdentifier.parent = batchIdentifier;
                    nextBatchIdentifier.getParentEntityNames().add(batchIdentifier.getEntityName());
                }
            }
            boolean sorted = false;
            long maxIterations = (long)latestBatches.size() * (long)latestBatches.size();
            long iterations = 0L;
            block4: do {
                ++iterations;
                for (int i = 0; i < latestBatches.size(); ++i) {
                    BatchIdentifier batchIdentifier = (BatchIdentifier)latestBatches.get(i);
                    for (int j = i + 1; j < latestBatches.size(); ++j) {
                        BatchIdentifier nextBatchIdentifier = (BatchIdentifier)latestBatches.get(j);
                        if (!batchIdentifier.hasParent(nextBatchIdentifier) || nextBatchIdentifier.hasParent(batchIdentifier)) continue;
                        latestBatches.remove(batchIdentifier);
                        latestBatches.add(j, batchIdentifier);
                        continue block4;
                    }
                }
                sorted = true;
            } while (!sorted && iterations <= maxIterations);
            if (iterations > maxIterations) {
                LOG.warn("The batch containing " + latestBatches.size() + " statements could not be sorted after " + maxIterations + " iterations. This might indicate a circular entity relationship.");
            }
            for (BatchIdentifier rootIdentifier : latestBatches) {
                insertions.addAll((Collection<ReactiveEntityInsertActionHolder>)this.actionBatches.get(rootIdentifier));
            }
        }

        private void addParentChildEntityNames(ReactiveEntityInsertAction action, BatchIdentifier batchIdentifier) {
            Object[] propertyValues = action.getState();
            ClassMetadata classMetadata = action.getPersister().getClassMetadata();
            if (classMetadata != null) {
                Type[] propertyTypes = classMetadata.getPropertyTypes();
                Type identifierType = classMetadata.getIdentifierType();
                for (int i = 0; i < propertyValues.length; ++i) {
                    Object value = propertyValues[i];
                    if (value == null) continue;
                    Type type = propertyTypes[i];
                    this.addParentChildEntityNameByPropertyAndValue(action, batchIdentifier, type, value);
                }
                if (identifierType.isComponentType()) {
                    Type[] compositeIdentifierTypes;
                    CompositeType compositeType = (CompositeType)identifierType;
                    for (Type type : compositeIdentifierTypes = compositeType.getSubtypes()) {
                        this.addParentChildEntityNameByPropertyAndValue(action, batchIdentifier, type, null);
                    }
                }
            }
        }

        private void addParentChildEntityNameByPropertyAndValue(ReactiveEntityInsertAction action, BatchIdentifier batchIdentifier, Type type, Object value) {
            block8: {
                block9: {
                    MappingMetamodelImplementor mappingMetamodel;
                    block6: {
                        String valueClass;
                        String rootEntityName;
                        String entityName;
                        block7: {
                            mappingMetamodel = action.getSession().getFactory().getRuntimeMetamodels().getMappingMetamodel();
                            if (!type.isEntityType()) break block6;
                            EntityType entityType = (EntityType)type;
                            entityName = entityType.getName();
                            rootEntityName = mappingMetamodel.getEntityDescriptor(entityName).getRootEntityName();
                            if (!entityType.isOneToOne() || entityType.getForeignKeyDirection() != ForeignKeyDirection.TO_PARENT) break block7;
                            if (!entityType.isReferenceToPrimaryKey()) {
                                batchIdentifier.getChildEntityNames().add(entityName);
                            }
                            if (!rootEntityName.equals(entityName)) {
                                batchIdentifier.getChildEntityNames().add(rootEntityName);
                            }
                            break block8;
                        }
                        if (!batchIdentifier.getEntityName().equals(entityName)) {
                            batchIdentifier.getParentEntityNames().add(entityName);
                        }
                        if (value != null && !(valueClass = value.getClass().getName()).equals(entityName)) {
                            batchIdentifier.getParentEntityNames().add(valueClass);
                        }
                        if (rootEntityName.equals(entityName)) break block8;
                        batchIdentifier.getParentEntityNames().add(rootEntityName);
                        break block8;
                    }
                    if (!type.isCollectionType()) break block9;
                    CollectionType collectionType = (CollectionType)type;
                    SessionFactoryImplementor sessionFactory = action.getSession().getSessionFactory();
                    if (!collectionType.getElementType(sessionFactory).isEntityType() || mappingMetamodel.getCollectionDescriptor(collectionType.getRole()).isManyToMany()) break block8;
                    String entityName = collectionType.getAssociatedEntityName(sessionFactory);
                    String rootEntityName = mappingMetamodel.getEntityDescriptor(entityName).getRootEntityName();
                    batchIdentifier.getChildEntityNames().add(entityName);
                    if (rootEntityName.equals(entityName)) break block8;
                    batchIdentifier.getChildEntityNames().add(rootEntityName);
                    break block8;
                }
                if (type.isComponentType() && value != null) {
                    CompositeType compositeType = (CompositeType)type;
                    SharedSessionContractImplementor session = action.getSession();
                    Object[] componentValues = compositeType.getPropertyValues(value, session);
                    for (int j = 0; j < componentValues.length; ++j) {
                        Type componentValueType = compositeType.getSubtypes()[j];
                        Object componentValue = componentValues[j];
                        this.addParentChildEntityNameByPropertyAndValue(action, batchIdentifier, componentValueType, componentValue);
                    }
                }
            }
        }

        private void addToBatch(BatchIdentifier batchIdentifier, ReactiveEntityInsertAction action) {
            List actions = this.actionBatches.computeIfAbsent(batchIdentifier, k -> new LinkedList());
            actions.add(new ReactiveEntityInsertActionHolder(action));
        }

        private static class BatchIdentifier {
            private final String entityName;
            private final String rootEntityName;
            private Set<String> parentEntityNames = new HashSet<String>();
            private Set<String> childEntityNames = new HashSet<String>();
            private BatchIdentifier parent;

            BatchIdentifier(String entityName, String rootEntityName) {
                this.entityName = entityName;
                this.rootEntityName = rootEntityName;
            }

            public BatchIdentifier getParent() {
                return this.parent;
            }

            public void setParent(BatchIdentifier parent) {
                this.parent = parent;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof BatchIdentifier)) {
                    return false;
                }
                BatchIdentifier that = (BatchIdentifier)o;
                return Objects.equals(this.entityName, that.entityName);
            }

            public int hashCode() {
                return Objects.hash(this.entityName);
            }

            String getEntityName() {
                return this.entityName;
            }

            String getRootEntityName() {
                return this.rootEntityName;
            }

            Set<String> getParentEntityNames() {
                return this.parentEntityNames;
            }

            Set<String> getChildEntityNames() {
                return this.childEntityNames;
            }

            boolean hasAnyParentEntityNames(BatchIdentifier batchIdentifier) {
                return this.parentEntityNames.contains(batchIdentifier.getEntityName()) || this.parentEntityNames.contains(batchIdentifier.getRootEntityName());
            }

            boolean hasAnyChildEntityNames(BatchIdentifier batchIdentifier) {
                return this.childEntityNames.contains(batchIdentifier.getEntityName());
            }

            boolean hasParent(BatchIdentifier batchIdentifier) {
                return this.parent == batchIdentifier || this.parentEntityNames.contains(batchIdentifier.getEntityName()) || this.parent != null && this.parent.hasParent(batchIdentifier, new ArrayList<BatchIdentifier>());
            }

            private boolean hasParent(BatchIdentifier batchIdentifier, List<BatchIdentifier> stack) {
                if (!stack.contains(this) && this.parent != null) {
                    stack.add(this);
                    return this.parent.hasParent(batchIdentifier, stack);
                }
                return this.parent == batchIdentifier || this.parentEntityNames.contains(batchIdentifier.getEntityName());
            }
        }
    }

    private static class AfterTransactionCompletionProcessQueue
    extends AbstractTransactionCompletionProcessQueue<AfterTransactionCompletionProcess, ReactiveAfterTransactionCompletionProcess> {
        private final Set<String> querySpacesToInvalidate = new HashSet<String>();

        private AfterTransactionCompletionProcessQueue(ReactiveSession session) {
            super(session);
        }

        public void addSpaceToInvalidate(String space) {
            this.querySpacesToInvalidate.add(space);
        }

        public CompletionStage<Void> afterTransactionCompletion(boolean success) {
            while (!this.processes.isEmpty()) {
                try {
                    ((AfterTransactionCompletionProcess)this.processes.poll()).doAfterTransactionCompletion(success, (SharedSessionContractImplementor)this.session.getSharedContract());
                }
                catch (CacheException ce) {
                    LOG.unableToReleaseCacheLock(ce);
                }
                catch (Exception e2) {
                    throw new AssertionFailure("Exception releasing cache locks", (Throwable)e2);
                }
            }
            if (this.session.getFactory().getSessionFactoryOptions().isQueryCacheEnabled()) {
                this.session.getFactory().getCache().getTimestampsCache().invalidate(this.querySpacesToInvalidate.toArray(new String[0]), (SharedSessionContractImplementor)this.session.getSharedContract());
            }
            this.querySpacesToInvalidate.clear();
            return CompletionStages.loop(this.reactiveProcesses, process -> process.doAfterTransactionCompletion(success, this.session)).whenComplete((v, e) -> this.reactiveProcesses.clear());
        }
    }

    private static class BeforeTransactionCompletionProcessQueue
    extends AbstractTransactionCompletionProcessQueue<BeforeTransactionCompletionProcess, ReactiveBeforeTransactionCompletionProcess> {
        private BeforeTransactionCompletionProcessQueue(ReactiveSession session) {
            super(session);
        }

        public CompletionStage<Void> beforeTransactionCompletion() {
            while (!this.processes.isEmpty()) {
                try {
                    ((BeforeTransactionCompletionProcess)this.processes.poll()).doBeforeTransactionCompletion(this.session.getSharedContract());
                }
                catch (HibernateException he) {
                    throw he;
                }
                catch (Exception e2) {
                    throw new AssertionFailure("Unable to perform beforeTransactionCompletion callback", (Throwable)e2);
                }
            }
            return CompletionStages.loop(this.reactiveProcesses, process -> process.doBeforeTransactionCompletion(this.session)).whenComplete((v, e) -> this.reactiveProcesses.clear());
        }
    }

    private static abstract class AbstractTransactionCompletionProcessQueue<T, U> {
        final ReactiveSession session;
        protected Queue<T> processes = new ConcurrentLinkedQueue<T>();
        protected Queue<U> reactiveProcesses = new ConcurrentLinkedQueue<U>();

        private AbstractTransactionCompletionProcessQueue(ReactiveSession session) {
            this.session = session;
        }

        public void register(T process) {
            if (process == null) {
                return;
            }
            this.processes.add(process);
        }

        public void registerReactive(U process) {
            if (process == null) {
                return;
            }
            this.reactiveProcesses.add(process);
        }

        public boolean hasActions() {
            return !this.processes.isEmpty() || !this.reactiveProcesses.isEmpty();
        }
    }

    private static enum OrderedActions {
        CollectionRemoveAction{

            public ExecutableList<?> getActions(ReactiveActionQueue instance) {
                return instance.collectionRemovals;
            }

            @Override
            public void ensureInitialized(ReactiveActionQueue instance) {
                if (instance.collectionRemovals == null) {
                    instance.collectionRemovals = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        OrphanRemovalAction{

            public ExecutableList<?> getActions(ReactiveActionQueue instance) {
                return instance.orphanRemovals;
            }

            @Override
            public void ensureInitialized(ReactiveActionQueue instance) {
                if (instance.orphanRemovals == null) {
                    instance.orphanRemovals = new ExecutableList(false);
                }
            }
        }
        ,
        EntityInsertAction{

            public ExecutableList<?> getActions(ReactiveActionQueue instance) {
                return instance.insertions;
            }

            @Override
            public void ensureInitialized(ReactiveActionQueue instance) {
                if (instance.insertions == null) {
                    instance.insertions = instance.isOrderInsertsEnabled() ? new ExecutableList((ExecutableList.Sorter)InsertActionSorter.INSTANCE) : new ExecutableList(false);
                }
            }
        }
        ,
        EntityUpdateAction{

            public ExecutableList<?> getActions(ReactiveActionQueue instance) {
                return instance.updates;
            }

            @Override
            public void ensureInitialized(ReactiveActionQueue instance) {
                if (instance.updates == null) {
                    instance.updates = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        QueuedOperationCollectionAction{

            public ExecutableList<?> getActions(ReactiveActionQueue instance) {
                return instance.collectionQueuedOps;
            }

            @Override
            public void ensureInitialized(ReactiveActionQueue instance) {
                if (instance.collectionQueuedOps == null) {
                    instance.collectionQueuedOps = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        CollectionUpdateAction{

            public ExecutableList<?> getActions(ReactiveActionQueue instance) {
                return instance.collectionUpdates;
            }

            @Override
            public void ensureInitialized(ReactiveActionQueue instance) {
                if (instance.collectionUpdates == null) {
                    instance.collectionUpdates = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        CollectionRecreateAction{

            public ExecutableList<?> getActions(ReactiveActionQueue instance) {
                return instance.collectionCreations;
            }

            @Override
            public void ensureInitialized(ReactiveActionQueue instance) {
                if (instance.collectionCreations == null) {
                    instance.collectionCreations = new ExecutableList(instance.isOrderUpdatesEnabled());
                }
            }
        }
        ,
        EntityDeleteAction{

            public ExecutableList<?> getActions(ReactiveActionQueue instance) {
                return instance.deletions;
            }

            @Override
            public void ensureInitialized(ReactiveActionQueue instance) {
                if (instance.deletions == null) {
                    instance.deletions = new ExecutableList(false);
                }
            }
        };


        public abstract <T extends ReactiveExecutable & ComparableExecutable> ExecutableList<T> getActions(ReactiveActionQueue var1);

        public abstract void ensureInitialized(ReactiveActionQueue var1);
    }
}

