/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.hibernate.CacheMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.DeleteContext;
import org.hibernate.event.spi.EventSource;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.engine.impl.CascadingAction;
import org.hibernate.reactive.engine.impl.CascadingActions;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

public final class Cascade {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    private Cascade() {
    }

    public static CompletionStage<?> fetchLazyAssociationsBeforeCascade(CascadingAction<?> action, EntityPersister persister, Object entity, EventSource session) {
        CompletionStage<Void> beforeDelete = CompletionStages.voidFuture();
        if (persister.hasCascades()) {
            CascadeStyle[] cascadeStyles = persister.getPropertyCascadeStyles();
            Object[] state = persister.getValues(entity);
            for (int i = 0; i < cascadeStyles.length; ++i) {
                Object fetchable;
                if (!cascadeStyles[i].doCascade(action.delegate()) || Hibernate.isInitialized((Object)(fetchable = state[i]))) continue;
                beforeDelete = beforeDelete.thenCompose(v -> ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactiveFetch(fetchable, true));
            }
        }
        return beforeDelete;
    }

    public static <T> CompletionStage<Void> cascade(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, EntityPersister persister, Object parent, T anything) throws HibernateException {
        CacheMode cacheMode = eventSource.getCacheMode();
        if (action == CascadingActions.REMOVE) {
            eventSource.setCacheMode(CacheMode.GET);
        }
        eventSource.getPersistenceContextInternal().incrementCascadeLevel();
        return CompletionStages.voidFuture().thenCompose(v -> Cascade.cascadeInternal(action, cascadePoint, eventSource, persister, parent, anything)).whenComplete((unused, throwable) -> {
            eventSource.getPersistenceContextInternal().decrementCascadeLevel();
            eventSource.setCacheMode(cacheMode);
        });
    }

    private static <T> CompletionStage<Void> cascadeInternal(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, EntityPersister persister, Object parent, T anything) {
        if (persister.hasCascades() || action == CascadingActions.CHECK_ON_FLUSH) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Processing cascade {0} for: {1}", action, persister.getEntityName());
            }
            return Cascade.doCascade(action, cascadePoint, eventSource, persister, parent, anything).thenRun(() -> {
                if (traceEnabled) {
                    LOG.tracev("Done processing cascade {0} for: {1}", action, persister.getEntityName());
                }
            });
        }
        return CompletionStages.voidFuture();
    }

    private static <T> CompletionStage<Void> doCascade(CascadingAction action, CascadePoint cascadePoint, EventSource eventSource, EntityPersister persister, Object parent, T anything) throws HibernateException {
        PersistenceContext persistenceContext = eventSource.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(parent);
        if (entry != null && entry.getLoadedState() == null && entry.getStatus() == Status.MANAGED && persister.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
            return CompletionStages.voidFuture();
        }
        Type[] types = persister.getPropertyTypes();
        String[] propertyNames = persister.getPropertyNames();
        CascadeStyle[] cascadeStyles = persister.getPropertyCascadeStyles();
        boolean hasUninitializedLazyProperties = persister.hasUninitializedLazyProperties(parent);
        CompletionStage<Void> stage = CompletionStages.voidFuture();
        for (int i = 0; i < types.length; ++i) {
            CascadeStyle style = cascadeStyles[i];
            String propertyName = propertyNames[i];
            boolean isUninitializedProperty = hasUninitializedLazyProperties && !persister.getBytecodeEnhancementMetadata().isAttributeLoaded(parent, propertyName);
            Type type = types[i];
            if (style.doCascade(action.delegate())) {
                if (isUninitializedProperty) {
                    if (entry == null) continue;
                    if (type.isCollectionType()) {
                        CollectionType collectionType = (CollectionType)type;
                        Object child = collectionType.getCollection(collectionType.getKeyOfOwner(parent, (SharedSessionContractImplementor)eventSource), (SharedSessionContractImplementor)eventSource, parent, null);
                        stage = stage.thenCompose(v -> Cascade.cascadeProperty(action, cascadePoint, eventSource, null, parent, child, type, style, propertyName, anything, false));
                        continue;
                    }
                    if (type.isComponentType()) {
                        throw new UnsupportedOperationException("Lazy components are not supported.");
                    }
                    if (!action.performOnLazyProperty() || !type.isEntityType()) continue;
                    LazyAttributeLoadingInterceptor interceptor = persister.getBytecodeEnhancementMetadata().extractInterceptor(parent);
                    stage = stage.thenCompose(v -> (CompletionStage)interceptor.fetchAttribute(parent, propertyName)).thenCompose(actualChild -> Cascade.cascadeProperty(action, cascadePoint, eventSource, null, parent, actualChild, type, style, propertyName, anything, false));
                    continue;
                }
                Object child = persister.getValue(parent, i);
                stage = stage.thenCompose(v -> Cascade.cascadeProperty(action, cascadePoint, eventSource, null, parent, child, type, style, propertyName, anything, false));
                continue;
            }
            if (!action.deleteOrphans() || isUninitializedProperty) continue;
            int index = i;
            stage = stage.thenCompose(v -> Cascade.cascadeLogicalOneToOneOrphanRemoval(action, eventSource, null, parent, persister.getValue(parent, index), type, style, propertyName, false));
        }
        return stage;
    }

    private static <T> CompletionStage<Void> cascadeProperty(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, List<String> componentPath, Object parent, Object child, Type type, CascadeStyle style, String propertyName, T anything, boolean isCascadeDeleteEnabled) throws HibernateException {
        if (child != null) {
            if (type.isAssociationType()) {
                AssociationType associationType = (AssociationType)type;
                boolean unownedTransient = eventSource.getSessionFactory().getSessionFactoryOptions().isUnownedAssociationTransientCheck();
                if (Cascade.cascadeAssociationNow(action, cascadePoint, associationType, eventSource.getFactory(), unownedTransient)) {
                    List<String> path = componentPath;
                    return Cascade.cascadeAssociation(action, cascadePoint, eventSource, path, parent, child, type, style, anything, isCascadeDeleteEnabled).thenCompose(v -> Cascade.cascadeLogicalOneToOne(action, eventSource, path, parent, child, type, style, propertyName, isCascadeDeleteEnabled));
                }
            } else if (type.isComponentType()) {
                if (componentPath == null && propertyName != null) {
                    componentPath = new ArrayList<String>();
                }
                if (componentPath != null) {
                    componentPath.add(propertyName);
                }
                List<String> path = componentPath;
                return Cascade.cascadeComponent(action, cascadePoint, eventSource, path, parent, child, (CompositeType)type, anything).thenRun(() -> {
                    if (path != null) {
                        path.remove(path.size() - 1);
                    }
                }).thenCompose(v -> Cascade.cascadeLogicalOneToOne(action, eventSource, path, parent, child, type, style, propertyName, isCascadeDeleteEnabled));
            }
        }
        return Cascade.cascadeLogicalOneToOne(action, eventSource, componentPath, parent, child, type, style, propertyName, isCascadeDeleteEnabled);
    }

    private static <T> CompletionStage<Void> cascadeLogicalOneToOne(CascadingAction<T> action, EventSource eventSource, List<String> componentPath, Object parent, Object child, Type type, CascadeStyle style, String propertyName, boolean isCascadeDeleteEnabled) {
        return Cascade.isLogicalOneToOne(type) ? Cascade.cascadeLogicalOneToOneOrphanRemoval(action, eventSource, componentPath, parent, child, type, style, propertyName, isCascadeDeleteEnabled) : CompletionStages.voidFuture();
    }

    private static <T> CompletionStage<Void> cascadeLogicalOneToOneOrphanRemoval(CascadingAction<T> action, EventSource eventSource, List<String> componentPath, Object parent, Object child, Type type, CascadeStyle style, String propertyName, boolean isCascadeDeleteEnabled) throws HibernateException {
        PersistenceContext persistenceContext;
        EntityEntry entry;
        if (style.hasOrphanDelete() && action.deleteOrphans() && (entry = (persistenceContext = eventSource.getPersistenceContextInternal()).getEntry(parent)) != null && entry.getStatus() != Status.SAVING) {
            Object loadedValue;
            if (componentPath == null) {
                loadedValue = entry.getLoadedValue(propertyName);
            } else {
                AttributeMapping propertyType = entry.getPersister().findAttributeMapping(componentPath.get(0));
                if (propertyType instanceof ComponentType) {
                    loadedValue = entry.getLoadedValue(componentPath.get(0));
                    ComponentType componentType = (ComponentType)propertyType;
                    if (componentPath.size() != 1) {
                        for (int i = 1; i < componentPath.size(); ++i) {
                            int subPropertyIndex = componentType.getPropertyIndex(componentPath.get(i));
                            loadedValue = componentType.getPropertyValue(loadedValue, subPropertyIndex);
                            componentType = (ComponentType)componentType.getSubtypes()[subPropertyIndex];
                        }
                    }
                    loadedValue = componentType.getPropertyValue(loadedValue, componentType.getPropertyIndex(propertyName));
                } else {
                    loadedValue = null;
                }
            }
            if (child == null || loadedValue != null && child != loadedValue) {
                EntityEntry valueEntry = persistenceContext.getEntry(loadedValue);
                if (valueEntry == null && ManagedTypeHelper.isHibernateProxy((Object)loadedValue)) {
                    loadedValue = persistenceContext.unproxyAndReassociate(loadedValue);
                    valueEntry = persistenceContext.getEntry(loadedValue);
                    if (child == loadedValue) {
                        return CompletionStages.voidFuture();
                    }
                }
                if (valueEntry != null) {
                    EntityPersister persister = valueEntry.getPersister();
                    String entityName = persister.getEntityName();
                    if (LOG.isTraceEnabled()) {
                        LOG.tracev("Deleting orphaned entity instance: {0}", MessageHelper.infoString((String)entityName, (Object)persister.getIdentifier(loadedValue, (SharedSessionContractImplementor)eventSource)));
                    }
                    if (type.isAssociationType() && ((AssociationType)type).getForeignKeyDirection().equals((Object)ForeignKeyDirection.TO_PARENT)) {
                        return ((ReactiveSession)eventSource).reactiveRemoveOrphanBeforeUpdates(entityName, loadedValue);
                    }
                    return ((ReactiveSession)eventSource).reactiveRemove(entityName, loadedValue, isCascadeDeleteEnabled, DeleteContext.create());
                }
            }
        }
        return CompletionStages.voidFuture();
    }

    private static boolean isLogicalOneToOne(Type type) {
        return type.isEntityType() && ((EntityType)type).isLogicalOneToOne();
    }

    private static boolean cascadeAssociationNow(CascadingAction<?> action, CascadePoint cascadePoint, AssociationType associationType, SessionFactoryImplementor factory, boolean unownedTransient) {
        return associationType.getForeignKeyDirection().cascadeNow(cascadePoint) && (action != CascadingActions.CHECK_ON_FLUSH || unownedTransient || !Cascade.isUnownedAssociation(associationType, factory));
    }

    private static boolean isUnownedAssociation(AssociationType associationType, SessionFactoryImplementor factory) {
        if (associationType.isEntityType()) {
            if (associationType instanceof ManyToOneType) {
                ManyToOneType manyToOne = (ManyToOneType)associationType;
                return manyToOne.isLogicalOneToOne() && manyToOne.getRHSUniqueKeyPropertyName() != null;
            }
            if (associationType instanceof OneToOneType) {
                OneToOneType oneToOne = (OneToOneType)associationType;
                return oneToOne.isNullable() && oneToOne.getRHSUniqueKeyPropertyName() != null;
            }
        } else if (associationType.isCollectionType()) {
            return ((CollectionType)associationType).isInverse(factory);
        }
        return false;
    }

    private static <T> CompletionStage<Void> cascadeComponent(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, List<String> componentPath, Object parent, Object child, CompositeType componentType, T anything) {
        Object[] children = null;
        Type[] types = componentType.getSubtypes();
        String[] propertyNames = componentType.getPropertyNames();
        CompletionStage<Void> stage = CompletionStages.voidFuture();
        for (int i = 0; i < types.length; ++i) {
            CascadeStyle componentPropertyStyle = componentType.getCascadeStyle(i);
            String subPropertyName = propertyNames[i];
            if (!componentPropertyStyle.doCascade(action.delegate()) && (!componentPropertyStyle.hasOrphanDelete() || !action.deleteOrphans())) continue;
            if (children == null) {
                children = componentType.getPropertyValues(child, (SharedSessionContractImplementor)eventSource);
            }
            void propertyChild = children[i];
            Type propertyType = types[i];
            stage = stage.thenCompose(v -> Cascade.cascadeProperty(action, cascadePoint, eventSource, componentPath, parent, propertyChild, propertyType, componentPropertyStyle, subPropertyName, anything, false));
        }
        return stage;
    }

    private static <T> CompletionStage<Void> cascadeAssociation(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, List<String> componentPath, Object parent, Object child, Type type, CascadeStyle style, T anything, boolean isCascadeDeleteEnabled) {
        if (type.isEntityType() || type.isAnyType()) {
            return Cascade.cascadeToOne(action, eventSource, parent, child, type, style, anything, isCascadeDeleteEnabled);
        }
        if (type.isCollectionType()) {
            return Cascade.cascadeCollection(action, cascadePoint, eventSource, componentPath, parent, child, style, anything, (CollectionType)type);
        }
        return CompletionStages.voidFuture();
    }

    private static <T> CompletionStage<Void> cascadeCollection(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, List<String> componentPath, Object parent, Object child, CascadeStyle style, T anything, CollectionType type) {
        CollectionPersister persister = eventSource.getFactory().getMappingMetamodel().getCollectionDescriptor(type.getRole());
        Type elemType = persister.getElementType();
        if (elemType.isEntityType() || elemType.isAnyType() || elemType.isComponentType()) {
            return Cascade.cascadeCollectionElements(action, cascadePoint == CascadePoint.AFTER_INSERT_BEFORE_DELETE ? CascadePoint.AFTER_INSERT_BEFORE_DELETE_VIA_COLLECTION : cascadePoint, eventSource, componentPath, parent, child, type, style, elemType, anything, persister.isCascadeDeleteEnabled());
        }
        return CompletionStages.voidFuture();
    }

    private static <T> CompletionStage<Void> cascadeToOne(CascadingAction<T> action, EventSource eventSource, Object parent, Object child, Type type, CascadeStyle style, T anything, boolean isCascadeDeleteEnabled) {
        String entityName;
        String string = entityName = type.isEntityType() ? ((EntityType)type).getAssociatedEntityName() : null;
        if (style.reallyDoCascade(action.delegate())) {
            PersistenceContext persistenceContext = eventSource.getPersistenceContextInternal();
            persistenceContext.addChildParent(child, parent);
            return CompletionStages.voidFuture().thenCompose(v -> action.cascade(eventSource, child, entityName, anything, isCascadeDeleteEnabled)).whenComplete((v, e) -> persistenceContext.removeChildParent(child));
        }
        return CompletionStages.voidFuture();
    }

    private static <T> CompletionStage<Void> cascadeCollectionElements(CascadingAction<T> action, CascadePoint cascadePoint, EventSource eventSource, List<String> componentPath, Object parent, Object child, CollectionType collectionType, CascadeStyle style, Type elemType, T anything, boolean isCascadeDeleteEnabled) throws HibernateException {
        boolean reallyDoCascade;
        boolean bl = reallyDoCascade = style.reallyDoCascade(action.delegate()) && child != CollectionType.UNFETCHED_COLLECTION;
        if (reallyDoCascade) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Done cascade {0} for collection: {1}", action, collectionType.getRole());
            }
            Iterator<?> itr = action.getCascadableChildrenIterator(eventSource, collectionType, child);
            return CompletionStages.loop(itr, (value, integer) -> Cascade.cascadeProperty(action, cascadePoint, eventSource, componentPath, parent, value, elemType, style, collectionType.getRole().substring(collectionType.getRole().lastIndexOf(46) + 1), anything, isCascadeDeleteEnabled)).thenRun(() -> {
                if (traceEnabled) {
                    LOG.tracev("Done cascade {0} for collection: {1}", action, collectionType.getRole());
                }
            }).thenCompose(v -> Cascade.doDeleteOrphans(action, eventSource, child, collectionType, style, elemType));
        }
        return Cascade.doDeleteOrphans(action, eventSource, child, collectionType, style, elemType);
    }

    private static <T> CompletionStage<Void> doDeleteOrphans(CascadingAction<T> action, EventSource eventSource, Object child, CollectionType collectionType, CascadeStyle style, Type elemType) {
        boolean deleteOrphans;
        boolean bl = deleteOrphans = style.hasOrphanDelete() && action.deleteOrphans() && elemType.isEntityType() && child instanceof PersistentCollection && !((PersistentCollection)child).isNewlyInstantiated();
        if (deleteOrphans) {
            boolean traceEnabled = LOG.isTraceEnabled();
            if (traceEnabled) {
                LOG.tracev("Deleting orphans for collection: {0}", collectionType.getRole());
            }
            String entityName = collectionType.getAssociatedEntityName(eventSource.getFactory());
            return Cascade.doDeleteOrphans(eventSource, entityName, (PersistentCollection)child).thenRun(() -> {
                if (traceEnabled) {
                    LOG.tracev("Done deleting orphans for collection: {0}", collectionType.getRole());
                }
            });
        }
        return CompletionStages.voidFuture();
    }

    private static CompletionStage<Void> doDeleteOrphans(EventSource eventSource, String entityName, PersistentCollection<?> pc) {
        Collection<?> orphans = Cascade.getOrphans(eventSource, entityName, pc);
        ReactiveSession session = (ReactiveSession)eventSource;
        return CompletionStages.loop(orphans, Objects::nonNull, orphan -> {
            LOG.tracev("Deleting orphaned entity instance: {0}", entityName);
            return session.reactiveRemove(entityName, orphan, false, DeleteContext.create());
        });
    }

    private static Collection<?> getOrphans(EventSource eventSource, String entityName, PersistentCollection<?> pc) {
        if (pc.wasInitialized()) {
            CollectionEntry ce = eventSource.getPersistenceContextInternal().getCollectionEntry(pc);
            return ce == null ? Collections.EMPTY_LIST : ce.getOrphans(entityName, pc);
        }
        return pc.getQueuedOrphans(entityName);
    }
}

