/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PreCollectionRemoveEvent;
import org.hibernate.event.spi.PreCollectionRemoveEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.persister.collection.impl.ReactiveCollectionPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ReactiveCollectionRemoveAction
extends CollectionAction
implements ReactiveExecutable {
    private final Object affectedOwner;
    private final boolean emptySnapshot;

    public ReactiveCollectionRemoveAction(PersistentCollection collection, CollectionPersister persister, Object key, boolean emptySnapshot, EventSource session) {
        super(persister, collection, key, session);
        if (collection == null) {
            throw new AssertionFailure("collection == null");
        }
        this.emptySnapshot = emptySnapshot;
        this.affectedOwner = session.getPersistenceContextInternal().getLoadedCollectionOwnerOrNull(collection);
    }

    public ReactiveCollectionRemoveAction(CollectionPersister persister, Object id, EventSource session) {
        super(persister, null, id, session);
        this.emptySnapshot = false;
        this.affectedOwner = null;
    }

    @Override
    public CompletionStage<Void> reactiveExecute() {
        CompletionStage<Void> removeStage;
        this.preRemove();
        EventSource session = this.getSession();
        if (this.emptySnapshot) {
            removeStage = CompletionStages.voidFuture();
        } else {
            ReactiveCollectionPersister reactivePersister = (ReactiveCollectionPersister)this.getPersister();
            removeStage = reactivePersister.reactiveRemove(this.getKey(), (SharedSessionContractImplementor)session);
        }
        return removeStage.thenAccept(arg_0 -> this.lambda$reactiveExecute$0((SharedSessionContractImplementor)session, arg_0));
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException("Use reactiveExecute() instead");
    }

    private void preRemove() {
        this.getFastSessionServices().eventListenerGroup_PRE_COLLECTION_REMOVE.fireLazyEventOnEachListener(this::newPreCollectionRemoveEvent, PreCollectionRemoveEventListener::onPreRemoveCollection);
    }

    private PreCollectionRemoveEvent newPreCollectionRemoveEvent() {
        return new PreCollectionRemoveEvent(this.getPersister(), this.getCollection(), this.eventSource(), this.affectedOwner);
    }

    private void postRemove() {
        this.getFastSessionServices().eventListenerGroup_POST_COLLECTION_REMOVE.fireLazyEventOnEachListener(this::newPostCollectionRemoveEvent, PostCollectionRemoveEventListener::onPostRemoveCollection);
    }

    private PostCollectionRemoveEvent newPostCollectionRemoveEvent() {
        return new PostCollectionRemoveEvent(this.getPersister(), this.getCollection(), this.eventSource(), this.affectedOwner);
    }

    private /* synthetic */ void lambda$reactiveExecute$0(SharedSessionContractImplementor session, Void v) {
        PersistentCollection collection = this.getCollection();
        if (collection != null) {
            session.getPersistenceContextInternal().getCollectionEntry(collection).afterAction(collection);
        }
        this.evict();
        this.postRemove();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.updateCollection(this.getPersister().getRole());
        }
    }
}

