/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.impl.ReactiveEntityInsertAction;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ReactiveEntityRegularInsertAction
extends EntityInsertAction
implements ReactiveEntityInsertAction {
    private final boolean isVersionIncrementDisabled;
    private boolean executed;
    private boolean transientReferencesNullified;

    public ReactiveEntityRegularInsertAction(Object id, Object[] state, Object instance, Object version, EntityPersister persister, boolean isVersionIncrementDisabled, EventSource session) {
        super(id, state, instance, version, persister, isVersionIncrementDisabled, session);
        this.isVersionIncrementDisabled = isVersionIncrementDisabled;
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Void> reactiveExecute() throws HibernateException {
        CompletionStage stage = this.reactiveNullifyTransientReferencesIfNotAlready();
        EntityPersister persister = this.getPersister();
        EventSource session = this.getSession();
        Object instance = this.getInstance();
        Object id = this.getId();
        boolean veto = this.preInsert();
        if (!veto) {
            ReactiveEntityPersister reactivePersister = (ReactiveEntityPersister)persister;
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            return stage.thenCompose(arg_0 -> this.lambda$reactiveExecute$0(reactivePersister, id, instance, (SharedSessionContractImplementor)session, arg_0)).thenCompose(arg_0 -> this.lambda$reactiveExecute$2(persistenceContext, instance, reactivePersister, (SharedSessionContractImplementor)session, id, persister, arg_0));
        }
        this.putCacheIfNecessary();
        this.handleNaturalIdPostSaveNotifications(id);
        this.postInsert();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled()) {
            statistics.insertEntity(this.getPersister().getEntityName());
        }
        this.markExecuted();
        return stage;
    }

    private CompletionStage<Void> processInsertGeneratedProperties(ReactiveEntityPersister persister, SharedSessionContractImplementor session, Object instance, Object id, GeneratedValues generatedValues, EntityEntry entry) {
        if (persister.hasInsertGeneratedProperties()) {
            if (persister.isVersionPropertyGenerated()) {
                throw new UnsupportedOperationException("generated version attribute not supported in Hibernate Reactive");
            }
            return persister.reactiveProcessInsertGenerated(id, instance, this.getState(), generatedValues, session).thenAccept(v -> entry.postUpdate(instance, this.getState(), this.getVersion()));
        }
        return CompletionStages.voidFuture();
    }

    @Override
    public EntityKey getEntityKey() {
        return super.getEntityKey();
    }

    @Override
    public void addCollectionsByKeyToPersistenceContext(PersistenceContext persistenceContext, Object[] objects) {
        super.addCollectionsByKeyToPersistenceContext(persistenceContext, objects);
    }

    @Override
    public AbstractEntityInsertAction asAbstractEntityInsertAction() {
        return this;
    }

    protected void markExecuted() {
        super.markExecuted();
        this.executed = true;
    }

    @Override
    public Object getRowId() {
        return super.getRowId();
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }

    @Override
    public boolean isVersionIncrementDisabled() {
        return this.isVersionIncrementDisabled;
    }

    @Override
    public boolean areTransientReferencesNullified() {
        return this.transientReferencesNullified;
    }

    @Override
    public void setTransientReferencesNullified() {
        this.transientReferencesNullified = true;
    }

    private /* synthetic */ CompletionStage lambda$reactiveExecute$2(PersistenceContext persistenceContext, Object instance, ReactiveEntityPersister reactivePersister, SharedSessionContractImplementor session, Object id, EntityPersister persister, GeneratedValues generatedValues) {
        EntityEntry entry = persistenceContext.getEntry(instance);
        if (entry == null) {
            throw new AssertionFailure("possible non-threadsafe access to session");
        }
        entry.postInsert(this.getState());
        return this.processInsertGeneratedProperties(reactivePersister, session, instance, id, generatedValues, entry).thenAccept(vv -> {
            persistenceContext.registerInsertedKey(persister, this.getId());
            this.addCollectionsByKeyToPersistenceContext(persistenceContext, this.getState());
            this.putCacheIfNecessary();
            this.handleNaturalIdPostSaveNotifications(id);
            this.postInsert();
            StatisticsImplementor statistics = session.getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.insertEntity(this.getPersister().getEntityName());
            }
            this.markExecuted();
        });
    }

    private /* synthetic */ CompletionStage lambda$reactiveExecute$0(ReactiveEntityPersister reactivePersister, Object id, Object instance, SharedSessionContractImplementor session, Void v) {
        return reactivePersister.insertReactive(id, this.getState(), instance, session, false);
    }
}

