/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.jdbc.env.internal;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.reactive.adaptor.impl.PrepareStatementDetailsAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.engine.jdbc.ResultsCheckerUtil;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;

public interface ReactiveMutationExecutor
extends MutationExecutor {
    default public GeneratedValues execute(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        throw LoggerFactory.make(Log.class, MethodHandles.lookup()).nonReactiveMethodCall("executeReactive");
    }

    default public CompletionStage<GeneratedValues> executeReactive(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        return this.executeReactive(modelReference, valuesAnalysis, inclusionChecker, resultChecker, session, true, null);
    }

    default public CompletionStage<GeneratedValues> executeReactive(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session, boolean isIdentityInsert, String[] identifierColumnsNames) {
        return this.performReactiveNonBatchedOperations(modelReference, valuesAnalysis, inclusionChecker, resultChecker, session, isIdentityInsert, identifierColumnsNames).thenCompose(generatedValues -> this.performReactiveSelfExecutingOperations(valuesAnalysis, inclusionChecker, session).thenCompose(v -> this.performReactiveBatchedOperations(valuesAnalysis, inclusionChecker, resultChecker, session)).thenApply(v -> generatedValues));
    }

    default public CompletionStage<GeneratedValues> performReactiveNonBatchedOperations(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session, boolean isIdentityInsert, String[] identifierColumnsNames) {
        return CompletionStages.nullFuture();
    }

    default public CompletionStage<Void> performReactiveSelfExecutingOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, SharedSessionContractImplementor session) {
        return CompletionStages.voidFuture();
    }

    default public CompletionStage<Void> performReactiveBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        return CompletionStages.voidFuture();
    }

    private static String createInsert(String insertSql, String identifierColumnName, Dialect dialect) {
        Object sql = insertSql;
        String sqlEnd = " returning " + identifierColumnName;
        Dialect realDialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect);
        if (realDialect instanceof MySQLDialect) {
            int index = ((String)sql).lastIndexOf(sqlEnd);
            return index > -1 ? ((String)sql).substring(0, index) : sql;
        }
        if (realDialect instanceof SQLServerDialect) {
            int index = ((String)sql).lastIndexOf(sqlEnd);
            if (index > -1) {
                sql = ((String)sql).substring(0, index);
            }
            if (((String)sql).endsWith("default values")) {
                index = ((String)sql).indexOf("default values");
                sql = ((String)sql).substring(0, index);
                sql = (String)sql + "output inserted." + identifierColumnName + " default values";
            } else {
                sql = ((String)sql).replace(") values (", ") output inserted." + identifierColumnName + " values (");
            }
            return sql;
        }
        if (realDialect instanceof DB2Dialect) {
            return ((String)sql).replace(" values ( ))", " (" + identifierColumnName + ") values (default))");
        }
        if (realDialect instanceof OracleDialect) {
            String valuesStr = " values ( )";
            int index = ((String)sql).lastIndexOf(sqlEnd);
            if (index > -1) {
                sql = ((String)sql).substring(0, index);
            }
            if (((String)sql).endsWith(" values ( )")) {
                index = ((String)sql).lastIndexOf(" values ( )");
                sql = ((String)sql).substring(0, index);
                sql = (String)sql + " values (default)";
            }
            return sql;
        }
        return sql;
    }

    default public CompletionStage<Void> performReactiveNonBatchedMutation(PreparedStatementDetails statementDetails, Object id, JdbcValueBindings valueBindings, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session, String[] identifierColumnsNames) {
        if (statementDetails == null) {
            return CompletionStages.nullFuture();
        }
        TableMapping tableDetails = statementDetails.getMutatingTableDetails();
        if (inclusionChecker != null && !inclusionChecker.include(tableDetails)) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Skipping execution of secondary insert : %s", (Object)tableDetails.getTableName());
            }
            return CompletionStages.voidFuture();
        }
        if (id != null) {
            if (!1.$assertionsDisabled && tableDetails.isIdentifierTable()) {
                throw new AssertionError((Object)"Unsupported identifier table with generated id");
            }
            ((EntityTableMapping)tableDetails).getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> valueBindings.bindValue(jdbcValue, tableDetails.getTableName(), columnMapping.getColumnName(), ParameterUsage.SET), session);
        }
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
            valueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        Dialect dialect = session.getJdbcServices().getDialect();
        ReactiveConnection reactiveConnection = ((ReactiveConnectionSupplier)session).getReactiveConnection();
        String sqlString = statementDetails.getSqlString();
        if (identifierColumnsNames != null) {
            sqlString = ReactiveMutationExecutor.createInsert(statementDetails.getSqlString(), identifierColumnsNames[0], dialect);
        }
        return reactiveConnection.update(sqlString, params).thenCompose(affectedRowCount -> {
            if (affectedRowCount == 0 && tableDetails.isOptional()) {
                return CompletionStages.voidFuture();
            }
            ResultsCheckerUtil.checkResults(session, statementDetails, resultChecker, affectedRowCount, -1);
            return CompletionStages.voidFuture();
        }).whenComplete((o, throwable) -> {
            if (statementDetails.getStatement() != null) {
                statementDetails.releaseStatement(session);
            }
            valueBindings.afterStatement(tableDetails);
        });
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

