/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.jdbc.mutation.internal;

import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import java.util.concurrent.CompletionStage;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementGroup;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorStandard;
import org.hibernate.engine.jdbc.mutation.spi.BatchKeyAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.reactive.adaptor.impl.PrepareStatementDetailsAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.generator.values.ReactiveGeneratedValuesMutationDelegate;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.EntityMutationOperationGroup;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;

public class ReactiveMutationExecutorStandard
extends MutationExecutorStandard
implements ReactiveMutationExecutor {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final GeneratedValuesMutationDelegate generatedValuesDelegate;
    private final MutationOperationGroup mutationOperationGroup;

    public ReactiveMutationExecutorStandard(MutationOperationGroup mutationOperationGroup, BatchKeyAccess batchKeySupplier, int batchSize, SharedSessionContractImplementor session) {
        super(mutationOperationGroup, batchKeySupplier, batchSize, session);
        this.generatedValuesDelegate = mutationOperationGroup.asEntityMutationOperationGroup() != null ? mutationOperationGroup.asEntityMutationOperationGroup().getMutationDelegate() : null;
        this.mutationOperationGroup = mutationOperationGroup;
    }

    private ReactiveConnection connection(SharedSessionContractImplementor session) {
        return ((ReactiveConnectionSupplier)session).getReactiveConnection();
    }

    @Override
    public CompletionStage<Void> performReactiveBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        return ReactiveMutationExecutor.super.performReactiveBatchedOperations(valuesAnalysis, inclusionChecker, resultChecker, session);
    }

    protected GeneratedValues performNonBatchedOperations(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("performReactiveNonBatchedOperations");
    }

    protected void performSelfExecutingOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("performReactiveSelfExecutingOperations");
    }

    protected void performBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker) {
        throw LOG.nonReactiveMethodCall("performReactiveBatchedOperations");
    }

    @Override
    public CompletionStage<GeneratedValues> performReactiveNonBatchedOperations(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session, boolean isIndentityInsert, String[] identifiersColumnsNames) {
        if (this.getNonBatchedStatementGroup() == null || this.getNonBatchedStatementGroup().getNumberOfStatements() <= 0) {
            return CompletionStages.nullFuture();
        }
        PreparedStatementGroup nonBatchedStatementGroup = this.getNonBatchedStatementGroup();
        if (this.generatedValuesDelegate != null) {
            EntityMutationOperationGroup entityGroup = this.mutationOperationGroup.asEntityMutationOperationGroup();
            EntityMutationTarget entityTarget = entityGroup.getMutationTarget();
            PreparedStatementDetails details = nonBatchedStatementGroup.getPreparedStatementDetails(entityTarget.getIdentifierTableName());
            return ((ReactiveGeneratedValuesMutationDelegate)this.generatedValuesDelegate).reactivePerformMutation(details, this.getJdbcValueBindings(), modelReference, session).thenCompose(generatedValues -> {
                Object id = entityGroup.getMutationType() == MutationType.INSERT && details.getMutatingTableDetails().isIdentifierTable() ? generatedValues.getGeneratedValue((ModelPart)entityTarget.getTargetPart().getIdentifierMapping()) : null;
                OperationsForEach forEach = new OperationsForEach(id, inclusionChecker, resultChecker, session, this.getJdbcValueBindings(), true);
                nonBatchedStatementGroup.forEachStatement(forEach::add);
                return forEach.buildLoop().thenApply(v -> generatedValues);
            });
        }
        OperationsForEach forEach = new OperationsForEach(null, inclusionChecker, resultChecker, session, this.getJdbcValueBindings(), false);
        nonBatchedStatementGroup.forEachStatement(forEach::add);
        return forEach.buildLoop().thenCompose(CompletionStages::nullFuture);
    }

    @Override
    public CompletionStage<Void> performReactiveNonBatchedMutation(PreparedStatementDetails statementDetails, Object id, JdbcValueBindings valueBindings, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session, String[] identifierColumnsNames) {
        if (statementDetails == null) {
            return CompletionStages.voidFuture();
        }
        TableMapping tableDetails = statementDetails.getMutatingTableDetails();
        if (inclusionChecker != null && !inclusionChecker.include(tableDetails)) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Skipping execution of secondary insert : %s", (Object)tableDetails.getTableName());
            }
            return CompletionStages.voidFuture();
        }
        if (id != null) {
            assert (!tableDetails.isIdentifierTable()) : "Unsupported identifier table with generated id";
            ((EntityTableMapping)tableDetails).getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> valueBindings.bindValue(jdbcValue, tableDetails.getTableName(), columnMapping.getColumnName(), ParameterUsage.SET), session);
        }
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
            valueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        return this.connection(session).update(statementDetails.getSqlString(), params).thenCompose(affectedRowCount -> ReactiveMutationExecutorStandard.checkResult(session, statementDetails, resultChecker, tableDetails, affectedRowCount)).whenComplete((unused, throwable) -> {
            if (statementDetails.getStatement() != null) {
                statementDetails.releaseStatement(session);
            }
            valueBindings.afterStatement(tableDetails);
        });
    }

    private static CompletionStage<Void> checkResult(SharedSessionContractImplementor session, PreparedStatementDetails statementDetails, OperationResultChecker resultChecker, TableMapping tableDetails, Integer affectedRowCount) {
        if (affectedRowCount == 0 && tableDetails.isOptional()) {
            return CompletionStages.voidFuture();
        }
        try {
            ModelMutationHelper.checkResults((OperationResultChecker)resultChecker, (PreparedStatementDetails)statementDetails, (int)affectedRowCount, (int)-1);
            return CompletionStages.voidFuture();
        }
        catch (SQLException e) {
            JDBCException exception = session.getJdbcServices().getSqlExceptionHelper().convert(e, String.format("Unable to execute mutation PreparedStatement against table `%s`", tableDetails.getTableName()), statementDetails.getSqlString());
            return CompletionStages.failedFuture((Throwable)exception);
        }
    }

    public void release() {
    }

    private class OperationsForEach {
        private final Object id;
        private final TableInclusionChecker inclusionChecker;
        private final OperationResultChecker resultChecker;
        private final SharedSessionContractImplementor session;
        private final boolean requiresCheck;
        private final JdbcValueBindings jdbcValueBindings;
        private CompletionStage<Void> loop = CompletionStages.voidFuture();

        public OperationsForEach(Object id, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, boolean requiresCheck) {
            this.id = id;
            this.inclusionChecker = inclusionChecker;
            this.resultChecker = resultChecker;
            this.session = session;
            this.jdbcValueBindings = jdbcValueBindings;
            this.requiresCheck = requiresCheck;
        }

        public void add(String tableName, PreparedStatementDetails statementDetails) {
            this.loop = this.requiresCheck ? this.loop.thenCompose(v -> !statementDetails.getMutatingTableDetails().isIdentifierTable() ? ReactiveMutationExecutorStandard.this.performReactiveNonBatchedMutation(statementDetails, this.id, this.jdbcValueBindings, this.inclusionChecker, this.resultChecker, this.session, null) : CompletionStages.voidFuture()) : this.loop.thenCompose(v -> ReactiveMutationExecutorStandard.this.performReactiveNonBatchedMutation(statementDetails, null, this.jdbcValueBindings, this.inclusionChecker, this.resultChecker, this.session, null));
        }

        public CompletionStage<Void> buildLoop() {
            return this.loop;
        }
    }
}

