/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.Collections;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEntityEvent;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.PersistContext;
import org.hibernate.internal.util.EntityPrinter;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.ReactiveActionQueue;
import org.hibernate.reactive.engine.impl.Cascade;
import org.hibernate.reactive.engine.impl.CascadingActions;
import org.hibernate.reactive.engine.impl.QueuedOperationCollectionAction;
import org.hibernate.reactive.engine.impl.ReactiveCollectionRecreateAction;
import org.hibernate.reactive.engine.impl.ReactiveCollectionRemoveAction;
import org.hibernate.reactive.engine.impl.ReactiveCollectionUpdateAction;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;

public abstract class AbstractReactiveFlushingEventListener {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    protected CompletionStage<Void> performExecutions(EventSource session) {
        LOG.trace("Executing flush");
        session.getJdbcCoordinator().flushBeginning();
        session.getPersistenceContext().setFlushing(true);
        ReactiveActionQueue actionQueue = this.actionQueue(session);
        actionQueue.prepareActions();
        return actionQueue.executeActions().whenComplete((v, x) -> {
            session.getPersistenceContext().setFlushing(false);
            session.getJdbcCoordinator().flushEnding();
        });
    }

    private ReactiveActionQueue actionQueue(EventSource session) {
        return ((ReactiveSession)session.unwrap(ReactiveSession.class)).getReactiveActionQueue();
    }

    protected CompletionStage<Void> flushEverythingToExecutions(FlushEvent event) throws HibernateException {
        LOG.trace("Flushing session");
        EventSource session = event.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        return this.preFlush(session, persistenceContext).thenRun(() -> this.flushEverythingToExecutions(event, persistenceContext, session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushEverythingToExecutions(FlushEvent event, PersistenceContext persistenceContext, EventSource session) {
        persistenceContext.setFlushing(true);
        try {
            int entityCount = this.flushEntities(event, persistenceContext);
            int collectionCount = this.flushCollections(session, persistenceContext);
            event.setNumberOfEntitiesProcessed(entityCount);
            event.setNumberOfCollectionsProcessed(collectionCount);
        }
        finally {
            persistenceContext.setFlushing(false);
        }
        this.logFlushResults(event);
    }

    protected CompletionStage<Void> preFlush(EventSource session, PersistenceContext persistenceContext) {
        session.getInterceptor().preFlush(persistenceContext.managedEntitiesIterator());
        return this.prepareEntityFlushes(session, persistenceContext).thenAccept(v -> this.prepareCollectionFlushes(persistenceContext));
    }

    protected void logFlushResults(FlushEvent event) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        EventSource session = event.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        LOG.debugf("Flushed: %s insertions, %s updates, %s deletions to %s objects", new Object[]{session.getActionQueue().numberOfInsertions(), session.getActionQueue().numberOfUpdates(), session.getActionQueue().numberOfDeletions(), persistenceContext.getNumberOfManagedEntities()});
        LOG.debugf("Flushed: %s (re)creations, %s updates, %s removals to %s collections", new Object[]{session.getActionQueue().numberOfCollectionCreations(), session.getActionQueue().numberOfCollectionUpdates(), session.getActionQueue().numberOfCollectionRemovals(), persistenceContext.getCollectionEntriesSize()});
        new EntityPrinter(session.getFactory()).toString(persistenceContext.getEntityHoldersByKey().entrySet());
    }

    private CompletionStage<Void> prepareEntityFlushes(EventSource session, PersistenceContext persistenceContext) throws HibernateException {
        LOG.debug("Processing flush-time cascades");
        PersistContext context = PersistContext.create();
        Map.Entry[] entries = persistenceContext.reentrantSafeEntityEntries();
        return CompletionStages.loop(entries, index -> AbstractReactiveFlushingEventListener.flushable((EntityEntry)entries[index].getValue()), index -> this.cascadeOnFlush(session, ((EntityEntry)entries[index].getValue()).getPersister(), entries[index].getKey(), context)).thenCompose(v -> CompletionStages.loop(entries, index -> AbstractReactiveFlushingEventListener.flushable((EntityEntry)entries[index].getValue()), index -> Cascade.cascade(CascadingActions.CHECK_ON_FLUSH, CascadePoint.BEFORE_FLUSH, session, ((EntityEntry)entries[index].getValue()).getPersister(), entries[index].getKey(), null)));
    }

    private CompletionStage<Void> cascadeOnFlush(EventSource session, EntityPersister persister, Object object, PersistContext anything) throws HibernateException {
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        persistenceContext.incrementCascadeLevel();
        return Cascade.cascade(CascadingActions.PERSIST_ON_FLUSH, CascadePoint.BEFORE_FLUSH, session, persister, object, anything).whenComplete((unused, throwable) -> persistenceContext.decrementCascadeLevel());
    }

    private static boolean flushable(EntityEntry entry) {
        Status status = entry.getStatus();
        return status == Status.MANAGED || status == Status.SAVING || status == Status.READ_ONLY;
    }

    private void prepareCollectionFlushes(PersistenceContext persistenceContext) throws HibernateException {
        LOG.debug("Dirty checking collections");
        persistenceContext.forEachCollectionEntry((pc, ce) -> ce.preFlush(pc), true);
    }

    private int flushEntities(FlushEvent event, PersistenceContext persistenceContext) throws HibernateException {
        LOG.trace("Flushing entities and processing referenced collections");
        EventSource source = event.getSession();
        Iterable flushListeners = source.getFactory().getFastSessionServices().eventListenerGroup_FLUSH_ENTITY.listeners();
        Map.Entry[] entityEntries = persistenceContext.reentrantSafeEntityEntries();
        int count = entityEntries.length;
        for (Map.Entry me : entityEntries) {
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.getStatus();
            if (status == Status.LOADING || status == Status.GONE) continue;
            FlushEntityEvent entityEvent = new FlushEntityEvent(source, me.getKey(), entry);
            for (FlushEntityEventListener listener : flushListeners) {
                listener.onFlushEntity(entityEvent);
            }
        }
        this.actionQueue(source).sortActions();
        return count;
    }

    private int flushCollections(EventSource session, PersistenceContext persistenceContext) throws HibernateException {
        LOG.trace("Processing unreferenced collections");
        int count = persistenceContext.getCollectionEntriesSize();
        persistenceContext.forEachCollectionEntry((persistentCollection, collectionEntry) -> {
            if (!collectionEntry.isReached() && !collectionEntry.isIgnore()) {
                Collections.processUnreachableCollection((PersistentCollection)persistentCollection, (SessionImplementor)session);
            }
        }, true);
        LOG.trace("Scheduling collection removes/(re)creates/updates");
        ReactiveActionQueue actionQueue = ((ReactiveSession)session.unwrap(ReactiveSession.class)).getReactiveActionQueue();
        Interceptor interceptor = session.getInterceptor();
        persistenceContext.forEachCollectionEntry((coll, ce) -> {
            if (ce.isDorecreate()) {
                interceptor.onCollectionRecreate(coll, ce.getCurrentKey());
                actionQueue.addAction(new ReactiveCollectionRecreateAction((PersistentCollection)coll, ce.getCurrentPersister(), ce.getCurrentKey(), session));
            }
            if (ce.isDoremove()) {
                interceptor.onCollectionRemove(coll, ce.getLoadedKey());
                actionQueue.addAction(new ReactiveCollectionRemoveAction((PersistentCollection)coll, ce.getLoadedPersister(), ce.getLoadedKey(), ce.isSnapshotEmpty(coll), session));
            }
            if (ce.isDoupdate()) {
                interceptor.onCollectionUpdate(coll, ce.getLoadedKey());
                actionQueue.addAction(new ReactiveCollectionUpdateAction((PersistentCollection)coll, ce.getLoadedPersister(), ce.getLoadedKey(), ce.isSnapshotEmpty(coll), session));
            }
            if (!coll.wasInitialized() && coll.hasQueuedOperations()) {
                actionQueue.addAction(new QueuedOperationCollectionAction((PersistentCollection)coll, ce.getLoadedPersister(), ce.getLoadedKey(), session));
            }
        }, true);
        actionQueue.sortCollectionActions();
        return count;
    }

    protected void postFlush(SessionImplementor session) throws HibernateException {
        LOG.trace("Post flush");
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        persistenceContext.clearCollectionsByKey();
        persistenceContext.getBatchFetchQueue().clear();
        persistenceContext.forEachCollectionEntry((persistentCollection, collectionEntry) -> {
            collectionEntry.postFlush(persistentCollection);
            if (collectionEntry.getLoadedPersister() == null) {
                persistentCollection.unsetSession((SharedSessionContractImplementor)session);
                persistenceContext.removeCollectionEntry(persistentCollection);
            } else {
                CollectionKey collectionKey = new CollectionKey(collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey());
                persistenceContext.addCollectionByKey(collectionKey, persistentCollection);
            }
        }, true);
    }

    protected void postPostFlush(SessionImplementor session) {
        session.getInterceptor().postFlush(session.getPersistenceContextInternal().managedEntitiesIterator());
    }
}

