/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityEntryExtraState;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.id.Assigned;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.engine.ReactiveActionQueue;
import org.hibernate.reactive.engine.impl.Cascade;
import org.hibernate.reactive.engine.impl.CascadingAction;
import org.hibernate.reactive.engine.impl.ReactiveEntityIdentityInsertAction;
import org.hibernate.reactive.engine.impl.ReactiveEntityRegularInsertAction;
import org.hibernate.reactive.id.ReactiveIdentifierGenerator;
import org.hibernate.reactive.id.impl.IdentifierGeneration;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

abstract class AbstractReactiveSaveEventListener<C>
implements CallbackRegistryConsumer {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private CallbackRegistry callbackRegistry;

    AbstractReactiveSaveEventListener() {
    }

    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    protected CompletionStage<Void> reactiveSaveWithRequestedId(Object entity, Object requestedId, String entityName, C context, EventSource source) {
        this.callbackRegistry.preCreate(entity);
        return this.reactivePerformSave(entity, requestedId, source.getEntityPersister(entityName, entity), false, context, source, true);
    }

    protected CompletionStage<Void> reactiveSaveWithGeneratedId(Object entity, String entityName, C context, EventSource source, boolean requiresImmediateIdAccess) {
        Object generatedId;
        EntityPersister persister = source.getEntityPersister(entityName, entity);
        Generator generator = persister.getGenerator();
        boolean generatedOnExecution = generator.generatedOnExecution(entity, (SharedSessionContractImplementor)source);
        if (generatedOnExecution) {
            generatedId = null;
        } else if (generator instanceof Assigned) {
            generatedId = null;
        } else {
            if (generator instanceof ReactiveIdentifierGenerator) {
                return ((ReactiveIdentifierGenerator)generator).generate((ReactiveConnectionSupplier)source, entity).thenApply(id -> IdentifierGeneration.castToIdentifierType(id, persister)).thenCompose(gid -> this.performSaveWithId(entity, context, source, persister, generator, gid, requiresImmediateIdAccess, false));
            }
            generatedId = ((BeforeExecutionGenerator)generator).generate((SharedSessionContractImplementor)source, entity, null, EventType.INSERT);
        }
        Object id2 = IdentifierGeneration.castToIdentifierType(generatedId, persister);
        return this.reactivePerformSave(entity, id2, persister, generatedOnExecution, context, source, requiresImmediateIdAccess);
    }

    private CompletionStage<Void> performSaveWithId(Object entity, C context, EventSource source, EntityPersister persister, Generator generator, Object generatedId, boolean requiresImmediateIdAccess, boolean generatedOnExecution) {
        if (generatedId == null) {
            throw new IdentifierGenerationException("null id generated for: " + entity.getClass());
        }
        if (generatedId == IdentifierGeneratorHelper.SHORT_CIRCUIT_INDICATOR) {
            source.getIdentifier(entity);
            return CompletionStages.voidFuture();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Generated identifier: %s, using strategy: %s", persister.getIdentifierType().toLoggableString(generatedId, source.getFactory()), generator.getClass().getName());
        }
        boolean delayIdentityInserts = !source.isTransactionInProgress() && !requiresImmediateIdAccess && generatedOnExecution;
        return this.reactivePerformSave(entity, generatedId, persister, false, context, source, delayIdentityInserts);
    }

    protected CompletionStage<Void> reactivePerformSave(Object entity, Object id, EntityPersister persister, boolean useIdentityColumn, C context, EventSource source, boolean requiresImmediateIdAccess) {
        this.callbackRegistry.preCreate(entity);
        ManagedTypeHelper.processIfSelfDirtinessTracker((Object)entity, SelfDirtinessTracker::$$_hibernate_clearDirtyAttributes);
        ManagedTypeHelper.processIfManagedEntity((Object)entity, managedEntity -> managedEntity.$$_hibernate_setUseTracker(true));
        if (persister.getGenerator() instanceof Assigned && (id = persister.getIdentifier(entity, (SharedSessionContractImplementor)source)) == null) {
            throw new IdentifierGenerationException("Identifier of entity '" + persister.getEntityName() + "' must be manually assigned before calling 'persist()'");
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Saving {0}", MessageHelper.infoString((EntityPersister)persister, (Object)id, (SessionFactoryImplementor)source.getFactory()));
        }
        return this.entityKey(entity, id, persister, useIdentityColumn, source).thenCompose(key -> this.reactivePerformSaveOrReplicate(entity, (EntityKey)key, persister, useIdentityColumn, context, source, requiresImmediateIdAccess));
    }

    private CompletionStage<EntityKey> entityKey(Object entity, Object id, EntityPersister persister, boolean useIdentityColumn, EventSource source) {
        return useIdentityColumn ? CompletionStages.nullFuture() : this.generateEntityKey(id, persister, source).thenApply(generatedKey -> {
            persister.setIdentifier(entity, id, (SharedSessionContractImplementor)source);
            return generatedKey;
        });
    }

    private CompletionStage<EntityKey> generateEntityKey(Object id, EntityPersister persister, EventSource source) {
        EntityKey key = source.generateEntityKey(id, persister);
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        Object old = persistenceContext.getEntity(key);
        if (old != null) {
            if (persistenceContext.getEntry(old).getStatus() == Status.DELETED) {
                return ((ReactiveSession)source.unwrap(ReactiveSession.class)).reactiveForceFlush(persistenceContext.getEntry(old)).thenApply(v -> key);
            }
            return CompletionStages.failedFuture((Throwable)new NonUniqueObjectException(id, persister.getEntityName()));
        }
        if (persistenceContext.containsDeletedUnloadedEntityKey(key)) {
            return ((ReactiveSession)source.unwrap(ReactiveSession.class)).reactiveForceFlush(persistenceContext.getEntry(old)).thenApply(v -> key);
        }
        return CompletionStages.completedFuture(key);
    }

    protected CompletionStage<Void> reactivePerformSaveOrReplicate(Object entity, EntityKey key, EntityPersister persister, boolean useIdentityColumn, C context, EventSource source, boolean requiresImmediateIdAccess) {
        Object id = key == null ? null : key.getIdentifier();
        Generator generator = persister.getGenerator();
        boolean shouldDelayIdentityInserts = !source.isTransactionInProgress() && !requiresImmediateIdAccess && generator.generatedOnExecution(entity, (SharedSessionContractImplementor)source);
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry original = persistenceContext.addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false);
        if (original.getLoadedState() != null) {
            persistenceContext.getEntityHolder(key).setEntityEntry(original);
        }
        return this.cascadeBeforeSave(source, persister, entity, context).thenCompose(v -> this.addInsertAction(this.cloneAndSubstituteValues(entity, persister, context, source, id), id, entity, persister, useIdentityColumn, source, shouldDelayIdentityInserts)).thenCompose(insert -> this.cascadeAfterSave(source, persister, entity, context).thenAccept(unused -> {
            EntityEntryExtraState extraState;
            Object finalId = AbstractReactiveSaveEventListener.handleGeneratedId(useIdentityColumn, id, insert);
            EntityEntry newEntry = persistenceContext.getEntry(entity);
            if (newEntry != original && (extraState = newEntry.getExtraState(EntityEntryExtraState.class)) == null) {
                newEntry.addExtraState(original.getExtraState(EntityEntryExtraState.class));
            }
        }));
    }

    private static Object handleGeneratedId(boolean useIdentityColumn, Object id, AbstractEntityInsertAction insert) {
        if (useIdentityColumn && insert.isEarlyInsert()) {
            if (insert instanceof EntityIdentityInsertAction) {
                Object generatedId = ((EntityIdentityInsertAction)insert).getGeneratedId();
                insert.handleNaturalIdPostSaveNotifications(generatedId);
                return generatedId;
            }
            throw new IllegalStateException("Insert should be using an identity column, but action is of unexpected type: " + insert.getClass().getName());
        }
        return id;
    }

    private Object[] cloneAndSubstituteValues(Object entity, EntityPersister persister, C context, EventSource source, Object id) {
        Object[] values = persister.getPropertyValuesToInsert(entity, this.getMergeMap(context), (SharedSessionContractImplementor)source);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.substituteValuesIfNecessary(entity, id, values, persister, (SessionImplementor)source);
        if (persister.hasCollections()) {
            boolean bl = substitute = this.visitCollectionsBeforeSave(entity, id, values, types, source) || substitute;
        }
        if (substitute) {
            persister.setValues(entity, values);
        }
        TypeHelper.deepCopy((Object[])values, (Type[])types, (boolean[])persister.getPropertyUpdateability(), (Object[])values, (SharedSessionContractImplementor)source);
        return values;
    }

    protected Map<Object, Object> getMergeMap(C anything) {
        return null;
    }

    private CompletionStage<AbstractEntityInsertAction> addInsertAction(Object[] values, Object id, Object entity, EntityPersister persister, boolean useIdentityColumn, EventSource source, boolean shouldDelayIdentityInserts) {
        ReactiveActionQueue actionQueue = ((ReactiveSession)source.unwrap(ReactiveSession.class)).getReactiveActionQueue();
        if (useIdentityColumn) {
            ReactiveEntityIdentityInsertAction insert = new ReactiveEntityIdentityInsertAction(values, entity, persister, false, source, shouldDelayIdentityInserts);
            return actionQueue.addAction(insert).thenApply(v -> insert);
        }
        ReactiveEntityRegularInsertAction insert = new ReactiveEntityRegularInsertAction(id, values, entity, Versioning.getVersion((Object[])values, (EntityPersister)persister), persister, false, source);
        return actionQueue.addAction(insert).thenApply(v -> insert);
    }

    protected CompletionStage<Void> cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, C context) {
        return Cascade.cascade(this.getCascadeReactiveAction(), CascadePoint.BEFORE_INSERT_AFTER_DELETE, source, persister, entity, context);
    }

    protected CompletionStage<Void> cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, C context) {
        return Cascade.cascade(this.getCascadeReactiveAction(), CascadePoint.AFTER_INSERT_BEFORE_DELETE, source, persister, entity, context);
    }

    protected abstract CascadingAction<C> getCascadeReactiveAction();

    protected boolean substituteValuesIfNecessary(Object entity, Object id, Object[] values, EntityPersister persister, SessionImplementor source) {
        boolean substitute = source.getInterceptor().onSave(entity, id, values, persister.getPropertyNames(), persister.getPropertyTypes());
        if (persister.isVersioned()) {
            substitute = Versioning.seedVersion((Object)entity, (Object[])values, (EntityPersister)persister, (SharedSessionContractImplementor)source) || substitute;
        }
        return substitute;
    }

    protected boolean visitCollectionsBeforeSave(Object entity, Object id, Object[] values, Type[] types, EventSource source) {
        WrapVisitor visitor = new WrapVisitor(entity, id, source);
        visitor.processEntityPropertyValues(values, types);
        return visitor.isSubstitutionRequired();
    }
}

