/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.NaturalIdResolutions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.internal.AbstractLockUpgradeEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.ResolveNaturalIdEvent;
import org.hibernate.event.spi.ResolveNaturalIdEventListener;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.event.ReactiveResolveNaturalIdEventListener;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class DefaultReactiveResolveNaturalIdEventListener
extends AbstractLockUpgradeEventListener
implements ReactiveResolveNaturalIdEventListener,
ResolveNaturalIdEventListener {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public void onResolveNaturalId(ResolveNaturalIdEvent event) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Void> onReactiveResolveNaturalId(ResolveNaturalIdEvent event) throws HibernateException {
        return this.resolveNaturalId(event).thenAccept(arg_0 -> ((ResolveNaturalIdEvent)event).setEntityId(arg_0));
    }

    protected CompletionStage<Object> resolveNaturalId(ResolveNaturalIdEvent event) {
        Object entityId;
        EntityPersister persister = event.getEntityPersister();
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Attempting to resolve: {0}#{1}", MessageHelper.infoString((EntityPersister)persister), event.getNaturalIdValues());
        }
        if ((entityId = this.resolveFromCache(event)) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Resolved object in cache: {0}#{1}", MessageHelper.infoString((EntityPersister)persister), event.getNaturalIdValues());
            }
            return CompletionStages.completedFuture(entityId);
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Object not resolved in any cache: {0}#{1}", MessageHelper.infoString((EntityPersister)persister), event.getNaturalIdValues());
        }
        return this.loadFromDatasource(event);
    }

    protected Object resolveFromCache(ResolveNaturalIdEvent event) {
        return DefaultReactiveResolveNaturalIdEventListener.getNaturalIdResolutions(event).findCachedIdByNaturalId((Object)event.getOrderedNaturalIdValues(), (EntityMappingType)event.getEntityPersister());
    }

    protected CompletionStage<Object> loadFromDatasource(ResolveNaturalIdEvent event) {
        EventSource session = event.getSession();
        EntityPersister entityPersister = event.getEntityPersister();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        boolean statisticsEnabled = statistics.isStatisticsEnabled();
        long startTime = statisticsEnabled ? System.nanoTime() : 0L;
        return ((ReactiveEntityPersister)entityPersister).reactiveLoadEntityIdByNaturalId(event.getOrderedNaturalIdValues(), event.getLockOptions(), (SharedSessionContractImplementor)session).thenApply(pk -> {
            if (statisticsEnabled) {
                long milliseconds = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
                statistics.naturalIdQueryExecuted(entityPersister.getRootEntityName(), milliseconds);
            }
            if (pk != null) {
                DefaultReactiveResolveNaturalIdEventListener.getNaturalIdResolutions(event).cacheResolutionFromLoad(pk, (Object)event.getOrderedNaturalIdValues(), (EntityMappingType)entityPersister);
            }
            return pk;
        });
    }

    private static NaturalIdResolutions getNaturalIdResolutions(ResolveNaturalIdEvent event) {
        return event.getSession().getPersistenceContextInternal().getNaturalIdResolutions();
    }
}

