/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.impl;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.enhanced.ImplicitDatabaseObjectNamingStrategy;
import org.hibernate.id.enhanced.StandardNamingStrategy;
import org.hibernate.internal.log.IncubationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.reactive.id.impl.BlockingIdentifierGenerator;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class ReactiveSequenceIdentifierGenerator
extends BlockingIdentifierGenerator
implements IdentifierGenerator {
    public static final Object[] NO_PARAMS = new Object[0];
    private Dialect dialect;
    private QualifiedName qualifiedName;
    private String sql;
    private int increment;

    @Override
    protected int getBlockSize() {
        return this.increment;
    }

    @Override
    protected CompletionStage<Long> nextHiValue(ReactiveConnectionSupplier session) {
        return session.getReactiveConnection().selectIdentifier(this.sql, NO_PARAMS, Long.class);
    }

    public void configure(Type type, Properties properties, ServiceRegistry serviceRegistry) {
        JdbcEnvironment jdbcEnvironment = (JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class);
        this.dialect = jdbcEnvironment.getDialect();
        this.qualifiedName = this.determineSequenceName(properties, this.dialect, jdbcEnvironment, serviceRegistry);
        this.increment = this.determineIncrementForSequenceEmulation(properties);
    }

    protected QualifiedName determineSequenceName(Properties params, Dialect dialect, JdbcEnvironment jdbcEnv, ServiceRegistry serviceRegistry) {
        Identifier catalog = jdbcEnv.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString((String)"catalog", (Map)params));
        Identifier schema = jdbcEnv.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString((String)"schema", (Map)params));
        String sequenceName = ConfigurationHelper.getString((String)"sequence_name", (Map)params, () -> ConfigurationHelper.getString((String)"sequence", (Map)params));
        if (StringHelper.isNotEmpty((String)sequenceName)) {
            if (sequenceName.contains(".")) {
                return QualifiedNameParser.INSTANCE.parse(sequenceName);
            }
            return new QualifiedNameParser.NameParts(catalog, schema, jdbcEnv.getIdentifierHelper().toIdentifier(sequenceName));
        }
        return this.determineImplicitName(catalog, schema, params, serviceRegistry);
    }

    private QualifiedName determineImplicitName(Identifier catalog, Identifier schema, Properties params, ServiceRegistry serviceRegistry) {
        StrategySelector strategySelector = (StrategySelector)serviceRegistry.getService(StrategySelector.class);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> {
            String localSetting = ConfigurationHelper.getString((String)"hibernate.id.db_structure_naming_strategy", (Map)params);
            if (localSetting != null) {
                IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.id.db_structure_naming_strategy");
            }
            return localSetting;
        };
        supplierArray[1] = () -> {
            ConfigurationService configurationService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
            String globalSetting = ConfigurationHelper.getString((String)"hibernate.id.db_structure_naming_strategy", (Map)configurationService.getSettings());
            if (globalSetting != null) {
                IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.id.db_structure_naming_strategy");
            }
            return globalSetting;
        };
        supplierArray[2] = StandardNamingStrategy.class::getName;
        String namingStrategySetting = (String)NullnessHelper.coalesceSuppliedValues((Supplier[])supplierArray);
        return ((ImplicitDatabaseObjectNamingStrategy)strategySelector.resolveStrategy(ImplicitDatabaseObjectNamingStrategy.class, (Object)namingStrategySetting)).determineSequenceName(catalog, schema, (Map)params, serviceRegistry);
    }

    public void initialize(SqlStringGenerationContext context) {
        String renderedSequenceName = context.format(this.qualifiedName);
        this.sql = this.dialect.getSequenceSupport().getSequenceNextValString(renderedSequenceName);
    }

    public Object generate(SharedSessionContractImplementor session, Object object) throws HibernateException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public QualifiedName getSequenceName() {
        return this.qualifiedName;
    }

    protected int determineIncrementForSequenceEmulation(Properties params) {
        return ConfigurationHelper.getInt((String)"increment_size", (Map)params, (int)50);
    }
}

