/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.insert;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.values.GeneratedValueBasicResultBuilder;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.internal.GeneratedValuesHelper;
import org.hibernate.generator.values.internal.TableUpdateReturningBuilder;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.AbstractReturningDelegate;
import org.hibernate.id.insert.TableInsertReturningBuilder;
import org.hibernate.jdbc.Expectation;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.generator.values.internal.ReactiveGeneratedValuesHelper;
import org.hibernate.reactive.id.insert.ReactiveAbstractReturningDelegate;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.builder.TableMutationBuilder;
import org.hibernate.type.descriptor.WrapperOptions;

public class ReactiveInsertReturningDelegate
extends AbstractReturningDelegate
implements ReactiveAbstractReturningDelegate {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final PostInsertIdentityPersister persister;
    private final MutatingTableReference tableReference;
    private final List<ColumnReference> generatedColumns;

    public ReactiveInsertReturningDelegate(EntityPersister persister, EventType timing) {
        this((PostInsertIdentityPersister)persister, timing, false);
    }

    public ReactiveInsertReturningDelegate(PostInsertIdentityPersister persister, Dialect dialect) {
        this(persister, EventType.INSERT, ReactiveInsertReturningDelegate.supportsArbitraryValues(dialect));
    }

    private static boolean supportsArbitraryValues(Dialect dialect) {
        return !(dialect instanceof MySQLDialect);
    }

    private ReactiveInsertReturningDelegate(PostInsertIdentityPersister persister, EventType timing, boolean supportsArbitraryValues) {
        super((EntityPersister)persister, timing, supportsArbitraryValues, persister.getFactory().getJdbcServices().getDialect().supportsInsertReturningRowId());
        this.persister = persister;
        this.tableReference = new MutatingTableReference((TableMapping)persister.getIdentifierTableMapping());
        List resultBuilders = this.jdbcValuesMappingProducer.getResultBuilders();
        this.generatedColumns = new ArrayList<ColumnReference>(resultBuilders.size());
        for (GeneratedValueBasicResultBuilder resultBuilder : resultBuilders) {
            this.generatedColumns.add(new ColumnReference((TableReference)this.tableReference, (SelectableMapping)GeneratedValuesHelper.getActualGeneratedModelPart((BasicValuedModelPart)resultBuilder.getModelPart())));
        }
    }

    public TableMutationBuilder<?> createTableMutationBuilder(Expectation expectation, SessionFactoryImplementor sessionFactory) {
        if (this.getTiming() == EventType.INSERT) {
            return new TableInsertReturningBuilder((EntityPersister)this.persister, this.tableReference, this.generatedColumns, sessionFactory);
        }
        return new TableUpdateReturningBuilder((EntityPersister)this.persister, this.tableReference, this.generatedColumns, sessionFactory);
    }

    public String prepareIdentifierGeneratingInsert(String insertSQL) {
        return this.dialect().getIdentityColumnSupport().appendIdentitySelectToInsert(((BasicEntityIdentifierMapping)this.persister.getRootEntityDescriptor().getIdentifierMapping()).getSelectionExpression(), insertSQL);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, SharedSessionContractImplementor session) {
        return session.getJdbcCoordinator().getMutationStatementPreparer().prepareStatement(sql, 2);
    }

    @Override
    public PostInsertIdentityPersister getPersister() {
        return this.persister;
    }

    public GeneratedValues performMutation(PreparedStatementDetails statementDetails, JdbcValueBindings valueBindings, Object entity, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("reactivePerformMutation");
    }

    @Override
    public CompletionStage<GeneratedValues> reactiveExecuteAndExtractReturning(String sql, Object[] params, SharedSessionContractImplementor session) {
        Class idType = this.getPersister().getIdentifierType().getReturnedClass();
        String identifierColumnName = this.getPersister().getIdentifierColumnNames()[0];
        return ((ReactiveConnectionSupplier)session).getReactiveConnection().insertAndSelectIdentifierAsResultSet(sql, params, idType, identifierColumnName).thenCompose(rs -> ReactiveGeneratedValuesHelper.getGeneratedValues(rs, (EntityPersister)this.getPersister(), this.getTiming(), (WrapperOptions)session)).thenApply(this::validateGeneratedIdentityId);
    }

    protected GeneratedValues executeAndExtractReturning(String sql, PreparedStatement preparedStatement, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("reactiveExecuteAndExtractReturning");
    }
}

