/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.reactive.loader.ast.spi.ReactiveCollectionBatchLoader;
import org.hibernate.sql.results.internal.ResultsHelper;

public abstract class ReactiveAbstractCollectionBatchLoader
implements ReactiveCollectionBatchLoader {
    private final int domainBatchSize;
    private final PluralAttributeMapping attributeMapping;
    private final LoadQueryInfluencers influencers;
    private final SessionFactoryImplementor sessionFactory;
    private final int keyJdbcCount;

    public ReactiveAbstractCollectionBatchLoader(int domainBatchSize, LoadQueryInfluencers influencers, PluralAttributeMapping attributeMapping, SessionFactoryImplementor sessionFactory) {
        this.domainBatchSize = domainBatchSize;
        this.attributeMapping = attributeMapping;
        this.keyJdbcCount = attributeMapping.getJdbcTypeCount();
        this.sessionFactory = sessionFactory;
        this.influencers = influencers;
    }

    public int getDomainBatchSize() {
        return this.domainBatchSize;
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.attributeMapping;
    }

    public LoadQueryInfluencers getInfluencers() {
        return this.influencers;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public int getKeyJdbcCount() {
        return this.keyJdbcCount;
    }

    protected void finishInitializingKey(Object key, SharedSessionContractImplementor session) {
        CollectionKey collectionKey;
        PersistenceContext persistenceContext;
        PersistentCollection collection;
        if (key == null) {
            return;
        }
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Finishing initializing batch-fetched collection : %s.%s", (Object)this.attributeMapping.getNavigableRole().getFullPath(), key);
        }
        if (!(collection = (persistenceContext = session.getPersistenceContext()).getCollection(collectionKey = new CollectionKey(this.getLoadable().getCollectionDescriptor(), key))).wasInitialized()) {
            CollectionEntry entry = persistenceContext.getCollectionEntry(collection);
            collection.initializeEmptyCollection(entry.getLoadedPersister());
            ResultsHelper.finalizeCollectionLoading((PersistenceContext)persistenceContext, (CollectionPersister)entry.getLoadedPersister(), (PersistentCollection)collection, (Object)collectionKey, (boolean)true);
        }
    }
}

