/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.reactive.loader.ast.spi.ReactiveMultiIdEntityLoader;

public abstract class ReactiveAbstractMultiIdEntityLoader<T>
implements ReactiveMultiIdEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    private EntityIdentifierMapping identifierMapping;

    public ReactiveAbstractMultiIdEntityLoader(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.sessionFactory = sessionFactory;
        this.identifierMapping = this.getLoadable().getIdentifierMapping();
    }

    protected EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public EntityIdentifierMapping getIdentifierMapping() {
        return this.identifierMapping;
    }

    public EntityMappingType getLoadable() {
        return this.getEntityDescriptor();
    }

    @Override
    public final <K> CompletionStage<List<T>> reactiveLoad(K[] ids, MultiIdLoadOptions loadOptions, EventSource session) {
        Objects.requireNonNull(ids);
        return loadOptions.isOrderReturnEnabled() ? this.performOrderedMultiLoad(ids, loadOptions, session) : this.performUnorderedMultiLoad(ids, loadOptions, session);
    }

    protected abstract <K> CompletionStage<List<T>> performOrderedMultiLoad(K[] var1, MultiIdLoadOptions var2, EventSource var3);

    protected abstract <K> CompletionStage<List<T>> performUnorderedMultiLoad(K[] var1, MultiIdLoadOptions var2, EventSource var3);
}

