/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.LockOptions;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.PluralAttributeMappingImpl;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.loader.ast.internal.ReactiveCollectionLoader;
import org.hibernate.reactive.metamodel.mapping.internal.ReactivePluralAttributeMapping;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;

public class ReactiveCollectionLoaderSingleKey
implements ReactiveCollectionLoader {
    private final PluralAttributeMapping attributeMapping;
    private final int keyJdbcCount;
    private final SelectStatement sqlAst;
    private final JdbcParametersList jdbcParameters;

    public ReactiveCollectionLoaderSingleKey(PluralAttributeMapping attributeMapping, LoadQueryInfluencers influencers, SessionFactoryImplementor sessionFactory) {
        ReactivePluralAttributeMapping reactivePluralAttributeMapping = new ReactivePluralAttributeMapping((PluralAttributeMappingImpl)attributeMapping);
        this.attributeMapping = reactivePluralAttributeMapping;
        this.keyJdbcCount = reactivePluralAttributeMapping.getKeyDescriptor().getJdbcTypeCount();
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder();
        this.sqlAst = LoaderSelectBuilder.createSelect((Loadable)reactivePluralAttributeMapping, null, (ModelPart)attributeMapping.getKeyDescriptor(), null, (int)1, (LoadQueryInfluencers)influencers, (LockOptions)LockOptions.NONE, arg_0 -> ((JdbcParametersList.Builder)jdbcParametersBuilder).add(arg_0), (SessionFactoryImplementor)sessionFactory);
        this.jdbcParameters = jdbcParametersBuilder.build();
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.getAttributeMapping();
    }

    public PluralAttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    public SelectStatement getSqlAst() {
        return this.sqlAst;
    }

    public JdbcParametersList getJdbcParameters() {
        return this.jdbcParameters;
    }

    @Override
    public CompletionStage<PersistentCollection<?>> reactiveLoad(Object key, SharedSessionContractImplementor session) {
        CollectionKey collectionKey = new CollectionKey(this.attributeMapping.getCollectionDescriptor(), key);
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.keyJdbcCount);
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(key, (Bindable)this.attributeMapping.getKeyDescriptor(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, this.sqlAst).translate((JdbcParameterBindings)jdbcParameterBindings, QueryOptions.NONE);
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler((BatchFetchQueue)session.getPersistenceContext().getBatchFetchQueue(), (SelectStatement)this.sqlAst, (JdbcParametersList)this.jdbcParameters, (JdbcParameterBindings)jdbcParameterBindings);
        return StandardReactiveSelectExecutor.INSTANCE.list(jdbcSelect, (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)new CollectionLoaderSingleKeyExecutionContext(session, collectionKey, subSelectFetchableKeysHandler), RowTransformerStandardImpl.instance(), ReactiveListResultsConsumer.UniqueSemantic.FILTER).thenApply(rs -> session.getPersistenceContext().getCollection(collectionKey));
    }

    private static class CollectionLoaderSingleKeyExecutionContext
    extends BaseExecutionContext {
        private final CollectionKey collectionKey;
        private final SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler;

        CollectionLoaderSingleKeyExecutionContext(SharedSessionContractImplementor session, CollectionKey collectionKey, SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler) {
            super(session);
            this.collectionKey = collectionKey;
            this.subSelectFetchableKeysHandler = subSelectFetchableKeysHandler;
        }

        public CollectionKey getCollectionKey() {
            return this.collectionKey;
        }

        public void registerLoadingEntityHolder(EntityHolder holder) {
            this.subSelectFetchableKeysHandler.addKey(holder);
        }
    }
}

