/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;

public class ReactiveMultiKeyLoadChunker<K> {
    private final int chunkSize;
    private final int keyColumnCount;
    private final Bindable bindable;
    private final JdbcParametersList jdbcParameters;
    private final SelectStatement sqlAst;
    private final JdbcOperationQuerySelect jdbcSelect;

    public ReactiveMultiKeyLoadChunker(int chunkSize, int keyColumnCount, Bindable bindable, JdbcParametersList jdbcParameters, SelectStatement sqlAst, JdbcOperationQuerySelect jdbcSelect) {
        this.chunkSize = chunkSize;
        this.keyColumnCount = keyColumnCount;
        this.bindable = bindable;
        this.jdbcParameters = jdbcParameters;
        this.sqlAst = sqlAst;
        this.jdbcSelect = jdbcSelect;
    }

    public CompletionStage<Void> processChunks(K[] keys, int nonNullElementCount, SqlExecutionContextCreator sqlExecutionContextCreator, KeyCollector<K> keyCollector, ChunkStartListener startListener, ChunkBoundaryListener boundaryListener, SharedSessionContractImplementor session) {
        int[] numberOfKeysLeft = new int[]{nonNullElementCount};
        int[] start = new int[]{0};
        if (numberOfKeysLeft[0] > 0) {
            return CompletionStages.whileLoop(() -> this.processChunk(keys, start[0], sqlExecutionContextCreator, keyCollector, startListener, boundaryListener, session).thenApply(unused -> {
                start[0] = start[0] + this.chunkSize;
                numberOfKeysLeft[0] = numberOfKeysLeft[0] - this.chunkSize;
                return numberOfKeysLeft[0] > 0;
            }));
        }
        return CompletionStages.voidFuture();
    }

    private CompletionStage<Void> processChunk(K[] keys, int startIndex, SqlExecutionContextCreator sqlExecutionContextCreator, KeyCollector<K> keyCollector, ChunkStartListener startListener, ChunkBoundaryListener boundaryListener, SharedSessionContractImplementor session) {
        startListener.chunkStartNotification(startIndex);
        int parameterCount = this.chunkSize * this.keyColumnCount;
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(parameterCount);
        int nonNullCounter = 0;
        int bindCount = 0;
        for (int i = 0; i < this.chunkSize; ++i) {
            int keyPosition = i + startIndex;
            Object value = keyPosition >= keys.length ? null : (Object)keys[keyPosition];
            keyCollector.collect(value, i, keyPosition);
            if (value != null) {
                ++nonNullCounter;
            }
            bindCount += jdbcParameterBindings.registerParametersForEachJdbcValue(value, bindCount, this.bindable, this.jdbcParameters, session);
        }
        assert (bindCount == this.jdbcParameters.size());
        if (nonNullCounter == 0) {
            return CompletionStages.voidFuture();
        }
        int finalNonNullCounter = nonNullCounter;
        return StandardReactiveSelectExecutor.INSTANCE.list(this.jdbcSelect, (JdbcParameterBindings)jdbcParameterBindings, sqlExecutionContextCreator.createContext((JdbcParameterBindings)jdbcParameterBindings, session), RowTransformerStandardImpl.instance(), ReactiveListResultsConsumer.UniqueSemantic.FILTER).thenAccept(objects -> boundaryListener.chunkBoundaryNotification(startIndex, finalNonNullCounter));
    }

    @FunctionalInterface
    static interface ChunkBoundaryListener {
        public void chunkBoundaryNotification(int var1, int var2);
    }

    @FunctionalInterface
    static interface ChunkStartListener {
        public void chunkStartNotification(int var1);
    }

    @FunctionalInterface
    static interface KeyCollector<K> {
        public void collect(K var1, int var2, int var3);
    }

    @FunctionalInterface
    static interface SqlExecutionContextCreator {
        public ExecutionContext createContext(JdbcParameterBindings var1, SharedSessionContractImplementor var2);
    }
}

