/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import jakarta.persistence.Parameter;
import java.util.concurrent.CompletionStage;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.reactive.loader.ast.spi.ReactiveSingleIdEntityLoader;
import org.hibernate.reactive.query.ReactiveSelectionQuery;
import org.hibernate.reactive.util.impl.CompletionStages;

public class ReactiveSingleIdEntityLoaderProvidedQueryImpl<T>
implements ReactiveSingleIdEntityLoader<T> {
    private static final CompletionStage<Object[]> EMPTY_ARRAY_STAGE = CompletionStages.completedFuture(ArrayHelper.EMPTY_OBJECT_ARRAY);
    private final EntityMappingType entityDescriptor;
    private final NamedQueryMemento namedQueryMemento;

    public ReactiveSingleIdEntityLoaderProvidedQueryImpl(EntityMappingType entityDescriptor, NamedQueryMemento namedQueryMemento) {
        this.entityDescriptor = entityDescriptor;
        this.namedQueryMemento = namedQueryMemento;
    }

    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    public CompletionStage<T> load(Object pkValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        QueryImplementor query = this.namedQueryMemento.toQuery(session, this.entityDescriptor.getMappedJavaType().getJavaTypeClass());
        query.setParameter((Parameter)query.getParameters().iterator().next(), pkValue);
        query.setHibernateFlushMode(FlushMode.MANUAL);
        return ((ReactiveSelectionQuery)query).reactiveUnique();
    }

    public CompletionStage<T> load(Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        if (entityInstance != null) {
            throw new UnsupportedOperationException("null entity instance");
        }
        return this.load(pkValue, lockOptions, readOnly, session);
    }

    @Override
    public CompletionStage<Object[]> reactiveLoadDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        return EMPTY_ARRAY_STAGE;
    }
}

