/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.SingleIdEntityLoaderStandardImpl;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.reactive.loader.ast.internal.DatabaseSnapshotExecutor;
import org.hibernate.reactive.loader.ast.internal.ReactiveSingleIdLoadPlan;
import org.hibernate.reactive.loader.ast.spi.ReactiveSingleIdEntityLoader;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class ReactiveSingleIdEntityLoaderStandardImpl<T>
extends SingleIdEntityLoaderStandardImpl<CompletionStage<T>>
implements ReactiveSingleIdEntityLoader<T> {
    private DatabaseSnapshotExecutor databaseSnapshotExecutor;

    public ReactiveSingleIdEntityLoaderStandardImpl(EntityMappingType entityDescriptor, LoadQueryInfluencers loadQueryInfluencers) {
        super(entityDescriptor, loadQueryInfluencers, (lockOptions, influencers) -> ReactiveSingleIdEntityLoaderStandardImpl.createLoadPlan(entityDescriptor, lockOptions, influencers, influencers.getSessionFactory()));
    }

    @Override
    public CompletionStage<Object[]> reactiveLoadDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        if (this.databaseSnapshotExecutor == null) {
            this.databaseSnapshotExecutor = new DatabaseSnapshotExecutor(this.getLoadable(), this.sessionFactory);
        }
        return this.databaseSnapshotExecutor.loadDatabaseSnapshot(id, session);
    }

    public CompletionStage<T> load(Object key, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        ReactiveSingleIdLoadPlan loadPlan = (ReactiveSingleIdLoadPlan)this.resolveLoadPlan(lockOptions, session.getLoadQueryInfluencers(), session.getFactory());
        return (CompletionStage)loadPlan.load(key, readOnly, true, session);
    }

    public CompletionStage<T> load(Object key, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        ReactiveSingleIdLoadPlan loadPlan = (ReactiveSingleIdLoadPlan)this.resolveLoadPlan(lockOptions, session.getLoadQueryInfluencers(), session.getFactory());
        return loadPlan.load(key, entityInstance, readOnly, false, session);
    }

    private static <T> ReactiveSingleIdLoadPlan<T> createLoadPlan(EntityMappingType loadable, LockOptions lockOptions, LoadQueryInfluencers queryInfluencers, SessionFactoryImplementor sessionFactory) {
        JdbcParametersList.Builder jdbcParametersListBuilder = JdbcParametersList.newBuilder();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)loadable, null, (ModelPart)loadable.getIdentifierMapping(), null, (int)1, (LoadQueryInfluencers)queryInfluencers, (LockOptions)lockOptions, arg_0 -> ((JdbcParametersList.Builder)jdbcParametersListBuilder).add(arg_0), (SessionFactoryImplementor)sessionFactory);
        JdbcParametersList jdbcParameters = jdbcParametersListBuilder.build();
        return new ReactiveSingleIdLoadPlan(loadable, (ModelPart)loadable.getIdentifierMapping(), sqlAst, jdbcParameters, lockOptions, sessionFactory);
    }
}

