/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.logging.impl;

import jakarta.persistence.PersistenceException;
import java.sql.SQLWarning;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.cache.CacheException;
import org.hibernate.dialect.Dialect;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.reactive.logging.impl.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="HR")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Hibernate Reactive")
    public void startHibernateReactive();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Vert.x not detected, creating a new instance")
    public void creatingVertxInstance();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Vert.x instance stopped")
    public void vertxInstanceStopped();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="SQL Client URL [\u001b[34m%1$s\u001b[0m]")
    public void sqlClientUrl(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12, value="Selected driver (\u001b[32m\u2714\u001b[0m) [\u001b[34m%1$s\u001b[0m]")
    public void selectedDriver(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=13, value="Detected driver (\u001b[31m\u2717\u001b[0m) [%1$s]")
    public void detectedDriver(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=14, value="Prepared statement cache disabled")
    public void preparedStatementCacheDisabled();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15, value="Prepared statement cache max size: %1$d")
    public void preparedStatementCacheMaxSize(Comparable<Integer> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="Prepared statement cache SQL limit: %1$d")
    public void preparedStatementCacheSQLLimit(Integer var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17, value="Using SQL client configuration [%1$s]")
    public void sqlClientConfiguration(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18, value="Instantiating reactive pool: %1$s")
    public void instantiatingReactivePool(@FormatWith(value=ClassFormatter.class) Class<?> var1);

    @Message(id=19, value="database username not specified (set the property 'jakarta.persistence.jdbc.user', or include it as a parameter in the connection URL)")
    public HibernateException databaseUsernameNotSpecified();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=21, value="DDL command failed [%1$s]")
    public void ddlCommandFailed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=25, value="Connection pool size: %1$d")
    public void connectionPoolSize(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=26, value="Connection pool max wait queue size: %1$d")
    public void connectionPoolMaxWaitSize(Integer var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=27, value="Connection pool idle timeout: %1$d ms")
    public void connectionPoolIdleTimeout(Integer var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=28, value="Connection pool connection timeout: %1$d ms")
    public void connectionPoolTimeout(Integer var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=29, value="Connection pool cleaner period: %1$d ms")
    public void connectionPoolCleanerPeriod(Integer var1);

    @Message(id=31, value="More than one row with the given identifier was found: %1$s, for class: %2$s")
    public HibernateException moreThanOneRowWithTheGivenIdentifier(Object var1, String var2);

    @Message(id=32, value="Could not instantiate SQL client pool configuration [%1$s]")
    public HibernateException couldNotInstantiatePoolConfiguration(String var1, @Cause Throwable var2);

    @Message(id=33, value="Unable to locate row for retrieval of generated properties: %1$s")
    public HibernateException unableToRetrieveGeneratedProperties(String var1);

    @Message(id=34, value="The database returned no natively generated identity value")
    public HibernateException noNativelyGeneratedValueReturned();

    @Message(id=35, value="The database can only generate identifiers of type Long")
    public HibernateException nativelyGeneratedValueMustBeLong();

    @Message(id=356, value="Wrong entity type!")
    public HibernateException wrongEntityType();

    @Message(id=36, value="firstResult/maxResults specified with collection fetch. In memory pagination was about to be applied. Failing because 'Fail on pagination over collection fetch' is enabled.")
    public HibernateException firstOrMaxResultsFailedBecausePaginationOverCollectionIsEnabled();

    @Message(id=37, value="Reactive sessions do not support transparent lazy fetching - use Session.fetch() (entity '%1$s' with id '%2$s' was not loaded)")
    public LazyInitializationException lazyInitializationException(String var1, Object var2);

    @Message(id=38, value="Entity [%1$s] did not define a natural id")
    public HibernateException entityDidNotDefinedNaturalId(String var1);

    @Message(id=39, value="Flush during cascade is dangerous")
    public HibernateException flushDuringCascadeIsDangerous();

    @Message(id=40, value="An immutable natural identifier of entity %1$s was altered from %2$s to %3$s")
    public HibernateException immutableNaturalIdentifierAltered(String var1, String var2, String var3);

    @Message(id=41, value="Identifier of an instance of %1$s was altered from %2$s to %3$s")
    public HibernateException identifierAltered(String var1, Object var2, Object var3);

    @Message(id=42, value="Merge requested with id not matching id of passed entity")
    public HibernateException mergeRequestedIdNotMatchingIdOfPassedEntity();

    @Message(id=43, value="Unable to locate persister: %1$s")
    public HibernateException unableToLocatePersister(String var1);

    @Message(id=44, value="Invalid lock mode for lock()")
    public HibernateException invalidLockModeForLock();

    @Message(id=45, value="Collection was evicted")
    public HibernateException collectionWasEvicted();

    @Message(id=46, value="Unexpected batch size spread")
    public HibernateException unexpectedBatchSizeSpread();

    @Message(id=47, value="Generated identifier smaller or equal to 0: %1$d")
    public HibernateException generatedIdentifierSmallerOrEqualThanZero(Long var1);

    @Message(id=48, value="Could not determine Dialect from JDBC driver metadata (specify a connection URI with scheme 'postgresql:', 'mysql:', 'cockroachdb', or 'db2:')")
    public HibernateException couldNotDetermineDialectFromJdbcDriverMetadata();

    @Message(id=49, value="Could not determine Dialect from connection URI: '%1$s' (specify a connection URI with scheme 'postgresql:', 'mysql:', 'cockroachdb', or 'db2:')")
    public HibernateException couldNotDetermineDialectFromConnectionURI(String var1);

    @Message(id=50, value="SelectGenerator is not supported in Hibernate Reactive")
    public HibernateException selectGeneratorIsNotSupportedInHibernateReactive();

    @Message(id=51, value="Cannot generate identifiers of type %1$S for: %2$s")
    public HibernateException cannotGenerateIdentifiersOfType(String var1, String var2);

    @Message(id=52, value="Generated identifier for %1$s too big to be assigned to a field of type %2$s: %3$s")
    public HibernateException generatedIdentifierTooBigForTheField(String var1, String var2, Long var3);

    @Message(id=53, value="Could not locate EntityEntry immediately after two-phase load")
    public HibernateException couldNotLocateEntityEntryAfterTwoPhaseLoad();

    @Message(id=54, value="Cannot recreate collection while filter is enabled: %1$s")
    public HibernateException cannotRecreateCollectionWhileFilterIsEnabled(String var1);

    @Message(id=55, value="Session closed")
    public LazyInitializationException sessionClosedLazyInitializationException();

    @Message(id=56, value="Collection cannot be initialized: %1$s - Fetch the collection using 'Mutiny.fetch', 'Stage.fetch', or 'fetch join' in HQL")
    public LazyInitializationException collectionCannotBeInitializedlazyInitializationException(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=57, value="Failed to execute statement [%1$s]: %2$s")
    public void failedToExecuteStatement(String var1, String var2, @Cause Throwable var3);

    @Message(id=58, value="Impossible flush mode")
    public IllegalStateException impossibleFlushModeIllegalState();

    @Message(id=59, value="Number of results is greater than number of batched parameters")
    public IllegalStateException numberOfResultsGreaterThanBatchedParameters();

    @Message(id=60, value="Session is closed")
    public IllegalStateException sessionIsClosed();

    @Message(id=61, value="Session is currently connecting to database")
    public IllegalStateException sessionIsConnectingToTheDatabase();

    @Message(id=62, value="Updating immutable entity that is not in session yet!")
    public IllegalStateException updatingImmutableEntityThatsNotInTheSession();

    @Message(id=63, value="Entity has status Status.DELETED but values != entry.getDeletedState")
    public IllegalStateException entityDeleteStateIllegal();

    @Message(id=64, value="Number of return values [%1$s] did not match expected [%2$s]")
    public IllegalStateException unexpectedNumberOfReturnedValues(int var1, int var2);

    @Message(id=65, value="No Vert.x context active")
    public IllegalStateException notVertxContextActive();

    @Message(id=66, value="Unknown structure type")
    public IllegalStateException unknownStructureType();

    @Message(id=67, value="Service not initialized")
    public IllegalStateException serviceNotInitialized();

    @Message(id=68, value="This method should exclusively be invoked from a Vert.x EventLoop thread; currently running on thread '%1$s'")
    public IllegalStateException shouldBeInvokedInVertxEventLoopThread(String var1);

    @Message(id=69, value="Detected use of the reactive Session from a different Thread than the one which was used to open the reactive Session - this suggests an invalid integration; original thread [%1$s]: '%2$s' current Thread [%3$s]: '%4$s'")
    public IllegalStateException detectedUsedOfTheSessionOnTheWrongThread(long var1, String var3, long var4, String var6);

    @Message(id=70, value="Unable to locate persistence units")
    public PersistenceException unableToLocatePersistenceUnits(@Cause Throwable var1);

    @Message(id=71, value="No name provided and multiple persistence units found")
    public PersistenceException noNameProvidedAndMultiplePersistenceUnitsFound();

    @Message(id=72, value="Cannot update an uninitialized proxy. Make sure to fetch the value before trying to update it: %1$s")
    public HibernateException uninitializedProxyUpdate(Object var1);

    @Message(id=73, value="%1$s is an invalid identity type when using CockroachDB (entity %2$s) - CockroachDB might generates identifiers that are too big and won't always fit in a %1$s. java.lang.Long is valid replacement")
    public HibernateException invalidIdentifierTypeForCockroachDB(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=74, value="ids for this class must be manually assigned before calling save(): %1$s")
    public IdentifierGenerationException idMustBeAssignedBeforeSave(String var1);

    @Message(id=75, value="Detected call to non reactive method. Alternative reactive method: `%1$s`")
    public HibernateException nonReactiveMethodCall(String var1);

    @Message(id=76, value="This method has not been implemented yet")
    public HibernateException notYetImplemented();

    @Message(id=77, value="Unable to execute post-insert id selection query: %1$s")
    public HibernateException unableToExecutePostInsertIdSelectionQuery(String var1, @Cause Throwable var2);

    @Message(id=78, value="Unable to bind parameters for post-insert id selection query: %1$s")
    public HibernateException bindParametersForPostInsertIdSelectQueryError(String var1, @Cause Throwable var2);

    @Message(id=79, value="The configuration property '%1$s' was not provided, or is in invalid format. This is required when using the default DefaultSqlClientPool: either provide the configuration setting or integrate with a different SqlClientPool implementation")
    public HibernateException blankConnectionString(String var1);

    @Message(id=80, value="No results were returned by the query (you can try running it with '.executeUpdate()'): %1$s")
    public HibernateException noResultException(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=104, value="firstResult/maxResults specified with collection fetch; applying in memory!")
    public void firstOrMaxResultsSpecifiedWithCollectionFetch();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=114, value="Handling transient entity in delete processing")
    public void handlingTransientEntity();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=180, value="FirstResult/maxResults specified on polymorphic query; applying in memory!")
    public void needsLimit();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=245, value="Manipulation query [%s] resulted in [%s] split queries")
    public void splitQueries(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=327, value="Error performing load command")
    public void unableToLoadCommand(@Cause HibernateException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=353, value="Could not release a cache lock : %s")
    public void unableToReleaseCacheLock(CacheException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400, value="Changing dialect '%1$s' to '%2$s'")
    public void replacingDialect(Dialect var1, Dialect var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=447, value="Explicit use of UPGRADE_SKIPLOCKED in lock() calls is not recommended; use normal UPGRADE locking instead")
    public void explicitSkipLockedLockCombo();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=448, value="Warnings creating temp table : %s")
    public void warningsCreatingTempTable(SQLWarning var1);
}

