/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.collection.impl;

import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.mapping.Collection;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.loader.ast.internal.ReactiveCollectionLoader;
import org.hibernate.reactive.loader.ast.internal.ReactiveCollectionLoaderSubSelectFetch;
import org.hibernate.reactive.persister.collection.impl.ReactiveAbstractCollectionPersister;
import org.hibernate.reactive.persister.collection.mutation.ReactiveDeleteRowsCoordinator;
import org.hibernate.reactive.persister.collection.mutation.ReactiveDeleteRowsCoordinatorNoOp;
import org.hibernate.reactive.persister.collection.mutation.ReactiveDeleteRowsCoordinatorStandard;
import org.hibernate.reactive.persister.collection.mutation.ReactiveInsertRowsCoordinator;
import org.hibernate.reactive.persister.collection.mutation.ReactiveInsertRowsCoordinatorNoOp;
import org.hibernate.reactive.persister.collection.mutation.ReactiveInsertRowsCoordinatorStandard;
import org.hibernate.reactive.persister.collection.mutation.ReactiveRemoveCoordinator;
import org.hibernate.reactive.persister.collection.mutation.ReactiveRemoveCoordinatorNoOp;
import org.hibernate.reactive.persister.collection.mutation.ReactiveRemoveCoordinatorStandard;
import org.hibernate.reactive.persister.collection.mutation.ReactiveUpdateRowsCoordinator;
import org.hibernate.reactive.persister.collection.mutation.ReactiveUpdateRowsCoordinatorNoOp;
import org.hibernate.reactive.persister.collection.mutation.ReactiveUpdateRowsCoordinatorOneToMany;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class ReactiveOneToManyPersister
extends OneToManyPersister
implements ReactiveAbstractCollectionPersister {
    private final ReactiveInsertRowsCoordinator insertRowsCoordinator = this.buildInsertCoordinator();
    private final ReactiveUpdateRowsCoordinator updateRowsCoordinator = this.buildUpdateCoordinator();
    private final ReactiveDeleteRowsCoordinator deleteRowsCoordinator = this.buildDeleteCoordinator();
    private final ReactiveRemoveCoordinator removeCoordinator = this.buildDeleteAllCoordinator();

    public ReactiveOneToManyPersister(Collection collectionBinding, CollectionDataAccess cacheAccessStrategy, RuntimeModelCreationContext creationContext) throws MappingException, CacheException {
        super(collectionBinding, cacheAccessStrategy, creationContext);
    }

    @Override
    public CollectionLoader createNamedQueryCollectionLoader(CollectionPersister persister, NamedQueryMemento namedQueryMemento) {
        return ReactiveAbstractCollectionPersister.super.createNamedQueryCollectionLoader(persister, namedQueryMemento);
    }

    @Override
    public CollectionLoader createSingleKeyCollectionLoader(LoadQueryInfluencers loadQueryInfluencers) {
        return ReactiveAbstractCollectionPersister.super.createSingleKeyCollectionLoader(loadQueryInfluencers);
    }

    public ReactiveInsertRowsCoordinator getInsertRowsCoordinator() {
        return this.insertRowsCoordinator;
    }

    public ReactiveUpdateRowsCoordinator getUpdateRowsCoordinator() {
        return this.updateRowsCoordinator;
    }

    public ReactiveDeleteRowsCoordinator getDeleteRowsCoordinator() {
        return this.deleteRowsCoordinator;
    }

    public ReactiveRemoveCoordinator getRemoveCoordinator() {
        return this.removeCoordinator;
    }

    private ReactiveInsertRowsCoordinator buildInsertCoordinator() {
        if (this.isInverse() || !this.isRowInsertEnabled()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection (re)creation - %s", (Object)this.getRolePath());
            }
            return new ReactiveInsertRowsCoordinatorNoOp((CollectionMutationTarget)this);
        }
        return new ReactiveInsertRowsCoordinatorStandard((CollectionMutationTarget)this, this.getRowMutationOperations());
    }

    private ReactiveUpdateRowsCoordinator buildUpdateCoordinator() {
        if (!this.isRowDeleteEnabled() && !this.isRowInsertEnabled()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection row updates - %s", (Object)this.getRolePath());
            }
            return new ReactiveUpdateRowsCoordinatorNoOp((CollectionMutationTarget)this);
        }
        return new ReactiveUpdateRowsCoordinatorOneToMany((CollectionMutationTarget)this, this.getRowMutationOperations(), this.getFactory());
    }

    private ReactiveDeleteRowsCoordinator buildDeleteCoordinator() {
        if (!this.needsRemove()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection row deletions - %s", (Object)this.getRolePath());
            }
            return new ReactiveDeleteRowsCoordinatorNoOp((CollectionMutationTarget)this);
        }
        return new ReactiveDeleteRowsCoordinatorStandard((CollectionMutationTarget)this, this.getRowMutationOperations(), false, (ServiceRegistry)this.getFactory().getServiceRegistry());
    }

    private ReactiveRemoveCoordinator buildDeleteAllCoordinator() {
        if (!this.needsRemove()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection removals - %s", (Object)this.getRolePath());
            }
            return new ReactiveRemoveCoordinatorNoOp((CollectionMutationTarget)this);
        }
        return new ReactiveRemoveCoordinatorStandard((CollectionMutationTarget)this, arg_0 -> ((ReactiveOneToManyPersister)this).buildDeleteAllOperation(arg_0), (ServiceRegistry)this.getFactory().getServiceRegistry());
    }

    protected CollectionLoader createSubSelectLoader(SubselectFetch subselect, SharedSessionContractImplementor session) {
        return new ReactiveCollectionLoaderSubSelectFetch(this.getAttributeMapping(), null, subselect, session);
    }

    @Override
    public CompletionStage<Void> reactiveInitialize(Object key, SharedSessionContractImplementor session) {
        return ((ReactiveCollectionLoader)this.determineLoaderToUse(key, session)).reactiveLoad(key, session).thenCompose(CompletionStages::voidFuture);
    }

    @Override
    public boolean isRowDeleteEnabled() {
        return super.isRowDeleteEnabled();
    }

    @Override
    public boolean isRowInsertEnabled() {
        return super.isRowInsertEnabled();
    }

    private CompletionStage<Void> writeIndex(PersistentCollection<?> collection, Iterator<?> entries, Object key, boolean resetIndex, SharedSessionContractImplementor session) {
        boolean doWrite;
        if (!entries.hasNext()) {
            return CompletionStages.voidFuture();
        }
        boolean bl = doWrite = this.isInverse && this.hasIndex() && !this.indexContainsFormula && ArrayHelper.countTrue((boolean[])this.indexColumnIsSettable) > 0;
        if (!doWrite) {
            return CompletionStages.voidFuture();
        }
        JdbcMutationOperation updateRowOperation = this.getRowMutationOperations().getUpdateRowOperation();
        RowMutationOperations.Values updateRowValues = this.getRowMutationOperations().getUpdateRowValues();
        RowMutationOperations.Restrictions updateRowRestrictions = this.getRowMutationOperations().getUpdateRowRestrictions();
        assert (NullnessHelper.areAllNonNull((Object[])new Object[]{updateRowOperation, updateRowValues, updateRowRestrictions}));
        ReactiveMutationExecutor mutationExecutor = this.reactiveMutationExecutor(session, updateRowOperation);
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        return CompletionStages.voidFuture().thenCompose(unused -> {
            int[] nextIndex = new int[]{resetIndex ? 0 : this.getSize(key, session)};
            return CompletionStages.loop(entries, (entry, integer) -> {
                if (entry != null && collection.entryExists(entry, nextIndex[0])) {
                    updateRowValues.applyValues(collection, key, entry, nextIndex[0], session, jdbcValueBindings);
                    updateRowRestrictions.applyRestrictions(collection, key, entry, nextIndex[0], session, jdbcValueBindings);
                    return mutationExecutor.executeReactive(collection, null, null, null, session).thenAccept(o -> {
                        nextIndex[0] = nextIndex[0] + 1;
                    });
                }
                return CompletionStages.voidFuture();
            });
        }).whenComplete((o, throwable) -> mutationExecutor.release());
    }

    private ReactiveMutationExecutor reactiveMutationExecutor(SharedSessionContractImplementor session, JdbcMutationOperation updateRowOperation) {
        MutationExecutorService mutationExecutorService = (MutationExecutorService)this.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        return (ReactiveMutationExecutor)mutationExecutorService.createExecutor(this::getBasicBatchKey, MutationOperationGroupFactory.singleOperation((MutationType)MutationType.UPDATE, (MutationTarget)this, (MutationOperation)updateRowOperation), session);
    }

    private BasicBatchKey getBasicBatchKey() {
        return new BasicBatchKey(this.getNavigableRole() + "#INDEX");
    }

    @Override
    public CompletionStage<Void> reactiveRecreate(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) throws HibernateException {
        return this.getInsertRowsCoordinator().reactiveInsertRows(collection, id, (arg_0, arg_1, arg_2, arg_3) -> collection.includeInRecreate(arg_0, arg_1, arg_2, arg_3), session).thenCompose(unused -> this.writeIndex(collection, collection.entries((CollectionPersister)this), id, true, session));
    }

    @Override
    public CompletionStage<Void> reactiveInsertRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) throws HibernateException {
        return this.getInsertRowsCoordinator().reactiveInsertRows(collection, id, (arg_0, arg_1, arg_2, arg_3) -> collection.includeInInsert(arg_0, arg_1, arg_2, arg_3), session).thenCompose(unused -> this.writeIndex(collection, collection.entries((CollectionPersister)this), id, true, session));
    }

    @Override
    public CompletionStage<Void> reactiveUpdateRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) {
        return this.getUpdateRowsCoordinator().reactiveUpdateRows(id, collection, session);
    }

    @Override
    public CompletionStage<Void> reactiveDeleteRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) {
        return this.getDeleteRowsCoordinator().reactiveDeleteRows(collection, id, session);
    }

    @Override
    public CompletionStage<Void> reactiveRemove(Object id, SharedSessionContractImplementor session) {
        return this.getRemoveCoordinator().reactiveDeleteAllRows(id, session);
    }
}

