/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.mutation;

import java.util.concurrent.CompletionStage;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.reactive.mutiny.impl.MutinySessionFactoryImpl;
import org.hibernate.reactive.mutiny.impl.MutinySessionImpl;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.stage.impl.StageSessionImpl;
import org.hibernate.reactive.tuple.MutinyGenerator;
import org.hibernate.reactive.tuple.StageGenerator;
import org.hibernate.reactive.util.impl.CompletionStages;

final class GeneratorValueUtil {
    private GeneratorValueUtil() {
    }

    static CompletionStage<?> generateValue(SharedSessionContractImplementor session, Object entity, Object currentValue, BeforeExecutionGenerator generator, EventType eventType) {
        if (generator instanceof StageGenerator) {
            StageSessionImpl stageSession = new StageSessionImpl((ReactiveSession)session);
            return ((StageGenerator)generator).generate(stageSession, entity, currentValue, eventType);
        }
        if (generator instanceof MutinyGenerator) {
            MutinySessionFactoryImpl mutinyFactory = new MutinySessionFactoryImpl((SessionFactoryImpl)session.getFactory());
            MutinySessionImpl mutinySession = new MutinySessionImpl((ReactiveSession)session, mutinyFactory);
            return ((MutinyGenerator)generator).generate(mutinySession, entity, currentValue, eventType).subscribeAsCompletionStage();
        }
        return CompletionStages.completedFuture(generator.generate(session, entity, currentValue, eventType));
    }
}

