/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.service;

import java.lang.invoke.MethodHandles;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.hibernate.boot.model.TruthValue;
import org.hibernate.boot.model.naming.DatabaseIdentifier;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.tool.schema.extract.internal.AbstractInformationExtractorImpl;
import org.hibernate.tool.schema.extract.internal.ColumnInformationImpl;
import org.hibernate.tool.schema.extract.spi.ColumnInformation;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.TableInformation;

public abstract class AbstractReactiveInformationSchemaBasedExtractorImpl
extends AbstractInformationExtractorImpl {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public AbstractReactiveInformationSchemaBasedExtractorImpl(ExtractionContext extractionContext) {
        super(extractionContext);
    }

    protected String getResultSetCatalogLabel() {
        return this.normalizeLabel(super.getResultSetCatalogLabel());
    }

    protected String getResultSetSchemaLabel() {
        return this.normalizeLabel(super.getResultSetSchemaLabel());
    }

    protected String getResultSetTableNameLabel() {
        return this.normalizeLabel(super.getResultSetTableNameLabel());
    }

    protected String getResultSetTableTypeLabel() {
        return this.normalizeLabel(super.getResultSetTableTypeLabel());
    }

    protected String getResultSetRemarksLabel() {
        return this.normalizeLabel(super.getResultSetRemarksLabel());
    }

    protected String getResultSetColumnNameLabel() {
        return this.normalizeLabel(super.getResultSetColumnNameLabel());
    }

    protected String getResultSetSqlTypeCodeLabel() {
        return this.normalizeLabel(super.getResultSetSqlTypeCodeLabel());
    }

    protected String getResultSetTypeNameLabel() {
        return this.normalizeLabel(super.getResultSetTypeNameLabel());
    }

    protected String getResultSetColumnSizeLabel() {
        return this.normalizeLabel(super.getResultSetColumnSizeLabel());
    }

    protected String getResultSetDecimalDigitsLabel() {
        return this.normalizeLabel(super.getResultSetDecimalDigitsLabel());
    }

    protected String getResultSetIsNullableLabel() {
        return this.normalizeLabel(super.getResultSetIsNullableLabel());
    }

    protected String getResultSetIndexTypeLabel() {
        return this.normalizeLabel(super.getResultSetIndexTypeLabel());
    }

    protected String getResultSetIndexNameLabel() {
        return this.normalizeLabel(super.getResultSetIndexNameLabel());
    }

    protected String getResultSetForeignKeyLabel() {
        return this.normalizeLabel(super.getResultSetForeignKeyLabel());
    }

    protected String getResultSetPrimaryKeyNameLabel() {
        return this.normalizeLabel(super.getResultSetPrimaryKeyNameLabel());
    }

    protected String getResultSetColumnPositionColumn() {
        return this.normalizeLabel(super.getResultSetColumnPositionColumn());
    }

    protected String getResultSetPrimaryKeyColumnNameLabel() {
        return this.normalizeLabel(super.getResultSetPrimaryKeyColumnNameLabel());
    }

    protected String getResultSetForeignKeyColumnNameLabel() {
        return this.normalizeLabel(super.getResultSetForeignKeyColumnNameLabel());
    }

    protected String getResultSetPrimaryKeyCatalogLabel() {
        return this.normalizeLabel(super.getResultSetPrimaryKeyCatalogLabel());
    }

    protected String getResultSetPrimaryKeySchemaLabel() {
        return this.normalizeLabel(super.getResultSetPrimaryKeySchemaLabel());
    }

    protected String getResultSetPrimaryKeyTableLabel() {
        return this.normalizeLabel(super.getResultSetPrimaryKeyTableLabel());
    }

    private String normalizeLabel(String columnLabel) {
        return this.toMetaDataObjectName(Identifier.toIdentifier((String)columnLabel));
    }

    protected String getResultSetTableTypesPhysicalTableConstant() {
        return "BASE TABLE";
    }

    protected <T> T processCatalogsResultSet(ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        return (T)this.getExtractionContext().getQueryResults(String.format("select catalog_name as %s from information_schema.information_schema_catalog_name", this.getResultSetCatalogLabel()), null, processor);
    }

    protected <T> T processCrossReferenceResultSet(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable, ExtractionContext.ResultSetProcessor<T> processor) {
        throw LOG.notYetImplemented();
    }

    protected <T> T processSchemaResultSet(String catalog, String schemaPattern, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        StringBuilder sb = new StringBuilder().append("select catalog_name as ").append(this.getResultSetCatalogLabel()).append(" , schema_name as ").append(this.getResultSetSchemaLabel()).append(" from information_schema.schemata where 1 = 1");
        ArrayList<Object> parameters = new ArrayList<Object>();
        this.appendClauseAndParameterIfNotNullOrEmpty(" and catalog_name = ", catalog, sb, parameters);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and schema_name like ", schemaPattern, sb, parameters);
        return (T)this.getExtractionContext().getQueryResults(sb.toString(), parameters.toArray(), processor);
    }

    protected boolean appendClauseAndParameterIfNotNullOrEmpty(String clause, Object parameter, StringBuilder sb, List<Object> parameters) {
        if (!(parameter == null || String.class.isInstance(parameter) && ((String)parameter).isEmpty())) {
            parameters.add(parameter);
            sb.append(clause);
            sb.append("?");
            return true;
        }
        return false;
    }

    protected <T> T processTableResultSet(String catalog, String schemaPattern, String tableNamePattern, String[] types, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        String catalogColumn = this.getDatabaseCatalogColumnName("table_catalog", "table_schema");
        String schemaColumn = this.getDatabaseSchemaColumnName("table_catalog", "table_schema");
        StringBuilder sb = new StringBuilder().append("select ").append(catalogColumn).append(" as ").append(this.getResultSetCatalogLabel()).append(" , ").append(schemaColumn).append(" as ").append(this.getResultSetSchemaLabel()).append(" , table_name as ").append(this.getResultSetTableNameLabel()).append(" , table_type as ").append(this.getResultSetTableTypeLabel()).append(" , null as ").append(this.getResultSetRemarksLabel()).append(" from information_schema.tables where 1 = 1");
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        this.appendClauseAndParameterIfNotNullOrEmpty(" and " + catalogColumn + " = ", catalog, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and " + schemaColumn + " like ", schemaPattern, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and table_name like ", tableNamePattern, sb, parameterValues);
        if (types != null && types.length > 0) {
            this.appendClauseAndParameterIfNotNullOrEmpty(" and table_type in ( ", types[0].equals("TABLE") ? this.getResultSetTableTypesPhysicalTableConstant() : types[0], sb, parameterValues);
            for (int i = 1; i < types.length; ++i) {
                this.appendClauseAndParameterIfNotNullOrEmpty(", ", types[i].equals("TABLE") ? this.getResultSetTableTypesPhysicalTableConstant() : types[i], sb, parameterValues);
            }
            sb.append(" ) ");
        }
        return (T)this.getExtractionContext().getQueryResults(sb.toString(), parameterValues.toArray(), processor);
    }

    protected <T> T processColumnsResultSet(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        StringBuilder sb = new StringBuilder().append("select table_name as ").append(this.getResultSetTableNameLabel()).append(", column_name as ").append(this.getResultSetColumnNameLabel()).append(", ").append(" case when ").append(this.getInformationSchemaColumnsDataTypeColumn()).append(" = 'bpchar' then 'CHAR' else ").append(this.getInformationSchemaColumnsDataTypeColumn()).append(" end as ").append(this.getResultSetTypeNameLabel()).append(", null as ").append(this.getResultSetColumnSizeLabel()).append(", null as ").append(this.getResultSetDecimalDigitsLabel()).append(", is_nullable as ").append(this.getResultSetIsNullableLabel()).append(", null as ").append(this.getResultSetSqlTypeCodeLabel()).append(" from information_schema.columns where 1 = 1");
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        String catalogColumn = this.getDatabaseCatalogColumnName("table_catalog", "table_schema");
        String schemaColumn = this.getDatabaseSchemaColumnName("table_catalog", "table_schema");
        this.appendClauseAndParameterIfNotNullOrEmpty(" and " + catalogColumn + " = ", catalog, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and " + schemaColumn + " like ", schemaPattern, sb, parameterValues);
        this.appendClauseAndParameterIfNotNullOrEmpty(" and table_name like ", tableNamePattern, sb, parameterValues);
        sb.append(" order by table_catalog, table_schema, table_name, column_name, ordinal_position");
        return (T)this.getExtractionContext().getQueryResults(sb.toString(), parameterValues.toArray(), processor);
    }

    protected String getInformationSchemaColumnsDataTypeColumn() {
        return "data_type";
    }

    protected String getDatabaseCatalogColumnName(String catalogColumnName, String schemaColumnName) {
        return catalogColumnName;
    }

    protected String getDatabaseSchemaColumnName(String catalogColumnName, String schemaColumnName) {
        return schemaColumnName;
    }

    protected void addExtractedColumnInformation(TableInformation tableInformation, ResultSet resultSet) throws SQLException {
        String typeName = new StringTokenizer(resultSet.getString(this.getResultSetTypeNameLabel()), "() ").nextToken();
        ColumnInformationImpl columnInformation = new ColumnInformationImpl(tableInformation, (Identifier)DatabaseIdentifier.toIdentifier((String)resultSet.getString(this.getResultSetColumnNameLabel())), this.dataTypeCode(typeName), typeName, resultSet.getInt(this.getResultSetColumnSizeLabel()), resultSet.getInt(this.getResultSetDecimalDigitsLabel()), this.interpretTruthValue(resultSet.getString(this.getResultSetIsNullableLabel())));
        tableInformation.addColumn((ColumnInformation)columnInformation);
    }

    protected int dataTypeCode(String typeName) {
        return 0;
    }

    private TruthValue interpretTruthValue(String nullable) {
        if ("yes".equalsIgnoreCase(nullable)) {
            return TruthValue.TRUE;
        }
        if ("no".equalsIgnoreCase(nullable)) {
            return TruthValue.FALSE;
        }
        return TruthValue.UNKNOWN;
    }
}

