/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.service;

import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveJdbcEnvironment;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class NoJdbcEnvironmentInitiator
implements StandardServiceInitiator<JdbcEnvironment> {
    public static final NoJdbcEnvironmentInitiator INSTANCE = new NoJdbcEnvironmentInitiator();

    public Class<JdbcEnvironment> getServiceInitiated() {
        return JdbcEnvironment.class;
    }

    public JdbcEnvironment initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        boolean explicitDialect = configurationValues.containsKey("hibernate.dialect");
        if (explicitDialect) {
            DialectFactory dialectFactory = (DialectFactory)registry.getService(DialectFactory.class);
            Dialect dialect = dialectFactory.buildDialect(configurationValues, null);
            return new ReactiveJdbcEnvironment(registry, dialect);
        }
        return new ReactiveJdbcEnvironment(registry, new DialectBuilder(configurationValues, (ServiceRegistry)registry).build());
    }

    private static class ReactiveDialectResolutionInfo
    implements DialectResolutionInfo {
        private final DatabaseMetadata metadata;

        private ReactiveDialectResolutionInfo(DatabaseMetadata metadata) {
            this.metadata = metadata;
        }

        public String getDatabaseName() {
            return this.metadata.productName();
        }

        public String getDatabaseVersion() {
            return this.metadata.fullVersion();
        }

        public int getDatabaseMajorVersion() {
            return this.metadata.majorVersion();
        }

        public int getDatabaseMinorVersion() {
            return this.metadata.minorVersion();
        }

        public String getDriverName() {
            return this.getDatabaseName();
        }

        public int getDriverMajorVersion() {
            return this.getDatabaseMajorVersion();
        }

        public int getDriverMinorVersion() {
            return this.getDatabaseMinorVersion();
        }

        public String getSQLKeywords() {
            return null;
        }

        public String toString() {
            return this.getDatabaseMajorVersion() + "." + this.getDatabaseMinorVersion();
        }
    }

    private static class CockroachDatabaseMetadata
    implements DatabaseMetadata {
        private final String fullversion;

        public CockroachDatabaseMetadata(String fullversion) {
            this.fullversion = fullversion;
        }

        public String productName() {
            return "CockroachDb";
        }

        public String fullVersion() {
            return this.fullversion;
        }

        public int majorVersion() {
            return 0;
        }

        public int minorVersion() {
            return 0;
        }
    }

    private static class DialectBuilder {
        private final Map<String, Object> configurationValues;
        private final ServiceRegistry registry;

        public DialectBuilder(Map<String, Object> configurationValues, ServiceRegistry registry) {
            this.configurationValues = configurationValues;
            this.registry = registry;
        }

        public Dialect build() {
            DialectFactory dialectFactory = (DialectFactory)this.registry.getService(DialectFactory.class);
            return dialectFactory.buildDialect(this.configurationValues, this::dialectResolutionInfo);
        }

        private DialectResolutionInfo dialectResolutionInfo() {
            ReactiveConnectionPool connectionPool = (ReactiveConnectionPool)this.registry.getService(ReactiveConnectionPool.class);
            return (DialectResolutionInfo)connectionPool.getConnection(new SqlExceptionHelper(true)).thenCompose(DialectBuilder::buildResolutionInfo).toCompletableFuture().join();
        }

        private static CompletionStage<ReactiveDialectResolutionInfo> buildResolutionInfo(ReactiveConnection connection) {
            DatabaseMetadata databaseMetadata = connection.getDatabaseMetadata();
            return DialectBuilder.resolutionInfoStage(connection, databaseMetadata).handle(CompletionStages::handle).thenCompose(handled -> {
                if (handled.hasFailed()) {
                    return connection.close().handle((unused, throwable) -> handled.getResultAsCompletionStage()).thenCompose(Function.identity());
                }
                return connection.close().thenCompose(v -> handled.getResultAsCompletionStage());
            });
        }

        private static CompletionStage<ReactiveDialectResolutionInfo> resolutionInfoStage(ReactiveConnection connection, DatabaseMetadata databaseMetadata) {
            if (databaseMetadata.productName().equalsIgnoreCase("PostgreSQL")) {
                return connection.select("select version()").thenApply(DialectBuilder::readFullVersion).thenApply(fullversion -> {
                    if (fullversion.startsWith("Cockroach")) {
                        return new CockroachDatabaseMetadata((String)fullversion);
                    }
                    return databaseMetadata;
                }).thenApply(x$0 -> new ReactiveDialectResolutionInfo((DatabaseMetadata)x$0));
            }
            return CompletionStages.completedFuture(new ReactiveDialectResolutionInfo(databaseMetadata));
        }

        private static String readFullVersion(ReactiveConnection.Result result) {
            return result.hasNext() ? (String)((Object[])result.next())[0] : "";
        }
    }
}

