/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.service;

import java.util.Map;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.internal.SessionFactoryBuilderImpl;
import org.hibernate.boot.internal.SessionFactoryOptionsBuilder;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderService;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.reactive.provider.service.ReactiveSessionFactoryBuilder;
import org.hibernate.service.spi.Configurable;

final class ReactiveSessionFactoryBuilderService
implements SessionFactoryBuilderService,
Configurable {
    private int batchSize;

    ReactiveSessionFactoryBuilderService() {
    }

    public void configure(Map configurationValues) {
        this.batchSize = ConfigurationHelper.getInt((String)"hibernate.jdbc.batch_size", (Map)configurationValues, (int)0);
    }

    public SessionFactoryBuilderImplementor createSessionFactoryBuilder(MetadataImpl metadata, BootstrapContext bootstrapContext) {
        SessionFactoryOptionsBuilder optionsBuilder = new SessionFactoryOptionsBuilder(metadata.getMetadataBuildingOptions().getServiceRegistry(), bootstrapContext);
        optionsBuilder.enableCollectionInDefaultFetchGroup(true);
        optionsBuilder.applyJdbcBatchSize(this.batchSize);
        return new ReactiveSessionFactoryBuilder((MetadataImplementor)metadata, (SessionFactoryBuilderImplementor)new SessionFactoryBuilderImpl((MetadataImplementor)metadata, optionsBuilder, metadata.getTypeConfiguration().getMetadataBuildingContext().getBootstrapContext()));
    }
}

