/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.Limit;
import org.hibernate.reactive.query.sqm.spi.ReactiveSelectQueryPlan;
import org.hibernate.reactive.util.impl.CompletionStages;

public class AggregatedSelectReactiveQueryPlan<R>
implements ReactiveSelectQueryPlan<R> {
    private final ReactiveSelectQueryPlan<R>[] aggregatedQueryPlans;

    public AggregatedSelectReactiveQueryPlan(ReactiveSelectQueryPlan<R>[] aggregatedQueryPlans) {
        this.aggregatedQueryPlans = aggregatedQueryPlans;
    }

    @Override
    public CompletionStage<List<R>> reactivePerformList(DomainQueryExecutionContext executionContext) {
        Limit effectiveLimit = executionContext.getQueryOptions().getEffectiveLimit();
        int maxRowsJpa = effectiveLimit.getMaxRowsJpa();
        if (maxRowsJpa == 0) {
            return CompletionStages.completedFuture(Collections.emptyList());
        }
        AtomicInteger elementsToSkip = new AtomicInteger(effectiveLimit.getFirstRowJpa());
        ArrayList overallResults = new ArrayList();
        return CompletionStages.whileLoop(this.aggregatedQueryPlans, reactivePlan -> reactivePlan.reactivePerformList(executionContext).thenApply(list -> AggregatedSelectReactiveQueryPlan.updateResults(elementsToSkip, maxRowsJpa, overallResults, list))).thenApply(v -> overallResults);
    }

    private static <R> boolean updateResults(AtomicInteger elementsToSkipAtomic, int maxRowsJpa, List<R> overallResults, List<R> list) {
        int size = list.size();
        if (size <= elementsToSkipAtomic.get()) {
            elementsToSkipAtomic.addAndGet(-size);
            return true;
        }
        int elementsToSkip = elementsToSkipAtomic.get();
        int availableElements = size - elementsToSkip;
        if (overallResults.size() + availableElements >= maxRowsJpa) {
            int end = elementsToSkip + (maxRowsJpa - overallResults.size());
            for (int i = elementsToSkip; i < end; ++i) {
                overallResults.add(list.get(i));
            }
            return false;
        }
        if (elementsToSkip > 0) {
            for (int i = availableElements; i < size; ++i) {
                overallResults.add(list.get(i));
            }
            elementsToSkipAtomic.set(0);
        } else {
            overallResults.addAll(list);
        }
        return true;
    }
}

