/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.mutation.internal.cte;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MatchingIdSelectionHelper;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.spi.JdbcParameterBySqmParameterAccess;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.reactive.query.sqm.mutation.spi.ReactiveAbstractMutationHandler;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public interface ReactiveAbstractCteMutationHandler
extends ReactiveAbstractMutationHandler {
    public CteTable getCteTable();

    public DomainParameterXref getDomainParameterXref();

    public CteMutationStrategy getStrategy();

    public void addDmlCtes(CteContainer var1, CteStatement var2, MultiTableSqmMutationConverter var3, Map<SqmParameter<?>, List<JdbcParameter>> var4, SessionFactoryImplementor var5);

    @Override
    default public CompletionStage<Integer> reactiveExecute(DomainQueryExecutionContext executionContext) {
        SqmDeleteOrUpdateStatement<?> sqmMutationStatement = this.getSqmDeleteOrUpdateStatement();
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        EntityMappingType entityDescriptor = this.getEntityDescriptor();
        String explicitDmlTargetAlias = sqmMutationStatement.getTarget().getExplicitAlias() == null ? "dml_target" : sqmMutationStatement.getTarget().getExplicitAlias();
        final MultiTableSqmMutationConverter sqmConverter = new MultiTableSqmMutationConverter(entityDescriptor, sqmMutationStatement, sqmMutationStatement.getTarget(), explicitDmlTargetAlias, this.getDomainParameterXref(), executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), (SqlAstCreationContext)factory);
        Map<Object, List<Object>> parameterResolutions = this.getDomainParameterXref().getSqmParameterCount() == 0 ? Collections.emptyMap() : new IdentityHashMap();
        Predicate restriction = sqmConverter.visitWhereClause(sqmMutationStatement.getWhereClause());
        sqmConverter.pruneTableGroupJoins();
        CteStatement idSelectCte = new CteStatement(this.getCteTable(), (Statement)MatchingIdSelectionHelper.generateMatchingIdSelectStatement((EntityMappingType)entityDescriptor, sqmMutationStatement, (boolean)true, (Predicate)restriction, (MultiTableSqmMutationConverter)sqmConverter, (DomainQueryExecutionContext)executionContext, (SessionFactoryImplementor)factory), CteMaterialization.MATERIALIZED);
        QuerySpec querySpec = new QuerySpec(true, 1);
        ArrayList<BasicResult> domainResults = new ArrayList<BasicResult>(1);
        SelectStatement statement = new SelectStatement((QueryPart)querySpec, domainResults);
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstTranslator translator = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(factory, statement);
        Expression count = this.createCountStar(factory, sqmConverter);
        domainResults.add(new BasicResult(0, null, ((SqlExpressible)count).getJdbcMapping()));
        querySpec.getSelectClause().addSqlSelection((SqlSelection)new SqlSelectionImpl(0, count));
        querySpec.getFromClause().addRoot((TableGroup)new CteTableGroup(new NamedTableReference(idSelectCte.getCteTable().getTableExpression(), "id")));
        statement.addCteStatement(idSelectCte);
        this.addDmlCtes((CteContainer)statement, idSelectCte, sqmConverter, parameterResolutions, factory);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings((QueryParameterBindings)executionContext.getQueryParameterBindings(), (DomainParameterXref)this.getDomainParameterXref(), (Map)SqmUtil.generateJdbcParamsXref((DomainParameterXref)this.getDomainParameterXref(), (JdbcParameterBySqmParameterAccess)sqmConverter), (MappingMetamodel)factory.getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> sqmConverter.getMutatingTableGroup(), (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)sqmConverter.getSqmParameterMappingModelExpressibleResolutions().get(parameter);
            }
        }, (SharedSessionContractImplementor)executionContext.getSession());
        LockOptions lockOptions = executionContext.getQueryOptions().getLockOptions();
        LockMode lockMode = lockOptions.getAliasSpecificLockMode(explicitDmlTargetAlias);
        lockOptions.setAliasSpecificLockMode(explicitDmlTargetAlias, LockMode.WRITE);
        JdbcOperationQuerySelect select = (JdbcOperationQuerySelect)translator.translate(jdbcParameterBindings, executionContext.getQueryOptions());
        lockOptions.setAliasSpecificLockMode(explicitDmlTargetAlias, lockMode);
        return ((ReactiveSession)executionContext.getSession()).reactiveAutoFlushIfRequired(select.getAffectedTableNames()).thenCompose(v -> StandardReactiveSelectExecutor.INSTANCE.list(select, jdbcParameterBindings, (ExecutionContext)SqmJdbcExecutionContextAdapter.omittingLockingAndPaging((DomainQueryExecutionContext)executionContext), row -> row[0], ReactiveListResultsConsumer.UniqueSemantic.NONE).thenApply(list -> ((Number)list.get(0)).intValue()));
    }

    public Expression createCountStar(SessionFactoryImplementor var1, MultiTableSqmMutationConverter var2);
}

